/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.model.datatypeconverters.ConverterUtils;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.UnsupportedEncodingException;

public class FMIExternalFloatConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FMIExternalFloatConverter.class);
    private static final String symbol = "FE";
    private static final String codepage = "IBM-037";
    private static final int MIN_EBCDIC_SIZE = 5;
    private static final int MAX_EBCDIC_SIZE = 22;
    private static final byte DEFAULT_NUMERIC = -16;
    private static final byte DEFAULT_SIGN = 78;
    private static FMIExternalFloatConverter theInstance = null;

    private static FEparams getFEparams(Object[] extraParams) {
        if (extraParams != null && extraParams.length == 2) {
            FEparams fe = new FEparams();
            fe.implied = (Boolean)extraParams[0];
            fe.decimalPos = (Integer)extraParams[1];
            return fe;
        }
        return null;
    }

    private FMIExternalFloatConverter() {
    }

    public static FMIExternalFloatConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIExternalFloatConverter();
        }
        return theInstance;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int mantissaSize;
        String exponentStr;
        int exp = 0;
        if (!this.validateASCII(asciiString, tgtWidth, extraParams)) {
            throw new FMIConversionException();
        }
        FEparams params = FMIExternalFloatConverter.getFEparams(extraParams);
        String mantissa = FMIExternalFloatConverter.getMantissaPart(asciiString);
        byte[] result = FMIExternalFloatConverter.buildEBCDIC(mantissa, exp = this.convertExponentPart(exponentStr = FMIExternalFloatConverter.getExponentPart(asciiString)), mantissaSize = FMIExternalFloatConverter.getMantissaSize(tgtWidth), params);
        if (result == null) {
            throw new FMIConversionException();
        }
        return result;
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        if (EBCDICval == null || EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        assert (EBCDICval != null && extraParams != null && maxStrLength > 0 && maxStrLength >= EBCDICval.length);
        FEparams params = FMIExternalFloatConverter.getFEparams(extraParams);
        Object tmp = ConverterUtils.decodeBytes(EBCDICval, Character.toString('\u25ad'), codepage);
        int actualLen = EBCDICval.length;
        if (actualLen < maxStrLength - 1) {
            throw new FMIConversionException();
        }
        boolean valid = this.validateStrictEBCDICFormat((String)tmp, actualLen, params);
        if (!valid) {
            throw new FMIConversionException();
        }
        if (params != null && params.implied) {
            int startNdx = ((String)tmp).indexOf(69);
            --startNdx;
            String part1 = ((String)tmp).substring(0, startNdx -= params.decimalPos);
            String part2 = ((String)tmp).substring(startNdx);
            tmp = part1 + "." + part2;
        }
        return tmp;
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        return asciiString;
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        FEparams params = FMIExternalFloatConverter.getFEparams(extraParams);
        byte[] newBytes = new byte[length];
        newBytes[length - 1] = -16;
        newBytes[length - 2] = -16;
        newBytes[length - 3] = 78;
        newBytes[length - 4] = -59;
        int i = 0;
        while (i < length - 4) {
            newBytes[i] = -16;
            ++i;
        }
        if (params != null && !params.implied && params.decimalPos != -1) {
            newBytes[params.decimalPos] = 75;
        }
        newBytes[0] = 78;
        return newBytes;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        FEparams parms = FMIExternalFloatConverter.getFEparams(extraParams);
        if (parms != null && parms.implied) {
            return ebcdicWidth + 1;
        }
        return ebcdicWidth;
    }

    @Override
    public String getSymbol() {
        return symbol;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean validateASCII(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (tgtWidth < 5 || tgtWidth > 22) {
            throw new FMIConversionException();
        }
        boolean validSyntax = false;
        int Epos = -1;
        int Ecount = 0;
        int i = 0;
        while (i < asciiString.length()) {
            char c = asciiString.charAt(i);
            if (c == 'E') {
                Epos = i;
                ++Ecount;
            }
            ++i;
        }
        if (Ecount > 1) {
            return false;
        }
        if (Epos != -1) {
            String mantissa = FMIExternalFloatConverter.getMantissaPart(asciiString);
            String exponent = FMIExternalFloatConverter.getExponentPart(asciiString);
            validSyntax = FMIExternalFloatConverter.validateMantissaSyntax(mantissa);
            validSyntax &= FMIExternalFloatConverter.validateExponentUserInputSyntax(exponent);
        } else {
            validSyntax = FMIExternalFloatConverter.validateMantissaSyntax(asciiString);
        }
        return validSyntax;
    }

    private static int getMantissaSize(int byteCount) {
        if (byteCount <= 5) {
            return 0;
        }
        return byteCount - 5;
    }

    private static boolean validSignEBCDICFormat(char c) {
        return c == '+' || c == '-' || c == ' ';
    }

    private static boolean validateMantissaSyntax(String mantissa) {
        StringBuffer mantissaString = new StringBuffer(mantissa);
        if (mantissa == null || mantissa.isEmpty()) {
            return false;
        }
        boolean sign = false;
        char leadChar = mantissaString.charAt(0);
        if (leadChar == '+' || leadChar == '-') {
            sign = true;
            mantissaString.deleteCharAt(0);
        } else if (Character.isDigit(leadChar) || leadChar == '.') {
            sign = false;
        } else {
            return false;
        }
        boolean decimal = false;
        boolean hasDigit = false;
        int i = 0;
        while (i < mantissaString.length()) {
            char c = mantissaString.charAt(i);
            if (c == '.') {
                if (decimal) {
                    return false;
                }
                decimal = true;
            } else {
                if (!Character.isDigit(c)) {
                    return false;
                }
                hasDigit = true;
            }
            ++i;
        }
        return !sign || hasDigit;
    }

    private static boolean validateExponentUserInputSyntax(String exponent) {
        if (exponent.length() > 3 || exponent.length() < 1) {
            return false;
        }
        char first = exponent.charAt(0);
        if (first != '+' && first != '-' && first != ' ' && !Character.isDigit(first)) {
            return false;
        }
        boolean hasDigit = false;
        int i = 0;
        while (i < exponent.length()) {
            if (Character.isDigit(exponent.charAt(i))) {
                hasDigit = true;
            }
            ++i;
        }
        if (!hasDigit) {
            return false;
        }
        i = 1;
        while (i < exponent.length()) {
            if (!Character.isDigit(exponent.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getMantissaPart(String mantissaInput) {
        int i = mantissaInput.indexOf(69);
        if (i == -1) {
            return mantissaInput;
        }
        return mantissaInput.substring(0, i);
    }

    private static String getExponentPart(String exponentInput) {
        int i = exponentInput.indexOf(69);
        if (i == -1) {
            return "";
        }
        return exponentInput.substring(i + 1, exponentInput.length());
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] buildEBCDIC(String mantissa, int exponent, int mantissaSize, FEparams params) {
        block19: {
            firstChar = mantissa.charAt(0);
            mantissaSign = ' ';
            mantissaSign = Character.isDigit(firstChar) != false || firstChar == '.' ? '+' : (char)firstChar;
            wholePart = new StringBuffer(ConverterUtils.getWholePart(mantissa));
            fracPart = new StringBuffer(ConverterUtils.getFracPart(mantissa));
            wholeDigits = 0;
            fracDigits = 0;
            if (params != null && params.decimalPos != -1) {
                fracDigits = params.decimalPos + 1;
                wholeDigits = mantissaSize - fracDigits;
                if (!params.implied) {
                    --fracDigits;
                }
            } else {
                wholeDigits = mantissaSize;
            }
            if ((i = wholePart.length()) != 0 || wholeDigits <= 0) ** GOTO lbl44
            firstNonZeroHit = false;
            while (wholePart.length() < wholeDigits && fracPart.length() > 0) {
                c = fracPart.charAt(0);
                if (firstNonZeroHit) {
                    wholePart.append(c);
                    fracPart.deleteCharAt(0);
                    --exponent;
                    continue;
                }
                if (c != '0') {
                    firstNonZeroHit = true;
                    wholePart.append(c);
                    fracPart.deleteCharAt(0);
                } else {
                    fracPart.deleteCharAt(0);
                }
                --exponent;
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                fracPart.insert(0, wholePart.charAt(i - 1));
                wholePart.deleteCharAt(i - 1);
                ++exponent;
                --i;
lbl44:
                // 2 sources

                ** while (i > wholeDigits)
            }
        }
        resultString = new StringBuffer();
        resultString.insert(0, mantissaSign);
        j = wholeDigits;
        while (j > 0 && wholePart.length() > 0) {
            resultString.insert(1, wholePart.charAt(wholePart.length() - 1));
            wholePart.deleteCharAt(wholePart.length() - 1);
            --j;
        }
        while (j > 0) {
            resultString.insert(1, '0');
            --j;
        }
        if (params != null && params.decimalPos != -1 && !params.implied) {
            resultString.append('.');
        }
        k = 0;
        while (k < fracDigits && k < fracPart.length()) {
            resultString.append(fracPart.charAt(k));
            ++k;
        }
        while (k < fracDigits) {
            resultString.append('0');
            ++k;
        }
        resultString.append('E');
        if (exponent < 0) {
            resultString.append('-');
        } else {
            resultString.append('+');
        }
        absExp = Math.abs(exponent);
        if (absExp < 10) {
            resultString.append("0" + absExp);
        } else {
            resultString.append(absExp);
        }
        try {
            return resultString.toString().getBytes("IBM-037");
        }
        catch (UnsupportedEncodingException e) {
            FMIExternalFloatConverter.logger.error((Throwable)e);
            return null;
        }
    }

    private boolean validateStrictEBCDICFormat(String convertedVersion, int fieldLen, FEparams params) {
        if (ConverterUtils.hasUnknown(convertedVersion)) {
            return false;
        }
        char leadChar = convertedVersion.charAt(0);
        if (!FMIExternalFloatConverter.validSignEBCDICFormat(leadChar)) {
            return false;
        }
        int exp = convertedVersion.indexOf(69);
        if (exp == -1) {
            return false;
        }
        int endOfData = exp + 3;
        if (endOfData != fieldLen - 1) {
            return false;
        }
        if (!FMIExternalFloatConverter.validSignEBCDICFormat(convertedVersion.charAt(exp + 1))) {
            return false;
        }
        if (!Character.isDigit(convertedVersion.charAt(endOfData)) && Character.isDigit(convertedVersion.charAt(endOfData - 1))) {
            return false;
        }
        int decimalIndex = this.getTrueIndexFromDecimalPosition(fieldLen, params.decimalPos);
        int i = 1;
        while (i < exp) {
            char c = convertedVersion.charAt(i);
            if (params.implied) {
                if (!Character.isDigit(c)) {
                    return false;
                }
            } else {
                if (!Character.isDigit(c) && c != '.') {
                    return false;
                }
                if (c == '.' && i != decimalIndex) {
                    return false;
                }
            }
            ++i;
        }
        return convertedVersion.charAt(decimalIndex) == '.';
    }

    int convertExponentPart(String parsedExponent) {
        int result = 0;
        boolean negative = false;
        if (!parsedExponent.isEmpty()) {
            StringBuffer tmpExp = new StringBuffer(parsedExponent);
            char leadChar = parsedExponent.charAt(0);
            if (leadChar == '+' || leadChar == ' ') {
                tmpExp.deleteCharAt(0);
                negative = false;
            } else if (leadChar == '-') {
                tmpExp.deleteCharAt(0);
                negative = true;
            } else {
                negative = false;
            }
            if (parsedExponent.charAt(0) == '\u0000') {
                tmpExp.deleteCharAt(0);
            }
            try {
                result = negative ? -Integer.parseInt(tmpExp.toString()) : Integer.parseInt(tmpExp.toString());
            }
            catch (NumberFormatException e) {
                result = 0;
            }
        }
        return result;
    }

    int getTrueIndexFromDecimalPosition(int fieldSize, int decimalPos) {
        assert (fieldSize > 0 && decimalPos >= 0);
        return fieldSize - 5 - decimalPos;
    }

    private static class FEparams {
        public boolean implied;
        public int decimalPos;

        private FEparams() {
        }
    }
}

