/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.model.datatypeconverters.ConverterUtils;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.UnsupportedEncodingException;

public class FMIDBCSConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FMIDBCSConverter.class);
    private static String codepage;
    public static final byte SPACE = 64;
    private static final String symbol = "G/DB";
    private static final char DEFAULT_CHAR = ' ';
    private static FMIDBCSConverter theInstance;

    static {
        theInstance = null;
    }

    private FMIDBCSConverter() {
    }

    public static FMIDBCSConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIDBCSConverter();
        }
        return theInstance;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (asciiString == null) {
            asciiString = "";
        }
        try {
            byte[] ebcdic = null;
            try {
                ebcdic = asciiString.getBytes(codepage);
            }
            catch (UnsupportedEncodingException e) {
                throw new FMIConversionException();
            }
            ebcdic = ConverterUtils.shiftStrip(ebcdic);
            if (oldEBCDIC != null && ebcdic.length > oldEBCDIC.length) {
                throw new FMIConversionException();
            }
            if (oldEBCDIC != null && ebcdic.length < oldEBCDIC.length) {
                byte[] resized = new byte[oldEBCDIC.length];
                int i = 0;
                while (i < ebcdic.length) {
                    resized[i] = ebcdic[i];
                    ++i;
                }
                while (i < resized.length) {
                    resized[i] = 64;
                    ++i;
                }
                ebcdic = resized;
                resized = null;
            }
            if (oldEBCDIC != null) {
                int i = 0;
                while (i < asciiString.length()) {
                    if (asciiString.charAt(i) == '\u25ad') {
                        ebcdic[i * 2] = oldEBCDIC[i * 2];
                    }
                    ebcdic[i * 2 + 1] = oldEBCDIC[i * 2 + 1];
                    ++i;
                }
            }
            return ebcdic;
        }
        catch (Exception e) {
            throw new FMIConversionException(MSG_ASCII_EBCDIC_FAILURE + e.getClass().getName());
        }
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        if (EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        byte[] wrappedBytes = ConverterUtils.shiftWrap(EBCDICval);
        return ConverterUtils.decodeBytes(wrappedBytes, Character.toString('\u25ad'), codepage);
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        return asciiString;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        numChars = length / 2;
        byteSource = new StringBuffer(numChars);
        i = 0;
        while (i < numChars) {
            byteSource.append(' ');
            ++i;
        }
        try {
            result = byteSource.toString().getBytes(FMIDBCSConverter.codepage);
            result = ConverterUtils.shiftWrap(result);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            FMIDBCSConverter.logger.error((Throwable)e);
            nullBytes = new byte[length];
            i = 0;
            ** while (i < length)
        }
lbl-1000:
        // 1 sources

        {
            nullBytes[i] = 64;
            ++i;
            continue;
        }
lbl21:
        // 1 sources

        return nullBytes;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        int len = 0;
        if (ebcdicWidth % 2 != 0) {
            throw new FMIConversionException();
        }
        len = ebcdicWidth / 2;
        return len;
    }

    @Override
    public String getSymbol() {
        return symbol;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean validateASCII(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        byte[] bytes = null;
        try {
            bytes = asciiString.getBytes(codepage);
        }
        catch (UnsupportedEncodingException e) {
            throw new FMIConversionException(UNSUPPORTED_ENCODING);
        }
        if (bytes[0] != 14 || bytes[bytes.length - 1] != 15) {
            return false;
        }
        return tgtWidth >= (bytes = ConverterUtils.shiftStrip(bytes)).length;
    }

    public static void setCodepage(String cp) {
        codepage = cp;
    }
}

