/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.nio.ByteBuffer;

public class FMIBinaryDataTypeConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String MSG_UNEXPECTED_DATA_SIZE = Messages.FMIBinaryDataTypeConverter_ERROR_CONVERSION;
    private static FMIBinaryDataTypeConverter theInstance = null;

    private FMIBinaryDataTypeConverter() {
    }

    public static FMIBinaryDataTypeConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIBinaryDataTypeConverter();
        }
        return theInstance;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        try {
            ByteBuffer bytes = ByteBuffer.allocate(tgtWidth);
            byte[] tgtArr = new byte[tgtWidth];
            if (asciiString == null || asciiString.equals("")) {
                int i = 0;
                while (i < tgtArr.length) {
                    tgtArr[i] = 0;
                    ++i;
                }
            } else {
                if (tgtWidth == 8) {
                    bytes.putLong(0, Long.parseLong(asciiString));
                } else if (tgtWidth == 4) {
                    bytes.putInt(0, Integer.parseInt(asciiString));
                } else if (tgtWidth == 2) {
                    bytes.putShort(0, Short.parseShort(asciiString));
                }
                bytes.get(tgtArr, 0, tgtWidth);
            }
            return tgtArr;
        }
        catch (Exception e) {
            throw new FMIConversionException(MSG_ASCII_EBCDIC_FAILURE + e.getClass().getName());
        }
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int aIndex = ((String)asciiString).charAt(0) == '-' ? 1 : 0;
        while (aIndex < ((String)asciiString).length() && ((String)asciiString).charAt(aIndex) == '0') {
            Object object = asciiString = aIndex == 0 ? ((String)asciiString).substring(aIndex + 1) : "-" + ((String)asciiString).substring(aIndex + 1);
        }
        return asciiString;
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxWidth, Object[] extraParams) throws FMIConversionException {
        if (EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        String strVal = null;
        try {
            ByteBuffer bytes = ByteBuffer.allocate(EBCDICval.length);
            bytes.put(EBCDICval);
            if (EBCDICval.length == 8) {
                strVal = Long.toString(bytes.getLong(0));
            } else if (EBCDICval.length == 4) {
                strVal = Integer.toString(bytes.getInt(0));
            } else if (EBCDICval.length == 2) {
                strVal = Short.toString(bytes.getShort(0));
            }
        }
        catch (Exception e) {
            throw new FMIConversionException(MSG_EBCDIC_ASCII_FAILURE + e.getClass().getName());
        }
        if (strVal == null) {
            throw new FMIConversionException(this.MSG_UNEXPECTED_DATA_SIZE);
        }
        if (strVal.length() > maxWidth) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        return strVal;
    }

    @Override
    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int searchStartIndex;
        if (ascii == null || ascii.equals("")) {
            return true;
        }
        char[] charArr = ascii.toCharArray();
        boolean negative = ascii.charAt(0) == '-';
        int i = searchStartIndex = negative ? 1 : 0;
        while (i < charArr.length) {
            if (!Character.isDigit(charArr[i])) {
                String errMsg = INVALID_CHARACTER + ": " + charArr[i];
                throw new FMIConversionException(errMsg);
            }
            ++i;
        }
        if (tgtWidth == 2 && (negative && ascii.length() > 6 || !negative && ascii.length() > 5) || tgtWidth == 4 && (negative && ascii.length() > 11 || !negative && ascii.length() > 10) || tgtWidth == 8 && (negative && ascii.length() > 20 || !negative && ascii.length() > 19)) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        return true;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth == 2) {
            return 6;
        }
        if (ebcdicWidth == 4) {
            return 11;
        }
        if (ebcdicWidth == 8) {
            return 20;
        }
        throw new FMIConversionException(MSG_ASCII_LENGTH_CALC);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String getSymbol() {
        return "BI";
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return length >= 4;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return length == 2;
    }
}

