/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.model.datatypeconverters.ConverterUtils;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class FMIAlphaNumericDataTypeConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FMIAlphaNumericDataTypeConverter.class);
    private static final byte DEFAULT_CHAR = 64;
    private static final String DEFAULT_CP = "IBM-037";
    private static final String EXTRA_CHARS = "!@#$%^&*(){}[];:'\",<.>/?\\|`~_-+=";
    private static String codepage = "IBM-037";
    private static FMIAlphaNumericDataTypeConverter theInstance = null;

    private FMIAlphaNumericDataTypeConverter() {
    }

    public static FMIAlphaNumericDataTypeConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIAlphaNumericDataTypeConverter();
        }
        return theInstance;
    }

    public static void setCodepage(String theCodepage) {
        codepage = theCodepage;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (asciiString == null) {
            asciiString = "";
        }
        try {
            byte[] ebcdic = null;
            try {
                ebcdic = asciiString.getBytes(codepage);
            }
            catch (UnsupportedEncodingException e) {
                throw new FMIConversionException(UNSUPPORTED_ENCODING);
            }
            if (ebcdic.length < oldEBCDIC.length) {
                byte[] resized = new byte[oldEBCDIC.length];
                int i = 0;
                while (i < ebcdic.length) {
                    resized[i] = ebcdic[i];
                    ++i;
                }
                while (i < resized.length) {
                    resized[i] = 64;
                    ++i;
                }
                ebcdic = resized;
                resized = null;
            }
            if (oldEBCDIC != null) {
                int i = 0;
                while (i < asciiString.length()) {
                    if (asciiString.charAt(i) == '\u25ad') {
                        ebcdic[i] = oldEBCDIC[i];
                    }
                    ++i;
                }
            }
            return ebcdic;
        }
        catch (Exception e) {
            throw new FMIConversionException(MSG_ASCII_EBCDIC_FAILURE + e.getClass().getName());
        }
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        return asciiString;
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        if (EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        boolean dbcs = false;
        StringBuffer stringRep = new StringBuffer(EBCDICval.length);
        Vector<Byte> singles = new Vector<Byte>();
        Vector<Byte> doubles = new Vector<Byte>();
        int i = 0;
        while (i < EBCDICval.length) {
            if (dbcs) {
                if (EBCDICval[i] == 15) {
                    dbcs = false;
                    if (!doubles.isEmpty()) {
                        stringRep.append(FMIAlphaNumericDataTypeConverter.convertDBCS(doubles));
                    }
                } else {
                    doubles.add(EBCDICval[i]);
                }
            } else if (EBCDICval[i] == 14) {
                dbcs = true;
                if (!singles.isEmpty()) {
                    stringRep.append(FMIAlphaNumericDataTypeConverter.convertSBCS(singles));
                }
            } else if (EBCDICval[i] != 15) {
                singles.add(EBCDICval[i]);
            }
            ++i;
        }
        if (dbcs) {
            if (!doubles.isEmpty()) {
                stringRep.append(FMIAlphaNumericDataTypeConverter.convertSBCS(doubles));
            }
        } else if (!singles.isEmpty()) {
            stringRep.append(FMIAlphaNumericDataTypeConverter.convertSBCS(singles));
        }
        if (stringRep.length() > maxStrLength) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH + ": " + maxStrLength);
        }
        FMIAlphaNumericDataTypeConverter.removeUnsupportedChars(stringRep);
        return stringRep.toString();
    }

    private static boolean charShowable(char c) {
        return Character.isLetterOrDigit(c) || Character.isSpaceChar(c) || EXTRA_CHARS.indexOf(c) != -1;
    }

    private static String convertDBCS(Vector<Byte> v) throws FMIConversionException {
        byte[] bytes = FMIAlphaNumericDataTypeConverter.getBytes(v);
        int numToCopy = 0;
        boolean extraByte = bytes.length % 2 != 0;
        numToCopy = extraByte ? bytes.length - 1 : bytes.length;
        byte[] newBytes = new byte[numToCopy + 2];
        newBytes[0] = 14;
        newBytes[newBytes.length - 1] = 15;
        int i = 0;
        while (i < numToCopy) {
            newBytes[i + 1] = bytes[i];
            ++i;
        }
        bytes = null;
        Object result = FMIAlphaNumericDataTypeConverter.decodeDBCS(newBytes);
        if (extraByte) {
            result = (String)result + Character.toString('\u25ad');
        }
        return result;
    }

    private static String convertSBCS(Vector<Byte> v) throws FMIConversionException {
        byte[] bytes = FMIAlphaNumericDataTypeConverter.getBytes(v);
        return ConverterUtils.decodeBytes(bytes, Character.toString('\u25ad'), codepage);
    }

    private static byte[] getBytes(Vector<Byte> v) {
        int numElements = v.size();
        byte[] result = new byte[numElements];
        int i = 0;
        while (i < numElements) {
            result[i] = v.remove(0);
            ++i;
        }
        return result;
    }

    private static String decodeDBCS(byte[] master) throws FMIConversionException {
        InputStreamReader isr;
        int numChars = (master.length - 2) / 2;
        if (numChars <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(numChars);
        ByteArrayInputStream bais = new ByteArrayInputStream(master);
        try {
            isr = new InputStreamReader((InputStream)bais, codepage);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
            throw new FMIConversionException(UNSUPPORTED_ENCODING);
        }
        int i = 0;
        while (i < numChars) {
            try {
                char c = (char)isr.read();
                if (FMIAlphaNumericDataTypeConverter.charShowable(c)) {
                    sb.append(c);
                } else {
                    sb.append('\u25ad');
                    sb.append('\u25ad');
                }
            }
            catch (IOException f) {
                logger.error((Throwable)f);
                throw new FMIConversionException();
            }
            ++i;
        }
        try {
            isr.close();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        byte[] bytes = null;
        try {
            bytes = ascii.getBytes(codepage);
        }
        catch (UnsupportedEncodingException e) {
            throw new FMIConversionException(UNSUPPORTED_ENCODING);
        }
        if (tgtWidth < bytes.length) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        return true;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        return ebcdicWidth;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public String getSymbol() {
        return "AN";
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraparams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 64;
            ++i;
        }
        return bytes;
    }

    public String getCodePage() {
        return codepage;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }

    private static void removeUnsupportedChars(StringBuffer sb) {
        int i = 0;
        while (i < sb.length()) {
            if (!FMIAlphaNumericDataTypeConverter.charShowable(sb.charAt(i))) {
                sb.setCharAt(i, '\u25ad');
            }
            ++i;
        }
    }
}

