/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;

public class ConverterUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static String decodeBytes(byte[] toDecode, String unmappableReplacement, String codepage) throws FMIConversionException {
        Objects.requireNonNull(codepage, "Must provide a non-null codepage.");
        Charset cs = Charset.forName(codepage);
        CharsetDecoder decoder = cs.newDecoder();
        decoder = decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder = decoder.replaceWith(unmappableReplacement);
        ByteBuffer inBuffer = ByteBuffer.wrap(toDecode);
        CharBuffer outBuffer = null;
        try {
            outBuffer = decoder.decode(inBuffer);
        }
        catch (CharacterCodingException e) {
            outBuffer = ConverterUtils.decodeBytes(toDecode, unmappableReplacement);
        }
        return outBuffer.toString();
    }

    public static CharBuffer decodeBytes(byte[] toDecode, String unmappableReplacement) throws FMIConversionException {
        Objects.requireNonNull(unmappableReplacement, "Must provide a non-null unmappableReplacement");
        Charset cs = Charset.forName("Cp1047");
        CharsetDecoder decoder = cs.newDecoder();
        decoder = decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder = decoder.replaceWith(unmappableReplacement);
        ByteBuffer inBuffer = ByteBuffer.wrap(toDecode);
        CharBuffer outBuffer = null;
        try {
            outBuffer = decoder.decode(inBuffer);
        }
        catch (CharacterCodingException e) {
            throw new FMIConversionException();
        }
        return outBuffer;
    }

    public static byte[] shiftWrap(byte[] inBytes) {
        Objects.requireNonNull(inBytes, "Must provide a non-null inBytes.");
        int newLen = inBytes.length + 2;
        byte[] resultBytes = new byte[newLen];
        resultBytes[0] = 14;
        resultBytes[newLen - 1] = 15;
        int i = 0;
        while (i < inBytes.length) {
            resultBytes[i + 1] = inBytes[i];
            ++i;
        }
        return resultBytes;
    }

    public static byte[] shiftStrip(byte[] inBytes) {
        Objects.requireNonNull(inBytes, "Must provide a non-null inBytes.");
        int newLen = inBytes.length - 2;
        byte[] resultBytes = new byte[newLen];
        int i = 0;
        while (i < resultBytes.length) {
            resultBytes[i] = inBytes[i + 1];
            ++i;
        }
        return resultBytes;
    }

    public static int shiftCount(byte[] bytes) {
        Objects.requireNonNull(bytes, "Must provide a non-null bytes byte[].");
        int count = 0;
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 15 || bytes[i] == 14) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static boolean hasUnknown(String converted) {
        Objects.requireNonNull(converted, "Must provide a non-null converted string.");
        if (converted.indexOf(9645) == -1) {
            return false;
        }
        return false;
    }

    public static String bytesToString(byte[] bytes) {
        Objects.requireNonNull(bytes, "Must provide a non-null bytes.");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int tmpByte = bytes[i];
            if (tmpByte < 0) {
                tmpByte += 256;
            }
            int byte1 = tmpByte / 16;
            int byte2 = tmpByte % 16;
            sb.append(ConverterUtils.hexChar(byte1));
            sb.append(ConverterUtils.hexChar(byte2));
            ++i;
        }
        return sb.toString();
    }

    private static char hexChar(int val) {
        switch (val) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Integer.toString(val).charAt(0);
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return '?';
    }

    public static String getWholePart(String in) {
        Objects.requireNonNull(in, "Must specify a non-null in String.");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c == '.') break;
            if (c != '+' && c != '-') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getFracPart(String in) {
        Objects.requireNonNull(in, "Must provide a non-null in String.");
        StringBuffer sb = new StringBuffer();
        int decimalPos = in.indexOf(46);
        if (decimalPos == -1) {
            return sb.toString();
        }
        int i = decimalPos + 1;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c == '+' || c == '-') break;
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] stringToBytes(String hexString) throws NumberFormatException {
        Objects.requireNonNull(hexString, "Must provide a non-null hexString.");
        int hexLen = hexString.length();
        byte[] bytes = new byte[hexLen / 2];
        int i = 0;
        while (i < hexString.length()) {
            int thisByte = Byte.parseByte(Character.toString(hexString.charAt(i)), 16) << 4;
            bytes[i / 2] = (byte)(thisByte += Byte.parseByte(Character.toString(hexString.charAt(i + 1)), 16));
            i += 2;
        }
        return bytes;
    }
}

