/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model;

import com.ibm.etools.fm.model.datatypeconverters.FMIAlphaNumericDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteUtilities {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final byte EIGHT_TEST = -128;
    private static final byte SEVEN_TEST = 64;
    private static final byte SIX_TEST = 32;
    private static final byte FIVE_TEST = 16;
    private static final byte FOUR_TEST = 8;
    private static final byte THREE_TEST = 4;
    private static final byte TWO_TEST = 2;
    private static final byte ONE_TEST = 1;

    public static byte[] getBytes(ByteBuffer buf, int length) {
        Objects.requireNonNull(buf, "Must provide a non-null buf byte[].");
        byte[] bytes = new byte[length];
        buf.get(bytes, 0, length);
        return bytes;
    }

    public static String getString(ByteBuffer buf, int length) throws FMIConversionException {
        Objects.requireNonNull(buf, "Must provide a non-null buf byte[].");
        byte[] charBytes = ByteUtilities.getBytes(buf, length);
        FMIAlphaNumericDataTypeConverter converter = FMIAlphaNumericDataTypeConverter.getInstance();
        return converter.EBCDICtoASCIIstr(charBytes, length, null);
    }

    public static boolean testBit(byte theByte, int bit) {
        byte testByte = ByteUtilities.getByteForBitTest(bit);
        return (theByte & testByte) == testByte;
    }

    public static int getBigEndianInt(ByteBuffer byteBuf) {
        Objects.requireNonNull(byteBuf, "Must provide a non-null byteBuf..");
        byte[] intBytes = new byte[4];
        byteBuf.get(intBytes, 0, 4);
        byte tempByte = intBytes[0];
        intBytes[0] = intBytes[3];
        intBytes[3] = tempByte;
        tempByte = intBytes[1];
        intBytes[1] = intBytes[2];
        intBytes[2] = tempByte;
        return ByteUtilities.byteArrayToInt(intBytes, 0);
    }

    private static byte getByteForBitTest(int bit) {
        switch (bit) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return -128;
            }
        }
        return 0;
    }

    public static long byteArrayToUnsignedInt(byte[] intArr) {
        return ByteUtilities.byteArrayToUnsignedInt(intArr, 0);
    }

    public static long byteArrayToUnsignedInt(byte[] intArr, int startIndex) {
        Objects.requireNonNull(intArr, "Must provide a non-null intArr.");
        int numBytes = 4;
        long longVal = 0L;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            longVal += (long)((intArr[i + startIndex] & 0xFF) << shift);
            ++i;
        }
        return longVal;
    }

    public static long byteArrayToUnsignedShort(byte[] shortArr) {
        return ByteUtilities.byteArrayToUnsignedShort(shortArr, 0);
    }

    public static int byteArrayToUnsignedShort(byte[] shortArr, int startIndex) {
        Objects.requireNonNull(shortArr, "Must provide a non-null shortArr byte[].");
        int numBytes = 2;
        int unsignedShort = shortArr[startIndex];
        int i = startIndex + 1;
        while (i < startIndex + 2) {
            unsignedShort <<= 2;
            unsignedShort |= shortArr[i];
            ++i;
        }
        return unsignedShort;
    }

    public static int byteArrayToInt(byte[] intArr) {
        return ByteUtilities.byteArrayToInt(intArr, 0);
    }

    public static int byteArrayToInt(byte[] intArr, int startIndex) {
        Objects.requireNonNull(intArr, "Must provide a non-null intArr.");
        int numBytes = 4;
        int intVal = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            intVal += (intArr[i + startIndex] & 0xFF) << shift;
            ++i;
        }
        return intVal;
    }

    public static long byteArrayToLong(byte[] longArr) {
        return ByteUtilities.byteArrayToLong(longArr, 0);
    }

    public static long byteArrayToLong(byte[] longArr, int startIndex) {
        Objects.requireNonNull(longArr, "Must provide a non-null longArr.");
        int numBytes = 8;
        long longVal = longArr[startIndex];
        int i = startIndex + 1;
        while (i < startIndex + 8) {
            longVal <<= 2;
            longVal |= (long)longArr[i];
            ++i;
        }
        return longVal;
    }

    public static boolean isNegative(byte b, boolean highNibble, String exception) throws FMIConversionException {
        if (highNibble) {
            if ((b & 0xFFFFFFF0) == -48 || (b & 0xFFFFFFF0) == -80) {
                return true;
            }
            if (!ByteUtilities.testBit(b, 8) || !ByteUtilities.testBit(b, 7) && !ByteUtilities.testBit(b, 6)) {
                throw new FMIConversionException(exception);
            }
        } else {
            if ((b & 0xF) == 13) {
                return true;
            }
            if (!ByteUtilities.testBit(b, 4) || !ByteUtilities.testBit(b, 3) && !ByteUtilities.testBit(b, 2)) {
                throw new FMIConversionException(exception);
            }
        }
        return false;
    }

    public static byte[] intToByteArray(int theInt) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(theInt);
        buf.position(0);
        byte[] intBytes = new byte[4];
        buf.get(intBytes);
        return intBytes;
    }

    public static byte[] shortToByteArray(short theShort) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort(theShort);
        buf.position(0);
        byte[] shortBytes = new byte[2];
        buf.get(shortBytes);
        return shortBytes;
    }

    public static byte setBit(byte b, int bit) {
        byte theMagicByte = ByteUtilities.getByteForBitTest(bit);
        return (byte)(b | theMagicByte);
    }
}

