/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.wrapper;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class ReflectionClass {
    private static final PDLogger logger = PDLogger.get(ReflectionClass.class);
    private final Class<?> clazz;
    private final Object object;

    public ReflectionClass(String className, Object instance) throws Exception {
        Class<?> temp = ReflectionClass.getClass(instance.getClass().getClassLoader(), Objects.requireNonNull(className, "Please provide a className."));
        if (temp == null) {
            throw new IllegalStateException("Could not find class: " + className);
        }
        this.clazz = temp;
        if (!ReflectionClass.isInstanceOfWrappedClass(className, Objects.requireNonNull(instance, "Please provide a non-null instance object."))) {
            throw new Exception(MessageFormat.format("Please provide an object with type: {0}+  The specified object {1} was a {2}", className, instance, instance.getClass()));
        }
        this.object = instance;
    }

    protected <T> T callZeroArgMethodUsingReflection(String methodName, Class<T> returnType) throws Exception {
        return this.callMethodUsingReflection(methodName, new Class[0], returnType, new Object[0]);
    }

    protected <T> T callMethodUsingReflection(String methodName, Class<?>[] paramTypes, Class<T> returnType, Object ... parameters) throws Exception {
        if (!this.clazz.isInstance(this.object)) {
            logger.error((Object)MessageFormat.format("Specified object {0} is not a {1}. returning null.", this.object, this.clazz.getName()));
            throw new Exception(MessageFormat.format("Specified object {0} is not a {1}. returning null.", this.object, this.clazz.getName()));
        }
        Method method = this.getMethod(methodName, paramTypes);
        Object result = this.invokeMethod(method, parameters);
        if (returnType.isInstance(result)) {
            return returnType.cast(result);
        }
        return null;
    }

    public static Class<?> getClass(ClassLoader classLoader, String clazzName) {
        try {
            return classLoader.loadClass(clazzName);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)MessageFormat.format("Could not find {0} {1}", clazzName, e));
            return null;
        }
    }

    private Method getMethod(String methodName, Class<?>[] paramTypes) {
        try {
            return this.clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error((Object)MessageFormat.format("Error occurred when getting method to call {0}.{1} --> ", this.clazz.getCanonicalName(), methodName), (Throwable)e);
            return null;
        }
    }

    private Object invokeMethod(Method method, Object ... parameters) {
        try {
            return method.invoke(this.object, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error((Object)"Error occurred when invoking method.");
            return null;
        }
    }

    public static boolean isInstanceOfWrappedClass(String clazz, Object object) {
        Class<?> clazzType = ReflectionClass.getClass(clazz, object);
        if (clazzType != null) {
            return clazzType.isInstance(object);
        }
        return false;
    }

    public static Class<?> getClass(String clazz, Object objectToUseClassLoaderFrom) {
        return ReflectionClass.getClass(objectToUseClassLoaderFrom.getClass().getClassLoader(), clazz);
    }
}

