/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class WeightedPriorityQueue<E, T extends Comparable<T>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int DEFAULT_INITIAL_CAPACITY = 11;
    private PriorityQueue<E> pq;
    private WeightedComparator<E> comparator = new WeightedComparator();

    public static <E, T extends Comparable<T>> WeightedPriorityQueue<E, T> create() {
        return new WeightedPriorityQueue<E, T>(11);
    }

    public WeightedPriorityQueue(int initialCapacity) {
        this.pq = new PriorityQueue<E>(initialCapacity, this.comparator);
    }

    public void add(E element, T weight) {
        this.comparator.setWeight(element, weight);
        this.pq.add(element);
    }

    public E peek() {
        return this.pq.peek();
    }

    public List<E> asList() {
        return new ArrayList<E>(this.pq);
    }

    private class WeightedComparator<F>
    implements Comparator<F> {
        private Map<F, T> weightMap = new HashMap();

        private WeightedComparator() {
        }

        public void setWeight(F o, T weight) {
            this.weightMap.put(o, weight);
        }

        @Override
        public int compare(F o1, F o2) {
            return ((Comparable)this.weightMap.get(o1)).compareTo((Comparable)this.weightMap.get(o2));
        }
    }
}

