/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.util;

import com.ibm.etools.fm.model.redit.DocumentRoot;
import com.ibm.etools.fm.model.redit.ReditType;
import com.ibm.etools.fm.model.redit.util.ReditResourceFactoryImpl;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.InputSource;

public class ReditUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(ReditUtils.class);

    public static ReditType load(String xmlDoc, String hostName) {
        Objects.requireNonNull(xmlDoc, "Must provide a non-null xmlDoc String.");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XMLResource resource = (XMLResource)new ReditResourceFactoryImpl().createResource(URI.createPlatformResourceURI((String)hostName, (boolean)false));
        resourceSet.getResources().add((Object)resource);
        try {
            resource.load(new InputSource(new StringReader(xmlDoc)), resourceSet.getLoadOptions());
        }
        catch (Exception e) {
            logger.error((Object)("Exception thrown while parsing XML output for REDIT: " + xmlDoc), (Throwable)e);
            return null;
        }
        boolean hasError = false;
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            logger.error((Object)MessageFormat.format("An error occurred while loading REDIT xml: {0} : Line {1} Column {2}, with document of ", diagnostic.getMessage(), String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn()), xmlDoc));
            hasError = true;
        }
        if (hasError) {
            return null;
        }
        if (resource.getContents().get(0) instanceof DocumentRoot) {
            return ((DocumentRoot)resource.getContents().get(0)).getRedit();
        }
        return null;
    }
}

