/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.util;

import com.ibm.etools.fm.model.fmnxdpos.DbposType;
import com.ibm.etools.fm.model.fmnxdpos.DocumentRoot;
import com.ibm.etools.fm.model.fmnxdpos.FmnxdposFactory;
import com.ibm.etools.fm.model.fmnxdpos.util.FmnxdposResourceFactoryImpl;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.InputSource;

public class ImsKeyPositionOptionsUtil {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(ImsKeyPositionOptionsUtil.class);

    public static DbposType load(String xmlDoc, String hostName) {
        Objects.requireNonNull(xmlDoc, "Must provide a non-null xmlDoc string.");
        DbposType dbpos = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        FmnxdposResourceFactoryImpl factory = new FmnxdposResourceFactoryImpl();
        XMLResource resource = (XMLResource)factory.createResource(URI.createPlatformResourceURI((String)hostName, (boolean)false));
        resourceSet.getResources().add((Object)resource);
        try {
            resource.load(new InputSource(new StringReader(xmlDoc)), resourceSet.getLoadOptions());
        }
        catch (Exception e) {
            logger.error((Object)("Exception thrown while parsing XML output for IMS database position xml: " + xmlDoc), (Throwable)e);
            return null;
        }
        boolean hasError = false;
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            logger.error((Object)MessageFormat.format("An error occurred while loading IMS database position xml: {0} : Line {1} Column {2}, with document of ", diagnostic.getMessage(), String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn()), xmlDoc));
            hasError = true;
        }
        if (hasError) {
            return null;
        }
        if (resource.getContents().get(0) instanceof DocumentRoot) {
            dbpos = ((DocumentRoot)resource.getContents().get(0)).getDbpos();
        }
        return dbpos;
    }

    public static String save(DbposType dbpos) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        FmnxdposResourceFactoryImpl factory = new FmnxdposResourceFactoryImpl();
        XMLResource resource = (XMLResource)factory.createResource(URI.createPlatformResourceURI((String)"x.fmt", (boolean)false));
        resourceSet.getResources().add((Object)resource);
        DocumentRoot root = FmnxdposFactory.eINSTANCE.createDocumentRoot();
        root.setDbpos(dbpos);
        resource.getContents().add((Object)root);
        try {
            StringWriter writer = new StringWriter();
            resource.save((Writer)writer, new HashMap());
            return writer.toString();
        }
        catch (IOException e) {
            logger.error((Object)"Exception thrown while converting Dbpos to String.", (Throwable)e);
            return null;
        }
    }
}

