/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.util;

import java.util.Collection;

public class FMAssert {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static void assertNotNull(Object o) {
        if (o == null) {
            throw new FMAssertionFailedError();
        }
    }

    public static <E> void assertNotEmpty(E[] array) {
        FMAssert.assertNotNull(array);
        if (array.length == 0) {
            throw new FMAssertionFailedError();
        }
    }

    public static void assertNotEmpty(String str) {
        FMAssert.assertNotNull(str);
        if (str.isEmpty()) {
            throw new FMAssertionFailedError();
        }
    }

    public static void assertNotEmpty(Collection<?> collection) {
        FMAssert.assertNotNull(collection);
        if (collection.isEmpty()) {
            throw new FMAssertionFailedError();
        }
    }

    public static void assertTrue(boolean condition) {
        if (!condition) {
            throw new FMAssertionFailedError();
        }
    }

    public static void assertFalse(boolean condition) {
        if (condition) {
            throw new FMAssertionFailedError();
        }
    }

    public static <E> void assertItemInCollection(E a, Collection<E> bCollection) {
        FMAssert.assertNotNull(bCollection);
        if (!bCollection.contains(a)) {
            throw new FMAssertionFailedError();
        }
    }

    public static <E> void assertItemsInCollection(Collection<E> aCollection, Collection<E> bCollection) {
        FMAssert.assertNotNull(aCollection);
        FMAssert.assertNotNull(bCollection);
        if (!bCollection.containsAll(aCollection)) {
            throw new FMAssertionFailedError();
        }
    }

    public static <E> void assertItemInArray(E a, E[] bArray) {
        FMAssert.assertNotNull(bArray);
        E[] EArray = bArray;
        int n = bArray.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (a == null && e == null) {
                return;
            }
            if (a != null && a.equals(e)) {
                return;
            }
            ++n2;
        }
        throw new FMAssertionFailedError();
    }

    public static <E> void assertItemsInArray(E[] aArray, E[] bArray) {
        FMAssert.assertNotNull(aArray);
        FMAssert.assertNotNull(bArray);
        E[] EArray = aArray;
        int n = aArray.length;
        int n2 = 0;
        while (n2 < n) {
            E a = EArray[n2];
            FMAssert.assertItemInArray(a, bArray);
            ++n2;
        }
    }

    public static <E> void assertEqual(E a, E b) {
        if (a == null && b != null) {
            throw new FMAssertionFailedError();
        }
        if (a != null && !a.equals(b)) {
            throw new FMAssertionFailedError();
        }
    }

    public static void assertInstanceOf(Object item, Class<?> clazz) {
        if (item == null) {
            throw new FMAssertionFailedError();
        }
        if (!clazz.isAssignableFrom(item.getClass())) {
            throw new FMAssertionFailedError();
        }
    }

    public static <E> void fail() {
        throw new FMAssertionFailedError();
    }

    public static class FMAssertionFailedError
    extends AssertionError {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final long serialVersionUID = 1L;
    }
}

