/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.util;

import com.ibm.etools.fm.models.compiler.Asmtype;
import com.ibm.etools.fm.models.compiler.Coboltype;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.etools.fm.models.compiler.CompilerFactory;
import com.ibm.etools.fm.models.compiler.DocumentRoot;
import com.ibm.etools.fm.models.compiler.Plitype;
import com.ibm.etools.fm.models.compiler.ReplaceType;
import com.ibm.etools.fm.models.compiler.util.CompilerResourceFactoryImpl;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.InputSource;

public class CompilerOptionsUtil {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(CompilerOptionsUtil.class);

    public static CompileType load(String xmlCompilerDoc, String hostName) {
        Objects.requireNonNull(xmlCompilerDoc, "Must provide a non-null xmlCompilerDoc string.");
        CompileType compType = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        CompilerResourceFactoryImpl factory = new CompilerResourceFactoryImpl();
        XMLResource resource = (XMLResource)factory.createResource(URI.createPlatformResourceURI((String)hostName, (boolean)false));
        resourceSet.getResources().add((Object)resource);
        Map loadOptions = resourceSet.getLoadOptions();
        try {
            resource.load(new InputSource(new StringReader(xmlCompilerDoc)), loadOptions);
        }
        catch (Exception e) {
            logger.error((Object)("Exception thrown while parsing XML output for FM compiler options: " + xmlCompilerDoc), (Throwable)e);
            return null;
        }
        boolean hasError = false;
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            logger.error((Object)MessageFormat.format("An error occurred while loading compiler options xml: {0} : Line {1} Column {2}, with document of ", diagnostic.getMessage(), String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn()), xmlCompilerDoc));
            hasError = true;
        }
        if (hasError) {
            return null;
        }
        if (resource.getContents().get(0) instanceof DocumentRoot) {
            compType = ((DocumentRoot)resource.getContents().get(0)).getCompile();
        }
        return compType;
    }

    public static String save(CompileType compileOptions) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        CompilerResourceFactoryImpl factory = new CompilerResourceFactoryImpl();
        XMLResource resource = (XMLResource)factory.createResource(URI.createPlatformResourceURI((String)"x.fmt", (boolean)false));
        resourceSet.getResources().add((Object)resource);
        DocumentRoot root = CompilerFactory.eINSTANCE.createDocumentRoot();
        root.setCompile(compileOptions);
        resource.getContents().add((Object)root);
        StringWriter writer = new StringWriter();
        try {
            resource.save((Writer)writer, new HashMap());
            return writer.toString();
        }
        catch (IOException e) {
            logger.error((Object)"Exception thrown while converting CompileType to String.", (Throwable)e);
            return null;
        }
    }

    public static String getSetLanguageOptions(CompileType compOpts) {
        if (compOpts == null) {
            return null;
        }
        Object cmd = "SETL ";
        cmd = (String)cmd + "LANG=" + compOpts.getLang().getName() + ",";
        cmd = (String)cmd + "OVERRIDE=" + (compOpts.isOverride() ? "YES" : "NO");
        return cmd;
    }

    public static String getCommaSeperatorOption(CompileType compOpts) {
        if (compOpts == null) {
            return null;
        }
        Object cmd = "SET ";
        cmd = (String)cmd + "COMMADEC=" + (compOpts.isComma() ? "YES" : "NO");
        return cmd;
    }

    public static String getCobolOptions(CompileType compOpts) {
        if (compOpts == null || compOpts.getCobol() == null) {
            return "";
        }
        Coboltype cobOpts = compOpts.getCobol();
        Object cmd = "SETC ";
        cmd = (String)cmd + "DBCS=" + (cobOpts.isDbcs() ? "YES," : "NO,");
        cmd = (String)cmd + "CAE=" + (cobOpts.isArith() ? "YES," : "NO,");
        cmd = (String)cmd + "CDPC=" + (cobOpts.isDpc() ? "YES," : "NO,");
        if (cobOpts.getCbllib().size() > 0) {
            cmd = (String)cmd + "CBLLIBS=" + CompilerOptionsUtil.getLibList(cobOpts.getCbllib()) + ",";
        }
        cmd = (String)cmd + "CBLMAXRC=" + cobOpts.getMaxrc() + ",";
        if (cobOpts.getReplace().size() > 0) {
            cmd = (String)cmd + CompilerOptionsUtil.prepareCobolReplaceStrings(cobOpts.getReplace()) + ",";
        }
        cmd = (String)cmd + "MIXED=" + (cobOpts.isMixedcase() ? "YES" : "NO");
        if (!cobOpts.getCbladdop().isEmpty()) {
            cmd = (String)cmd + ",CBLADDOP=" + CompilerOptionsUtil.addQuotesIfRequired(cobOpts.getCbladdop());
        }
        return cmd;
    }

    public static String getPliOptions(CompileType compOpts) {
        if (compOpts == null || compOpts.getPli() == null) {
            return "";
        }
        Plitype pliOpts = compOpts.getPli();
        Object cmd = "SETP ";
        cmd = (String)cmd + "BIN63=" + (pliOpts.isBin63() ? "YES," : "NO,");
        cmd = (String)cmd + "DEC31=" + (pliOpts.isFixdec() ? "YES," : "NO,");
        cmd = (String)cmd + "GRAPHIC=" + (pliOpts.isGraph() ? "YES," : "NO,");
        cmd = (String)cmd + "UNALIGNED=" + (pliOpts.isUnalign() ? "YES," : "NO,");
        if (pliOpts.getPlilib().size() > 0) {
            cmd = (String)cmd + "PLILIBS=" + CompilerOptionsUtil.getLibList(pliOpts.getPlilib()) + ",";
        }
        cmd = (String)cmd + "PLIMAXRC=" + pliOpts.getMaxrc();
        if (!pliOpts.getPliaddop().isEmpty()) {
            cmd = (String)cmd + ",PLIADDOP=" + CompilerOptionsUtil.addQuotesIfRequired(pliOpts.getPliaddop());
        }
        return cmd;
    }

    public static String getAsmOptions(CompileType compOpts) {
        if (compOpts == null || compOpts.getAsm() == null) {
            return "";
        }
        Asmtype asmOpts = compOpts.getAsm();
        StringBuilder sb = new StringBuilder("SETA ");
        sb.append("DBCS=").append(asmOpts.isDbcs() ? "YES," : "NO,");
        sb.append("NOALIGN=").append(asmOpts.isNoalign() ? "YES," : "NO,");
        if (asmOpts.getAsmlib().size() > 0) {
            sb.append("ASMLIBS=").append(CompilerOptionsUtil.getLibList(asmOpts.getAsmlib())).append(",");
        }
        sb.append("ASMMAXRC=").append(asmOpts.getMaxrc());
        if (!asmOpts.getAsmaddop().isEmpty()) {
            sb.append(",ASMADDOP=").append(CompilerOptionsUtil.addQuotesIfRequired(asmOpts.getAsmaddop()));
        }
        return sb.toString();
    }

    private static String addQuotesIfRequired(String s) {
        if (s.matches("'.+'")) {
            return s;
        }
        if (s.matches("\".+\"")) {
            return s;
        }
        return "'" + s + "'";
    }

    private static String getLibList(EList<String> list) {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while (i < list.size()) {
            if (i == 0) {
                sb.append((String)list.get(i));
            } else {
                sb.append(",").append((String)list.get(i));
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String prepareCobolReplaceStrings(EList<ReplaceType> list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            ReplaceType aRepType = (ReplaceType)list.get(i);
            if (i == 0) {
                sb.append("RFROM").append(i + 1).append("=").append(aRepType.getRepfrom()).append(",RTO").append(i + 1).append("=").append(aRepType.getRepto());
            } else {
                sb.append(",RFROM").append(i + 1).append("=").append(aRepType.getRepfrom()).append(",RTO").append(i + 1).append("=").append(aRepType.getRepto());
            }
            ++i;
        }
        return sb.toString();
    }
}

