/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.io;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsTemplateOptions;
import com.ibm.etools.fm.core.socket.func.I1SLParser;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.LegacyRemoteServicesCall;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.etools.fm.jhost.core.socket.response.PutRecTemplateResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.PutRecXTemplateResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.RepDseAttrResponsePacket;
import com.ibm.etools.fm.jhost.editor.formatted.FMEditSessionPropertiesJhost;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecXResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.SimpleResponsePacket;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;

public class ZosConnectionFM
extends CommonConnectionFM {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ZosConnectionFM.class);
    private boolean setTargetRequiredBeforeSave = false;
    private IZRL targetSaveResource = null;

    private String toTmpxCommand(IZRL aTemplate) {
        String request = "TMPX " + ZosConnectionFM.formatTemplateResource(aTemplate);
        return this.appendXMLVerIfRequired(request);
    }

    private String appendXMLVerIfRequired(String request) {
        String xmlVersionTag = FMHostJhost.getXmlVersionTag((IPDHost)this.pdHost);
        if (!xmlVersionTag.isEmpty()) {
            request = (String)request + "," + xmlVersionTag;
        }
        return ((String)request).toUpperCase();
    }

    private void setFmiHex(IHowIsGoing monitor) throws InterruptedException {
        try {
            Result<StringBuffer> result = this.executeUtilityFunction("SET FMIHEX=ON", null, new StringWriter(), monitor);
            if (result.isSuccessfulWithoutWarnings()) {
                logger.debug((Object)"Host supports FMI HEX, some template data will be exchanged as printable hex");
            } else {
                logger.debug((Object)"Older host version does not support FMI HEX, template data will be exchanged as plain characters");
            }
        }
        catch (CommunicationException e) {
            logger.error((Object)"Error caught while setting FMI HEX. Proceeding with connection.", (Throwable)e);
        }
    }

    private static String formatTemplateResource(IZRL aTemplate) {
        if (aTemplate instanceof Member) {
            Member aMember = (Member)aTemplate;
            return "DSN=" + aMember.asDataSet().getName() + ",MEMBER=" + aMember.getName();
        }
        return "DSN=" + aTemplate.getFormattedName();
    }

    public ZosConnectionFM(IPDHost pdHost, IPDConnectEndpoint endpoint, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        this(pdHost, endpoint, null, monitor);
    }

    public ZosConnectionFM(IPDHost pdHost, IPDConnectEndpoint endpoint, PDContext pdContext, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        super(pdHost, endpoint, pdContext, monitor);
        if (pdHost.getHostType() != HostType.ZOS) {
            throw new IllegalArgumentException("Only supports zOS host type");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean browseTemplateInXML(IZRL aTemplate, String fullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException {
        logger.debug((Object)("Starting template edit session: " + aTemplate.getFormattedName()));
        try {
            this.setFmiHex(monitor);
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return false;
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
                String request = this.toTmpxCommand(aTemplate);
                this.writePacket(29, request, null, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() <= 4) return this.performGETRECX(monitor, result, writer);
                result.setRC(reqResp.getReturnCode());
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_BROWSE_TEMPLATE_EXC, aTemplate.getFormattedName());
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean browseTemplateInXML(IZRL aTemplate, String fullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor, String xmlBuffer) throws InterruptedException {
        logger.debug((Object)("Starting template edit session: " + aTemplate.getFormattedName()));
        try {
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return false;
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
                String request = this.toTmpxCommand(aTemplate);
                xmlBuffer = xmlBuffer.replaceAll("<\\?xml version=\"1\\.0\" encoding=\\\"ISO-8859-1\"\\?\\>", "");
                this.writePacket(29, request, xmlBuffer, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() <= 4) return this.performGETRECX(monitor, result, writer);
                result.setRC(reqResp.getReturnCode());
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_BROWSE_TEMPLATE_EXC, aTemplate.getFormattedName());
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean browseTemplate1InXML(ImsTemplateOptions options, String fullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException {
        logger.debug((Object)("Starting IMS template edit session: " + options.getTemplate().getFormattedName()));
        try {
            this.setFmiHex(monitor);
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return false;
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
                String request = this.toTmpxCommand(options.getTemplate());
                this.writePacket(29, request, null, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() <= 4) return this.performGETRECX(monitor, result, writer);
                result.setRC(reqResp.getReturnCode());
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_BROWSE_TEMPLATE_EXC, options.getTemplate().getFormattedName());
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean browseTemplate2InXML(Db2TemplateOptions options, String fullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException {
        logger.debug((Object)("Starting DB2 template edit session: " + options.toCommandString()));
        try {
            this.setFmiHex(monitor);
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return false;
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
                String request = options.toCommandString();
                this.writePacket(29, request, null, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() <= 4) return this.performGETRECX(monitor, result, writer);
                result.setRC(reqResp.getReturnCode());
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_BROWSE_TEMPLATE_EXC, options.getTemplate().getFormattedName());
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startTemplateMappingSessionInXML(IZRL fromTemplate, IZRL toTemplate, String fromfullLocalFilePath, String toFullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor, boolean overwriteExistingMapping) throws InterruptedException {
        logger.debug((Object)("Starting template mapping session. from: " + fromTemplate.getFormattedName() + " to:" + toTemplate.getFormattedName() + " overwrite? " + overwriteExistingMapping));
        try {
            this.setFmiHex(monitor);
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return false;
            }
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedWriter fromWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fromfullLocalFilePath), StandardCharsets.UTF_8));){
                String overwriteOps = "";
                overwriteOps = overwriteExistingMapping ? ",CORRESP=YES" : ",CORRESP=NO";
                Object request = this.toTmpxCommand(fromTemplate);
                request = (String)request + ",TCOUT=" + toTemplate.getFormattedName() + overwriteOps.toUpperCase().trim();
                this.writePacket(29, (String)request, null, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() > 4) {
                    result.setRC(reqResp.getReturnCode());
                    return false;
                }
                if (!this.performGETRECX(monitor, result, fromWriter)) {
                    return false;
                }
                result.addSubResult(this.readToMappingTemplate(toTemplate, toFullLocalFilePath, monitor));
                return result.isSuccessfulWithoutWarnings();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_MAPPING_TEMPLATE_EXC, fromTemplate.getFormattedName(), toTemplate.getFormattedName());
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    public boolean createNewTemplate(IZRL aTemplate, String fullLocalFilePath, StringBuffer xmlNewTemplateSpec, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException {
        block7: {
            block6: {
                logger.trace((Object)("Creating new template: " + aTemplate.getFormattedName() + "). New contents: " + String.valueOf(xmlNewTemplateSpec)));
                this.setFmiHex(monitor);
                result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
                if (result.isSuccessfulWithoutWarnings()) break block6;
                return false;
            }
            String request = "TMPX".toUpperCase();
            request = this.appendXMLVerIfRequired(request);
            this.writePacket(29, request, null, monitor);
            SimpleResponsePacket tmpXResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (tmpXResp.getMsgCount() > 0) {
                result.add(Arrays.asList(tmpXResp.getMessages(this.pdHost.getCodePage())));
            }
            if (tmpXResp.getReturnCode() <= 4) break block7;
            result.setRC(tmpXResp.getReturnCode());
            return false;
        }
        try {
            if (xmlNewTemplateSpec.toString().contains("DYNAMIC")) {
                return this.updateAndRetrieveTemplate(true, aTemplate, xmlNewTemplateSpec, fullLocalFilePath, result, monitor);
            }
            return this.updateAndRetrieveTemplate(aTemplate, xmlNewTemplateSpec, fullLocalFilePath, result, monitor);
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_CREATE_NEW_TEMPLATE_EXC, aTemplate.getFormattedName());
            logger.error((Object)errMsg, e);
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    public Result<StringBuffer> createNewTemplate(IHowIsGoing monitor, IZRL targetResource) throws InterruptedException {
        logger.trace((Object)"Creating a new template session");
        this.setTargetRequiredBeforeSave = true;
        this.targetSaveResource = targetResource;
        Result result = new Result();
        try {
            this.setFmiHex(monitor);
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return result;
            }
            String request = "TMPX".toUpperCase();
            request = this.appendXMLVerIfRequired(request);
            this.writePacket(29, request, null, monitor);
            SimpleResponsePacket tmpXResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (tmpXResp.getMsgCount() > 0) {
                result.add(Arrays.asList(tmpXResp.getMessages(this.pdHost.getCodePage())));
            }
            if (tmpXResp.getReturnCode() > 4) {
                result.setRC(tmpXResp.getReturnCode());
                return result;
            }
            return result;
        }
        catch (CommunicationException | IOException e) {
            String errMsg = "Exception thrown while creating a new template session.";
            logger.error((Object)errMsg, e);
            result.add(errMsg);
            result.add(e);
            return result;
        }
    }

    @Override
    public Result<StringBuffer> sessionSave(IHowIsGoing monitor) throws InterruptedException {
        if (this.setTargetRequiredBeforeSave) {
            Result saveAsResult = new Result();
            this.isssueSaveAs(this.targetSaveResource, (Result<StringBuffer>)saveAsResult, monitor);
            return saveAsResult;
        }
        return super.sessionSave(monitor);
    }

    public boolean updateAndStartTemplateEditSession(IZRL aTemplate, String fullLocalFilePath, StringBuffer xmlNewTemplateSpec, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException {
        block6: {
            block5: {
                logger.debug((Object)("Update and starting template edit session: " + aTemplate.getFormattedName() + "."));
                this.setFmiHex(monitor);
                result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
                if (result.isSuccessfulWithoutWarnings()) break block5;
                return false;
            }
            String request = this.toTmpxCommand(aTemplate);
            this.writePacket(29, request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() <= 4) break block6;
            result.setRC(reqResp.getReturnCode());
            return false;
        }
        try {
            return this.updateAndRetrieveTemplate(aTemplate, xmlNewTemplateSpec, fullLocalFilePath, result, monitor);
        }
        catch (CommunicationException | IOException e) {
            String errMsg = MessageFormat.format(Messages.Connection_UPDATE_AND_START_EX, aTemplate);
            logger.error((Object)errMsg, e);
            result.add(errMsg);
            result.add(e);
            return false;
        }
    }

    private boolean updateAndRetrieveTemplate(IZRL aTemplate, StringBuffer xmlNewTemplateSpec, String fullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException, IOException, CommunicationException {
        return this.updateAndRetrieveTemplate(false, aTemplate, xmlNewTemplateSpec, fullLocalFilePath, result, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateAndRetrieveTemplate(boolean dynamicTemplate, IZRL aTemplate, StringBuffer xmlNewTemplateSpec, String fullLocalFilePath, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException, IOException, CommunicationException {
        byte[] putRecBytes = "PUTREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        byte[] xmlNewTemplateSpecBytes = xmlNewTemplateSpec.toString().getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        int packetLen = xmlNewTemplateSpecBytes.length + putRecBytes.length + 16 + 2;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(33);
        buf.putInt(6);
        buf.put(putRecBytes);
        buf.put(new byte[2]);
        buf.putInt(1);
        buf.put(xmlNewTemplateSpecBytes);
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
        PutRecXTemplateResponsePacket putrecxResp = new PutRecXTemplateResponsePacket(this.socketIO, monitor);
        if (putrecxResp.getMsgCount() > 0) {
            result.add(Arrays.asList(putrecxResp.getMessages(this.pdHost.getCodePage())));
        }
        if (putrecxResp.getReturnCode() > 4) {
            result.setRC(putrecxResp.getReturnCode());
            return false;
        }
        if (!dynamicTemplate && !this.isssueSaveAs(aTemplate, result, monitor)) {
            return false;
        }
        Throwable throwable = null;
        Object var13_14 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
            String getRecReq = "GETRECX";
            this.writePacket(32, getRecReq, null, monitor);
            GetRecXResponsePacket getRecxResp = new GetRecXResponsePacket(this.socketIO, monitor);
            if (getRecxResp.getMsgCount() > 0) {
                result.add(Arrays.asList(getRecxResp.getMessages(this.pdHost.getCodePage())));
            }
            if (getRecxResp.getReturnCode() > 4) {
                result.setRC(getRecxResp.getReturnCode());
                return false;
            }
            byte[] xmlBuffer = new byte[getRecxResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            writer.write(s);
            while (true) {
                if (!getRecxResp.isiRepMoreData()) {
                    return true;
                }
                getRecReq = "GETRECX";
                this.writePacket(32, getRecReq, null, monitor);
                getRecxResp = new GetRecXResponsePacket(this.socketIO, monitor);
                xmlBuffer = new byte[getRecxResp.getiPayLoadLength()];
                this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
                s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                writer.write(s);
                if (getRecxResp.getMsgCount() <= 0) continue;
                result.add(Arrays.asList(getRecxResp.getMessages(this.pdHost.getCodePage())));
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public boolean sendBytesToHost(IHowIsGoing monitor, ByteBuffer bb) throws IOException, CommunicationException, InterruptedException {
        int len = bb.position();
        bb.position(0);
        bb.putInt(len);
        this.socketIO.writeBytes(bb.array(), 0, len, monitor);
        PutRecTemplateResponsePacket putRecTempResp = new PutRecTemplateResponsePacket(this.socketIO, monitor);
        if (putRecTempResp.getMsgCount() > 0 && putRecTempResp.getReturnCode() > 4) {
            logger.printCurrentStackTrace("An error occurred while import");
            return false;
        }
        return true;
    }

    private boolean isssueSaveAs(IZRL aTemplate, Result<StringBuffer> result, IHowIsGoing monitor) throws InterruptedException {
        Result<StringBuffer> saveAsResult = this.sessionSaveAs(aTemplate, monitor);
        result.copy(saveAsResult);
        if (saveAsResult.getRC() > 4) {
            result.setRC(saveAsResult.getRC());
            return false;
        }
        return true;
    }

    public boolean getCompilerListing(Result<StringBuffer> result, IFile file, IHowIsGoing monitor) throws InterruptedException {
        return super.getCompilerListing(result, file.getLocation().toFile(), monitor);
    }

    public boolean startEditSession(BaseEditorOptions baseOptions, FMEditSessionProperties props, String editSessionInitParms, Result<StringBuffer> result, IHowIsGoing monitor) throws Exception {
        RepDseAttrResponsePacket reqResp;
        block9: {
            String editorCommand;
            block8: {
                block7: {
                    try {
                        this.setFmiHex(monitor);
                        editorCommand = new LegacyRemoteServicesCall(this.pdHost, baseOptions.getaTemplate() != null ? baseOptions.getaTemplate().getSystem() : this.pdHost, "TCIN").addRMTokenID(this, baseOptions.toCommandString(), monitor);
                        logger.trace((Object)("Starting editor with: " + editorCommand));
                        result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
                        if (result.isSuccessfulWithoutWarnings()) break block7;
                        return false;
                    }
                    catch (Exception ex) {
                        this.unlock();
                        return false;
                    }
                }
                if (editSessionInitParms == null) break block8;
                logger.debug((Object)("sending editor init command [" + editSessionInitParms + "]."));
                if (this.sendEditorOptions(editSessionInitParms, result, monitor)) break block8;
                this.unlock();
                return false;
            }
            this.writePacket(baseOptions.isEditSession() ? 22 : 26, editorCommand, null, monitor);
            reqResp = new RepDseAttrResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.getSystem().getCodePage())));
            }
            reqResp.fillEditSessionAttributes((FMEditSessionPropertiesJhost)props);
            if (reqResp.getReturnCode() < 4) break block9;
            logger.debug((Object)("Connection.browseRecordsInXML() ERROR RC=" + reqResp.getReturnCode()));
            result.setRC(reqResp.getReturnCode());
            result.add(MessageFormat.format(Messages.Connection_START_EDIT_ERR, baseOptions.getaResource().getFormattedName(), baseOptions.getaTemplate() != null ? baseOptions.getaTemplate().getFormattedName() : "", editSessionInitParms, editorCommand));
            result.add(MessageFormat.format(Messages.Connection_INVOCATION_CMD, editorCommand));
            if (this.socketIO.bytesAvailable() > 0) {
                byte[] buffer = new byte[this.socketIO.bytesAvailable()];
                this.socketIO.readBytes(buffer, 0, buffer.length, monitor);
                result.add(new String(buffer, this.pdHost.getHostType().getCommunicationEncoding()));
            }
            this.unlock();
            return false;
        }
        result.setRC(reqResp.getReturnCode());
        return true;
    }

    public boolean startEditSession(BaseEditorOptions baseOptions, FMEditSessionProperties props, String editSessionInitParms, String xmlBuffer, Result<StringBuffer> result, IHowIsGoing monitor) throws Exception {
        RepDseAttrResponsePacket reqResp;
        block11: {
            String editorCommand;
            block10: {
                block9: {
                    try {
                        IZRL backupTemplate = baseOptions.getaTemplate();
                        if (baseOptions.getDynamicTemplateFlag()) {
                            baseOptions.setaTemplate(null);
                        }
                        editorCommand = new LegacyRemoteServicesCall(this.pdHost, baseOptions.getaTemplate() != null ? baseOptions.getaTemplate().getSystem() : this.pdHost, "TCIN").addRMTokenID(this, baseOptions.toCommandString(), monitor);
                        xmlBuffer = xmlBuffer.replaceAll("<\\?xml version=\"1\\.0\" encoding=\\\"ISO-8859-1\"\\?\\>", "");
                        logger.trace((Object)("Starting editor with: " + editorCommand + xmlBuffer));
                        if (baseOptions.getDynamicTemplateFlag()) {
                            baseOptions.setaTemplate(backupTemplate);
                        }
                        result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
                        if (result.isSuccessfulWithoutWarnings()) break block9;
                        return false;
                    }
                    catch (Exception ex) {
                        this.unlock();
                        return false;
                    }
                }
                if (editSessionInitParms == null) break block10;
                logger.debug((Object)("sending editor init command [" + editSessionInitParms + "]."));
                if (this.sendEditorOptions(editSessionInitParms, result, monitor)) break block10;
                this.unlock();
                return false;
            }
            byte[] editorCommandBytes = editorCommand.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
            byte[] updateInputXmlBytes = xmlBuffer.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
            logger.trace((Object)("XMLbuffer packet length: " + String.valueOf(updateInputXmlBytes.length)));
            logger.trace((Object)("command packet length: " + String.valueOf(editorCommandBytes.length)));
            int packetLen = updateInputXmlBytes.length + editorCommandBytes.length + 12;
            ByteBuffer buf = ByteBuffer.allocate(packetLen);
            buf.putInt(packetLen);
            buf.putInt(baseOptions.isEditSession() ? 22 : 26);
            buf.putInt(editorCommandBytes.length);
            buf.put(editorCommandBytes);
            buf.put(updateInputXmlBytes);
            logger.trace((Object)("FMI_DSE packet length: " + String.valueOf(packetLen)));
            this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            reqResp = new RepDseAttrResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.getSystem().getCodePage())));
            }
            reqResp.fillEditSessionAttributes((FMEditSessionPropertiesJhost)props);
            if (reqResp.getReturnCode() < 4) break block11;
            logger.debug((Object)("Connection.browseRecordsInXML() ERROR RC=" + reqResp.getReturnCode()));
            result.setRC(reqResp.getReturnCode());
            result.add(MessageFormat.format(Messages.Connection_START_EDIT_ERR, baseOptions.getaResource().getFormattedName(), baseOptions.getaTemplate() != null ? baseOptions.getaTemplate().getFormattedName() : "", editSessionInitParms, editorCommand));
            result.add(MessageFormat.format(Messages.Connection_INVOCATION_CMD, editorCommand));
            if (this.socketIO.bytesAvailable() > 0) {
                byte[] buffer = new byte[this.socketIO.bytesAvailable()];
                this.socketIO.readBytes(buffer, 0, buffer.length, monitor);
                result.add(new String(buffer, this.pdHost.getHostType().getCommunicationEncoding()));
            }
            this.unlock();
            return false;
        }
        result.setRC(reqResp.getReturnCode());
        return true;
    }

    public Result<StringBuffer> startEdit2Session(Db2EditOptions db2EditOptions, FMEditSessionProperties props, IHowIsGoing monitor) throws Exception {
        Result result = new Result();
        logger.trace((Object)("Starting DB2 edit session. Parameters: " + db2EditOptions.toCommandString()));
        logger.trace((Object)("where? " + (db2EditOptions.getWhereClause() != null ? db2EditOptions.getWhereClause().toString() : "nothing")));
        this.setFmiHex(monitor);
        result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
        if (!result.isSuccessfulWithoutWarnings()) {
            return result;
        }
        String browseInitRequest = db2EditOptions.toCommandString();
        String whereClause = null;
        if (db2EditOptions.getWhereClause() != null) {
            whereClause = db2EditOptions.getWhereClause().toString();
        }
        this.writePacket(db2EditOptions.isEdit() ? 22 : 26, browseInitRequest, whereClause, monitor);
        RepDseAttrResponsePacket response = new RepDseAttrResponsePacket(this.socketIO, monitor);
        if (response.getMsgCount() > 0) {
            result.add(Arrays.asList(response.getMessages(this.pdHost.getCodePage())));
        }
        response.fillEditSessionAttributes((FMEditSessionPropertiesJhost)props);
        if (response.getReturnCode() >= 4) {
            logger.debug((Object)("Connection.startEdit2Session() ERROR RC=" + response.getReturnCode()));
            result.setRC(response.getReturnCode());
            result.add(MessageFormat.format(Messages.Connection_INVOCATION_CMD, browseInitRequest));
            this.unlock();
            return result;
        }
        if (db2EditOptions.isEdit() && props.noUpdate() && props.noInsertDelete()) {
            DialogUtils.openInfoThreadSafe((String)Messages.Information, (String)Messages.Connection_EditSubstituedWithBrowseSession, (String)result.getMessagesCombined().toString());
            db2EditOptions.setEdit(false);
        }
        result.setRC(response.getReturnCode());
        return result;
    }

    public Result<StringBuffer> startEdit1Session(ImsEditorOptions imsEditOptions, FMEditSessionProperties props, IHowIsGoing monitor) throws Exception {
        this.setFmiHex(monitor);
        Result result = new Result();
        String browseInitRequest = imsEditOptions.toCommandString();
        String subsystemOpts = I1SLParser.toHostFormat(imsEditOptions.getSubsystem().getCanonicalConfig());
        logger.trace((Object)("Starting IMS edit session. Parameters: " + browseInitRequest));
        logger.trace((Object)("IMS subsystem options: " + subsystemOpts));
        result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
        if (!result.isSuccessfulWithoutWarnings()) {
            return result;
        }
        this.writePacket(imsEditOptions.isEditSession() ? 22 : 26, browseInitRequest, subsystemOpts, monitor);
        RepDseAttrResponsePacket response = new RepDseAttrResponsePacket(this.socketIO, monitor);
        if (response.getMsgCount() > 0) {
            result.add(Arrays.asList(response.getMessages(this.pdHost.getCodePage())));
        }
        response.fillEditSessionAttributes((FMEditSessionPropertiesJhost)props);
        if (response.getReturnCode() >= 4) {
            logger.debug((Object)("Connection.startEdit2Session() ERROR RC=" + response.getReturnCode()));
            result.setRC(response.getReturnCode());
            result.add(MessageFormat.format(Messages.Connection_INVOCATION_CMD, browseInitRequest));
            this.unlock();
            return result;
        }
        if (imsEditOptions.isEditSession() && props.noUpdate() && props.noInsertDelete()) {
            DialogUtils.openInfoThreadSafe((String)Messages.Information, (String)Messages.Connection_EditSubstituedWithBrowseSession, (String)result.getMessagesCombined().toString());
            imsEditOptions.setEditSession(false);
        }
        result.setRC(response.getReturnCode());
        return result;
    }
}

