/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.io;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Objects;

public class RemoteToken
implements AutoCloseable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final CommonConnectionFM connection;
    private final String tokenID;
    private static final PDLogger logger = PDLogger.get(RemoteToken.class);

    public RemoteToken(CommonConnectionFM connection, String tokenID) {
        Objects.requireNonNull(tokenID, "Must provide non-null tokenID");
        if (tokenID.trim().isEmpty()) {
            throw new IllegalArgumentException("Must provide a non-empty tokenID");
        }
        Objects.requireNonNull(connection, "Must provide non-null remoteHost");
        this.tokenID = tokenID;
        this.connection = connection;
    }

    public String getRMCommandString() {
        return "RM:" + this.tokenID + ":";
    }

    public CommonConnectionFM getConnection() {
        return this.connection;
    }

    public static RemoteToken getRMPrefix(IPDHost sourceHost, IPDHost destHost, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(sourceHost, "Must specify a non-null sourceHost.");
        Objects.requireNonNull(destHost, "Must specify a non-null destHost.");
        CommonConnectionFM connection = (CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(sourceHost, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)sourceHost), howIsGoing);
        return RemoteToken.addTokenToExistingConnection(connection, sourceHost, destHost, howIsGoing);
    }

    public static RemoteToken addTokenToExistingConnection(CommonConnectionFM connection, IPDHost sourceHost, IPDHost destHost, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(connection, "Must specify a non-null connection.");
        Objects.requireNonNull(sourceHost, "Must specify a non-null sourceHost.");
        Objects.requireNonNull(destHost, "Must specify a non-null destHost.");
        AuthDetails login = destHost.getLogin(true);
        HostDetails destHostDetails = ConnectionUtilities.getHostDetails((String)destHost.getHostID());
        boolean hasToken = PDToolsCommonServerClientJhost.getAuthTokenManager().hasAuthToken(destHostDetails, login.getUsername(), howIsGoing);
        if (hasToken) {
            login.setPassToken(PDToolsCommonServerClientJhost.getAuthTokenManager().getAuthToken(destHostDetails, login.getUsername(), howIsGoing));
        }
        StringWriter writer = new StringWriter();
        Result<StringBuffer> result = connection.createDynamicCrossSystemTokenOnHost(destHost.getHostName(), destHost.getPort(), login.getUsername(), login.getPassword(), login.getPassToken(), writer, howIsGoing);
        String string = writer.toString();
        logger.trace((Object)MessageFormat.format("RCONN OUTPUT IS! ''{0}'' ''{1}''", result.getOutput(), string));
        if (result.isSuccessfulWithoutWarnings()) {
            if (string.trim().isEmpty()) {
                throw new CommunicationException(MessageFormat.format("Couldn''t get a token for connection between {0} and {1}", sourceHost, destHost));
            }
            return new RemoteToken(connection, string);
        }
        throw new CommunicationException(result.dumpOutputAndMessages(true));
    }

    @Override
    public void close() {
        logger.trace((Object)"Remote token implictly expired ( & unlocked connection)");
        this.connection.unlock();
    }
}

