/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.io;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.RemoteToken;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RemoteServicesCall {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final NewUtilityFunction function;
    private final IPDHost sourceSystem;
    private final Map<NewUtilityFunction.AbstractUtilFuncParam<String>, IPDHost> remoteHosts;

    public RemoteServicesCall(NewUtilityFunction function, IPDHost sourceResourceSystem, IPDHost destinationSystem, NewUtilityFunction.AbstractUtilFuncParam<String> destParameter) {
        Objects.requireNonNull(function);
        Objects.requireNonNull(sourceResourceSystem);
        Objects.requireNonNull(destinationSystem);
        Objects.requireNonNull(destParameter);
        this.function = function;
        this.sourceSystem = sourceResourceSystem;
        this.remoteHosts = new LinkedHashMap<NewUtilityFunction.AbstractUtilFuncParam<String>, IPDHost>();
        this.remoteHosts.put(destParameter, destinationSystem);
    }

    public void addParameterMapping(IPDHost destinationSystem, NewUtilityFunction.AbstractUtilFuncParam<String> destParameter) {
        Objects.requireNonNull(destinationSystem);
        Objects.requireNonNull(destParameter);
        this.remoteHosts.put(destParameter, destinationSystem);
    }

    public Result<StringBuffer> run(IHowIsGoing monitor) {
        Objects.requireNonNull(this.function, "Must provide a non-null function.");
        try {
            Throwable throwable = null;
            Object var4_4 = null;
            try (CommonConnectionFM connection = (CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(this.sourceSystem, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.sourceSystem), monitor);){
                for (Map.Entry<NewUtilityFunction.AbstractUtilFuncParam<String>, IPDHost> entry : this.remoteHosts.entrySet()) {
                    if (!RemoteServicesCall.checkSystem(this.sourceSystem, entry.getValue())) continue;
                    RemoteToken token = RemoteToken.addTokenToExistingConnection(connection, this.sourceSystem, entry.getValue(), monitor);
                    this.function.setValue(entry.getKey(), token.getRMCommandString() + (String)this.function.getValueOrDefault(entry.getKey(), this.sourceSystem), this.sourceSystem);
                }
                return UtilityFunctionRunner.execute(connection, this.function, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CommunicationException | IllegalArgumentException | InterruptedException e) {
            return new Result(e);
        }
    }

    private static boolean checkSystem(IPDHost resourceSystem, IPDHost templateSystem) {
        return templateSystem != null && !resourceSystem.isSameSystem(templateSystem);
    }
}

