/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.io;

import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.RemoteToken;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Objects;

public class LegacyRemoteServicesCall {
    private final IPDHost sourceSystem;
    private final IPDHost destinationSystem;
    private final String destinationParameter;

    public LegacyRemoteServicesCall(IPDHost sourceSystem, IPDHost destinationSystem, String destinationParameter) {
        Objects.requireNonNull(sourceSystem);
        Objects.requireNonNull(destinationSystem);
        Objects.requireNonNull(destinationParameter);
        this.sourceSystem = sourceSystem;
        this.destinationSystem = destinationSystem;
        this.destinationParameter = destinationParameter;
    }

    public String addRMTokenID(CommonConnectionFM connection, String oldCommandString, IHowIsGoing howIsGoing) throws IllegalArgumentException, InterruptedException, CommunicationException {
        Objects.requireNonNull(oldCommandString, "Must provide a non-null function string.");
        Objects.requireNonNull(this.destinationParameter, "Must provide a non-null destResourceParameter string.");
        if (!this.sourceSystem.isSameSystem(this.destinationSystem)) {
            RemoteToken rmPrefix = RemoteToken.addTokenToExistingConnection(connection, this.sourceSystem, this.destinationSystem, howIsGoing);
            rmPrefix = RemoteToken.getRMPrefix(this.sourceSystem, this.destinationSystem, howIsGoing);
            StringBuilder builder = new StringBuilder(oldCommandString);
            int index = builder.indexOf(this.destinationParameter + "=") + this.destinationParameter.length() + 1;
            builder.insert(index, rmPrefix.getRMCommandString());
            return builder.toString();
        }
        return oldCommandString;
    }
}

