/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.io;

import com.ibm.etools.fm.core.FMCorePlugin;
import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.util.CompilerOptionsUtil;
import com.ibm.etools.fm.core.util.StringUtils;
import com.ibm.etools.fm.jhost.core.socket.io.ZosConnectionJhost;
import com.ibm.etools.fm.jhost.core.socket.response.FMFunctionResponsePacket;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecXResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.SimpleResponsePacket;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class CommonConnectionFM
extends ZosConnectionJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CommonConnectionFM.class);

    @Deprecated
    public CommonConnectionFM(IPDHost pdHost, IPDConnectEndpoint endpoint, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        this(pdHost, endpoint, null, monitor);
    }

    public CommonConnectionFM(IPDHost pdHost, IPDConnectEndpoint endpoint, PDContext pdContext, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        super(pdHost, endpoint, pdContext, monitor);
    }

    protected void reportVersionIncompatibility(String msg) {
        if (FMCorePlugin.isReportingVersionIncompatibility()) {
            boolean warnIncompatibility = DialogUtils.openWarningWithToggleThreadSafe((String)Messages.Warning, (String)msg, (String)Messages.FMPreferencePage_REPORT_VER_ERR, (boolean)FMCorePlugin.isReportingVersionIncompatibility());
            FMCorePlugin.setReportingVersionIncompatibility(warnIncompatibility);
        }
    }

    public Result<StringBuffer> updateCompilerOptions(IHowIsGoing monitor) throws InterruptedException {
        if (FMHost.getSystem((IPDHost)this.pdHost).getCompilerOptions().isEmpty()) {
            return new Result();
        }
        CompileType compOpts = CompilerOptionsUtil.load(FMHost.getSystem((IPDHost)this.pdHost).getCompilerOptions(), this.pdHost.getConnectionName());
        if (compOpts == null) {
            return new Result();
        }
        ArrayList<String> compilerOptions = new ArrayList<String>();
        compilerOptions.add(CompilerOptionsUtil.getSetLanguageOptions(compOpts));
        compilerOptions.add(CompilerOptionsUtil.getCobolOptions(compOpts));
        compilerOptions.add(CompilerOptionsUtil.getCommaSeperatorOption(compOpts));
        compilerOptions.add(CompilerOptionsUtil.getPliOptions(compOpts));
        compilerOptions.add(CompilerOptionsUtil.getAsmOptions(compOpts));
        logger.trace(new Object[]{"language options: ", compilerOptions.get(0)});
        logger.trace(new Object[]{"COBOL options: ", compilerOptions.get(1)});
        logger.trace(new Object[]{"PL/I options: ", compilerOptions.get(2)});
        logger.trace(new Object[]{"HLASM options: ", compilerOptions.get(3)});
        for (String compilerOptionCmd : compilerOptions) {
            if (compilerOptionCmd.isEmpty()) continue;
            try {
                Result<StringBuffer> r = this.executeUtilityFunction(compilerOptionCmd, null, new StringWriter(), monitor);
                if (r.isSuccessfulWithoutWarnings()) continue;
                logger.error(new Object[]{"Errors occurred sending compiler options to host: ", r.getMessagesCombined()});
                String displayErrMsg = Messages.MSG_CONNECTION_FAILED + r.getMessagesCombined().toString().replace("FMNBA113 ", "");
                if (compilerOptionCmd.contains("COMMADEC=YES")) {
                    displayErrMsg = Messages.MSG_CONNECTION_FAILED + Messages.MSG_COMMADEC_ERROR;
                }
                ConnPoolManagerFM.instance().setErrorMessageFromHost(displayErrMsg);
                return r;
            }
            catch (CommunicationException e) {
                logger.error((Object)"Exception encountered sending compiler options to host:", (Throwable)e);
                return new Result(e);
            }
        }
        return new Result(0);
    }

    public Result<StringBuffer> setHeaderPagesOff(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        if (this.headersDisabled) {
            return new Result();
        }
        StringWriter sw = new StringWriter();
        Result<StringBuffer> result = this.executeUtilityFunction("SET HEADERPG=NO", null, sw, monitor);
        String messages = sw.getBuffer().toString();
        if (!messages.isEmpty()) {
            result.add(messages);
        }
        if (!result.hasError()) {
            this.headersDisabled = true;
        }
        return result;
    }

    public Result<StringBuffer> setXMLErrorsWrapped(boolean xmlErrorsOn, IHowIsGoing monitor) throws InterruptedException {
        Result result;
        try {
            result = this.setXMLErrorsRaw(xmlErrorsOn, false, monitor);
        }
        catch (CommunicationException e) {
            result = new Result(e);
        }
        return result;
    }

    public Result<StringBuffer> setXMLErrorsRaw(boolean xmlErrorsOn, boolean xmlRegardless, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        if (!xmlRegardless && this.xmlErrorsOn == xmlErrorsOn) {
            return new Result();
        }
        StringWriter sw = new StringWriter();
        Result<StringBuffer> result = this.executeUtilityFunction("SETF XMLMSG=" + (xmlErrorsOn ? "ON" : "OFF"), null, sw, monitor);
        String messages = sw.getBuffer().toString();
        if (!messages.isEmpty()) {
            result.add(messages);
        }
        if (!result.hasError()) {
            this.xmlErrorsOn = xmlErrorsOn;
        }
        return result;
    }

    public Result<StringBuffer> sessionQuit(IHowIsGoing monitor) {
        logger.trace((Object)"Issuing QUIT for the current session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            String request = "QUIT".toUpperCase();
            this.writePacket(13, request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            result.setRC(reqResp.getReturnCode());
            return result;
        }
        catch (InterruptedException e) {
            logger.info((Object)"error encountered:", (Throwable)e);
            result.add((Throwable)e);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"error encountered:", (Throwable)e);
            result.add((Throwable)e);
            return result;
        }
    }

    public Result<StringBuffer> sessionFile(IHowIsGoing monitor) {
        logger.trace((Object)"Issuing FILE command for the current edit session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            String request = "FILE".toUpperCase();
            this.writePacket(27, request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            result.setRC(reqResp.getReturnCode());
            return result;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_SAVE_DB2_EX;
            logger.error((Object)errMsg, (Throwable)e);
            result.setRC(8);
            result.add((Throwable)e);
            result.add(errMsg);
            return result;
        }
    }

    public Result<StringBuffer> sessionSave(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"Issuing SAVE command for the current edit session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            String request = "SAVE".toUpperCase();
            this.writePacket(14, request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            result.setRC(reqResp.getReturnCode());
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_SAVE_EX;
            logger.error((Object)errMsg, (Throwable)e);
            result.setRC(8);
            result.add((Throwable)e);
            result.add(errMsg);
            return result;
        }
    }

    public Result<StringBuffer> doGETRECX(String fullLocalFilePath, IHowIsGoing monitor) throws InterruptedException {
        Result result;
        Result result2 = new Result((Object)new StringBuffer());
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));
            String getRecReq = "GETRECX";
            this.writePacket(32, getRecReq, null, monitor);
            GetRecXResponsePacket reqResp = new GetRecXResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result2.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() > 4) {
                result2.setRC(reqResp.getReturnCode());
                Result result3 = result2;
                return result3;
            }
            byte[] xmlBuffer = new byte[reqResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getCommunicationCodePage());
            writer.write(s);
            while (reqResp.isiRepMoreData()) {
                getRecReq = "GETRECX";
                this.writePacket(32, getRecReq, null, monitor);
                reqResp = new GetRecXResponsePacket(this.socketIO, monitor);
                xmlBuffer = new byte[reqResp.getiPayLoadLength()];
                this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
                s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getCommunicationCodePage());
                if (reqResp.getMsgCount() > 0) {
                    result2.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                writer.write(s);
            }
            result = result2;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result2.add((Throwable)e);
            Result result4 = result2;
            return result4;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Result<StringBuffer> sessionSaveAs(IZRL target, IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)("SAVEAS to " + target.getFormattedName()));
        Result result = new Result((Object)new StringBuffer());
        try {
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return result;
            }
            Object request = "";
            if (target instanceof Member) {
                Member member = (Member)target;
                request = "SAVEAS DSN=" + StringUtils.escapeResourceForHost(member.asDataSet().getName()) + ",MEMBER=" + StringUtils.escapeResourceForHost(member.getName());
            } else {
                request = "SAVEAS DSN=" + StringUtils.escapeResourceForHost(target.getFormattedName());
            }
            request = (String)request + ",REPLACE=YES";
            logger.trace((Object)("SAVEAS command: " + (String)request));
            this.writePacket(15, (String)request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            result.setRC(reqResp.getReturnCode());
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (!result.isSuccessfulWithoutWarnings() && result.getMessagesCombined().toString().indexOf("FMNBB291") != -1) {
                this.socketIO.closeConnection();
            }
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.setRC(8);
            result.add(MessageFormat.format(Messages.Connection_SAVE_AS_ERR, target.getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    public Result<StringBuffer> executeUtilityFunction(String roadmapCommand, String data, StringWriter writer, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        return this.executeUtilityFunction(roadmapCommand, data, null, false, writer, monitor);
    }

    public Result<StringBuffer> executeUtilityFunction(String roadmapCommand, String data, int[] offsetLen, boolean scramble, StringWriter writer, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(roadmapCommand, "Must provide a non-null roadmapCommand");
        Objects.requireNonNull(writer, "Must provide a non-null writer");
        Result result = new Result((Object)new StringBuffer());
        try {
            String response;
            this.writePacket(20, roadmapCommand, data, offsetLen, scramble, monitor);
            FMFunctionResponsePacket fmResp = new FMFunctionResponsePacket(this.socketIO, monitor);
            byte[] fmBuffer = new byte[fmResp.getTotalBytes() - 32];
            this.socketIO.readBytes(fmBuffer, fmBuffer.length, monitor);
            if (fmResp.isiRepXml()) {
                this.retrieveFMUtilityXMLOutput(fmBuffer, writer);
            } else if (fmResp.getMsgCount() > 0) {
                this.readUtilityFunctionMessages(fmBuffer, fmResp.getMsgCount(), writer);
            } else {
                String s = new String(fmBuffer, 0, fmBuffer.length, this.pdHost.getCodePage());
                writer.write(s);
            }
            if (fmResp.isiRepMoreData()) {
                GetRecXResponsePacket respPacket = null;
                do {
                    if (fmResp.isiRepXml()) {
                        this.writePacket(32, "GETRECX", null, monitor);
                        respPacket = new GetRecXResponsePacket(this.socketIO, monitor);
                    } else {
                        this.writePacket(16, "GETREC", null, monitor);
                        respPacket = new GetRecResponsePacket(this.socketIO, monitor);
                    }
                    if (respPacket.getReturnCode() > 8) {
                        result.setRC(respPacket.getReturnCode());
                        return result;
                    }
                    byte[] dataBuffer = new byte[respPacket.getTotalBytes() - 32];
                    this.socketIO.readBytes(dataBuffer, dataBuffer.length, monitor);
                    if (fmResp.isiRepXml()) {
                        this.retrieveFMUtilityXMLOutput(dataBuffer, writer);
                        continue;
                    }
                    this.readUtilityFunctionMessages(dataBuffer, respPacket.getMsgCount(), writer);
                } while (respPacket.isiRepMoreData());
            }
            if ((response = writer.toString()) != null && response.length() != 0) {
                result.add(response);
            }
            result.setRC(fmResp.getReturnCode());
        }
        catch (IOException e) {
            throw new CommunicationException((Exception)e);
        }
        return result;
    }

    protected void writePacket(int functionCode, String input, String data, IHowIsGoing monitor) throws IOException {
        this.writePacket(functionCode, input, data, null, false, monitor);
    }

    private void writePacket(int functionCode, String input, String data, int[] offsetLen, boolean scramble, IHowIsGoing monitor) throws IOException {
        String encoding = this.pdHost.getCommunicationCodePage();
        String codepage = this.pdHost.getCodePage();
        byte[] ebcdicInput = null;
        if (!encoding.equalsIgnoreCase(codepage)) {
            String commString = null;
            if (input.startsWith("FIND") || input.startsWith("CHANGE") || input.startsWith("FREE") || input.startsWith("EXCLUDE") || input.startsWith("SHOW") || input.startsWith("LHEX") || input.startsWith("SORT")) {
                String[] parms;
                StringBuffer sb = new StringBuffer();
                String[] stringArray = parms = input.split("\\s");
                int n = parms.length;
                int n2 = 0;
                while (n2 < n) {
                    String convparm;
                    String parm = stringArray[n2];
                    if (parm.startsWith("#")) {
                        convparm = parm;
                    } else {
                        byte[] cpBytes = parm.toString().getBytes(codepage);
                        convparm = new String(cpBytes, encoding);
                    }
                    sb.append(convparm + " ");
                    ++n2;
                }
                commString = sb.toString();
            } else {
                String inputString = input.toString();
                byte[] cpBytes = CommonConnectionFM.getByteArrayBySubSystem(encoding, codepage, inputString);
                commString = new String(cpBytes, encoding);
                if (data != null && !scramble) {
                    data = new String(data.getBytes(codepage), encoding);
                }
            }
            ebcdicInput = commString.getBytes(encoding);
        } else {
            ebcdicInput = input.toString().getBytes(encoding);
        }
        byte[] ebcdicData = null;
        if (data != null) {
            if (offsetLen == null || offsetLen.length == 0) {
                ebcdicData = data.getBytes(encoding);
            } else {
                byte[] tmpEbcdicData = new byte[data.length() * 2];
                int tmpEbcdicDataLen = 0;
                int offsetLenInd = 0;
                int i = 0;
                while (i < data.length()) {
                    if (offsetLenInd >= 0) {
                        byte[] tmpEbcdicData2;
                        if (i < offsetLen[offsetLenInd]) {
                            tmpEbcdicData[tmpEbcdicDataLen++] = (byte)data.charAt(i++);
                            continue;
                        }
                        if (i != offsetLen[offsetLenInd]) continue;
                        byte[] byArray = tmpEbcdicData2 = data.substring(offsetLen[offsetLenInd], offsetLen[offsetLenInd] + offsetLen[offsetLenInd + 1]).getBytes(encoding);
                        int n = tmpEbcdicData2.length;
                        int n3 = 0;
                        while (n3 < n) {
                            byte b = byArray[n3];
                            tmpEbcdicData[tmpEbcdicDataLen++] = b;
                            ++n3;
                        }
                        i += offsetLen[offsetLenInd + 1];
                        if ((offsetLenInd += 2) < offsetLen.length) continue;
                        offsetLenInd = -1;
                        continue;
                    }
                    tmpEbcdicData[tmpEbcdicDataLen++] = (byte)data.charAt(i++);
                }
                ebcdicData = new byte[tmpEbcdicDataLen];
                i = 0;
                while (i < tmpEbcdicDataLen) {
                    ebcdicData[i] = tmpEbcdicData[i];
                    ++i;
                }
            }
        }
        int packetLen = ebcdicInput.length + (ebcdicData == null ? 0 : ebcdicData.length) + 12;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(functionCode);
        buf.putInt(ebcdicInput.length);
        buf.put(ebcdicInput);
        if (ebcdicData != null) {
            buf.put(scramble ? StringUtils.ScrambleString(ebcdicData) : ebcdicData);
        }
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
    }

    private static byte[] getByteArrayBySubSystem(String encoding, String codepage, String inputString) throws UnsupportedEncodingException {
        byte[] cpBytes = inputString.getBytes(codepage);
        if (inputString.startsWith("D2E ") || inputString.startsWith("D2V ")) {
            cpBytes = inputString.getBytes(encoding);
        }
        return cpBytes;
    }

    private boolean retrieveFMUtilityXMLOutput(byte[] data, StringWriter writer) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            byte[] buffer = new byte[1000];
            int len = 0;
            while ((len = input.read(buffer)) != -1) {
                String s = new String(buffer, 0, len, this.pdHost.getCommunicationCodePage());
                writer.write(s);
            }
            return true;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean readUtilityFunctionMessages(byte[] bytes, int messageCount, StringWriter writer) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        byte[] msgLenBuff = new byte[4];
        try {
            int i = 0;
            while (i < messageCount) {
                if (((InputStream)input).skip(4L) != 4L) {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (((InputStream)input).read(msgLenBuff, 0, 4) == -1) {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    throw new ArrayIndexOutOfBoundsException();
                }
                int msgLen = this.byteArrayToInt(msgLenBuff, 0);
                byte[] msgBuff = new byte[msgLen];
                int actualread = ((InputStream)input).read(msgBuff, 0, msgLen);
                String s = new String(msgBuff, 0, msgLen, this.pdHost.getCodePage());
                writer.write(s + "\n");
                ++i;
            }
            return true;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception e) {
                    logger.error((Object)"Error during stream cleanup", (Throwable)e);
                }
            }
        }
    }

    public synchronized void forceConnectionClose() {
        if (this.socketIO != null) {
            this.socketIO.closeConnection();
        }
    }

    public synchronized boolean requestConnectionClose() {
        if (this.isLocked()) {
            logger.trace((Object)("Ignoring close request for connection " + this.toString()));
            return false;
        }
        if (this.socketIO == null) {
            return true;
        }
        this.socketIO.closeConnection();
        return true;
    }

    public synchronized boolean isClosed(IHowIsGoing monitor) throws InterruptedException {
        if (this.socketIO == null || this.socketIO.isClosed()) {
            return true;
        }
        if (this.isLocked()) {
            return false;
        }
        if (monitor != null) {
            Result<StringBuffer> result = this.pingServer(new StringWriter(), monitor);
            return result.getRC() > 4;
        }
        return false;
    }

    public Result<StringBuffer> pingServer(StringWriter output, IHowIsGoing monitor) throws InterruptedException {
        Result result;
        logger.trace((Object)"Checking connection is alive - pinging server...");
        try {
            result = this.executeUtilityFunction("VER", null, output, monitor);
        }
        catch (CommunicationException e) {
            result = new Result(e);
        }
        logger.trace((Object)("Checking connection is alive - finished, RC=" + result.getRC()));
        return result;
    }

    public Result<StringBuffer> createDynamicCrossSystemTokenOnHost(String remoteHost, int remotePort, String remoteUserid, String remotePass, String remotePassToken, StringWriter output, IHowIsGoing monitor) throws InterruptedException {
        Result<StringBuffer> result;
        logger.info((Object)MessageFormat.format("Getting token for {0}:*********@{1}:{2}", remoteUserid, remoteHost, remotePort));
        String encoding = this.pdHost.getCommunicationCodePage();
        String codepage = this.pdHost.getCodePage();
        try {
            int[] offsetLen = new int[6];
            if (remotePassToken != null) {
                offsetLen = new int[8];
            }
            String data = new String();
            char[] len = new char[4];
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(remotePort);
            buf.position(0);
            int i = 0;
            while (i < 4) {
                len[0] = (char)buf.get(i);
                data = data.concat(new String(len, 0, 1));
                ++i;
            }
            if (!codepage.equalsIgnoreCase(encoding)) {
                try {
                    byte[] tmp = remoteHost.getBytes(codepage);
                    remoteHost = new String(tmp, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)("Exception converting RCONN remoteHost from " + codepage + " to " + encoding));
                }
            }
            len[0] = (char)remoteHost.length();
            data = data.concat(new String(len, 0, 1));
            offsetLen[0] = data.length();
            offsetLen[1] = len[0];
            data = data.concat(remoteHost);
            len[0] = (char)remoteUserid.length();
            data = data.concat(new String(len, 0, 1));
            offsetLen[2] = data.length();
            offsetLen[3] = len[0];
            data = data.concat(remoteUserid);
            len[0] = (char)remotePass.length();
            data = data.concat(new String(len, 0, 1));
            offsetLen[4] = data.length();
            offsetLen[5] = len[0];
            data = data.concat(remotePass);
            if (remotePassToken != null) {
                len[0] = (char)remotePassToken.length();
                data = data.concat(new String(len, 0, 1));
                offsetLen[6] = data.length();
                offsetLen[7] = len[0];
                data = data.concat(remotePassToken);
            }
            result = this.executeUtilityFunction("RCONN", data, offsetLen, true, output, monitor);
            result.setOutput((Object)new StringBuffer(output.toString()));
        }
        catch (CommunicationException e) {
            result = new Result<StringBuffer>(e);
        }
        return result;
    }

    @Deprecated
    public AuthDetails getAuthInfo(TheHost theHost) throws InterruptedException {
        return ConnectionUtilities.getLogin((TheHost)theHost, null);
    }

    public AuthDetails getAuthInfo(TheHost theHost, IHowIsGoing monitor) throws InterruptedException {
        return ConnectionUtilities.getLogin((TheHost)theHost, (IHowIsGoing)monitor);
    }
}

