/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.I1SLParser;
import com.ibm.etools.fm.core.socket.func.ims.SSDEFType;
import com.ibm.etools.fm.jhost.core.util.XmlTag;

public class SSDEFParser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static String toHostFormat(SSDEFType ssdefType, ImsSubsystemConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Must specify a non-null ImsSubsystemConfig parameter.");
        }
        return SSDEFParser.toXmlTag(ssdefType, config).serialize();
    }

    public static XmlTag toXmlTag(SSDEFType ssdefType, ImsSubsystemConfig config) {
        XmlTag imsSsid = new XmlTag("IMSssid");
        XmlTag libs = SSDEFParser.toXmlTag_ssid(config.getSubsystem().getSubsystemID());
        SSDEFParser.toXmlTag(libs, ssdefType, config);
        imsSsid.addChild(libs);
        return imsSsid;
    }

    public static void toXmlTag(XmlTag ssid, SSDEFType ssdefType, ImsSubsystemConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Must provide a non-null config.");
        }
        XmlTag tag = I1SLParser.toXmlTag(config);
        for (XmlTag child : tag.getChildren()) {
            if (child.getTagName().equals("dli")) {
                XmlTag dli = ssid.createChild("dli");
                for (XmlTag d : child.getChildren()) {
                    if (!d.getTagName().equals("reslib")) continue;
                    dli.createChild(d.getTagName()).setAttribute("dsn", (String)d.getAttributes().get("dsn"));
                }
            }
            if (ssdefType.sendDBDLib() && !config.isDir() && child.getTagName().equals("dbdlib")) {
                System.out.println(ssid.createChild(child.getTagName()).setAttribute("dsn", (String)child.getAttributes().get("dsn")).serialize());
            }
            if (!ssdefType.sendPSBLib() || config.isDir() || !child.getTagName().equals("psblib")) continue;
            System.out.println(ssid.createChild(child.getTagName()).setAttribute("dsn", (String)child.getAttributes().get("dsn")).serialize());
        }
        System.out.println(tag.serialize());
        System.out.println(String.valueOf((Object)ssdefType) + " " + ssid.serialize());
    }

    public static XmlTag toXmlTag_ssid(String subSystemID) {
        XmlTag ssid = new XmlTag("ssid");
        ssid.setAttribute("name", subSystemID);
        return ssid;
    }
}

