/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.socket.func.ims.RelatedDBToPCBMapping;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PCBNParser
extends UtilityFunctionParser<List<RelatedDBToPCBMapping>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_PCBNOS = "pcbnos";
    private static final String TAG_XDB = "xdb";
    private static final String TAG_PCB = "pcb";
    private static final String TAG_MISSING = "missing";
    private static final String ATT_XDB_NAME = "name";
    private static final String ATT_XDB_PCB_INDEX = "index";
    private static final String ATT_XDB_PCB_NAME = "name";
    private static final String ATT_XDB_PCB_DBD = "dbd";
    private static final String ATT_XDB_PCB_SEGP = "segp";
    private static final String ATT_XDB_PCB_SEGD = "segd";
    private static final String ATT_XDB_PCB_TYPE = "type";
    private static final String ATT_XDB_PCB_PROCOPTS = "procopts";
    private static final String ATT_XDB_PCB_PROCSEQ = "procseq";
    private static final PDLogger logger = PDLogger.get(PCBNParser.class);
    private final ImsPsb psb;
    private List<RelatedDBToPCBMapping> xDBs;
    private String dbName;

    public PCBNParser(ImsPsb psb) {
        if (psb == null) {
            throw new IllegalArgumentException("Must specify a non-null ImsPsb.");
        }
        this.psb = psb;
        this.xDBs = new ArrayList<RelatedDBToPCBMapping>();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_PCBNOS.equals(qName)) {
            if (TAG_XDB.equals(qName)) {
                String name;
                this.dbName = name = attributes.getValue("name");
            } else if (TAG_PCB.equals(qName)) {
                String index = attributes.getValue(ATT_XDB_PCB_INDEX);
                String name = attributes.getValue("name");
                String dbd = attributes.getValue(ATT_XDB_PCB_DBD);
                String segp = attributes.getValue(ATT_XDB_PCB_SEGP);
                String segd = attributes.getValue(ATT_XDB_PCB_SEGD);
                String type = attributes.getValue(ATT_XDB_PCB_TYPE);
                String procopts = attributes.getValue(ATT_XDB_PCB_PROCOPTS);
                String procseq = attributes.getValue(ATT_XDB_PCB_PROCSEQ);
                ImsPcb pcb = new ImsPcb(this.psb, name, index);
                pcb.setDbdName(dbd);
                pcb.setSegp(segp);
                pcb.setSegd(segd);
                pcb.setType(type);
                pcb.setProcopts(procopts);
                pcb.setProcseq(procseq);
                boolean addedMapping = false;
                for (RelatedDBToPCBMapping mapping : this.xDBs) {
                    if (!mapping.getDatabase().equals(this.dbName)) continue;
                    mapping.addPCB(pcb);
                    addedMapping = true;
                }
                if (!addedMapping) {
                    this.xDBs.add(new RelatedDBToPCBMapping(this.dbName, pcb));
                }
            } else {
                logger.warn((Object)("Unknown tag encountered " + qName));
            }
        }
    }

    protected Result<List<RelatedDBToPCBMapping>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.xDBs);
        return result;
    }
}

