/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.ims.SSDEFParser;
import com.ibm.etools.fm.core.socket.func.ims.SSDEFType;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;

public class PCBN
extends UtilityFunction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public PCBN() {
        super("PCBN");
    }

    public boolean isExpectingXmlOutput() {
        return true;
    }

    public void setPsb(ImsPsb psb, ImsRegionType regionType) {
        this.setParameterValue("PSBMEM", psb.getName());
        switch (regionType) {
            case BMP: {
                this.setParameterValue("REGNTYPE", "BMP");
                break;
            }
            case DLI: {
                this.setParameterValue("REGNTYPE", "DLI");
                break;
            }
            default: {
                logger.info((Object)("Warning: Unhandled type: " + String.valueOf((Object)regionType)));
            }
        }
        this.setParameterValue("IMSID", psb.getSubsystem().getSubsystemID());
    }

    public void setConfig(ImsSubsystemConfig config) {
        this.setPostHeaderData(SSDEFParser.toHostFormat(SSDEFType.PCBN, config));
    }

    public void setFunctionCode(String function) {
        this.setParameterValue("FUNCTION", function);
    }

    public void setDBDMEM(String databaseName) {
        this.setParameterValue("DBDMEM", databaseName);
    }

    public void setPCBNum(String pcbNum) {
        this.setParameterValue("PCBNUM", "(" + pcbNum + ")");
    }

    public static enum PcbnRegnType {
        BMP,
        DLI;

    }
}

