/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.socket.func.ims.PcbList;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PCBLParser
extends UtilityFunctionParser<List<ImsPcb>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_PCBLIST = "pcblist";
    private static final String ATT_PCBLIST_IOPCB = "iopcb";
    private static final String TAG_PCB = "pcb";
    private static final String ATT_PCB_INDEX = "index";
    private static final String ATT_PCB_NAME = "name";
    private static final String ATT_PCB_DBD = "dbd";
    private static final String ATT_PCB_SEGP = "segp";
    private static final String ATT_PCB_SEGD = "segd";
    private static final String ATT_PCB_TYPE = "type";
    private static final String ATT_PCB_PROCOPTS = "procopts";
    private static final String ATT_PCB_PROCSEQ = "procseq";
    private static final String ATT_PCB_ERROR = "error";
    private static final PDLogger logger = PDLogger.get(PCBLParser.class);
    private final ImsPsb psb;
    private final PcbList pcbList = new PcbList();

    public PCBLParser(ImsPsb psb) {
        if (psb == null) {
            throw new IllegalArgumentException("Must specify a non-null ImsPsb.");
        }
        this.psb = psb;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (TAG_PCBLIST.equals(qName)) {
            String iopcb = attributes.getValue(ATT_PCBLIST_IOPCB);
            if (iopcb != null) {
                this.pcbList.setIoPCB(true);
            }
        } else if (TAG_PCB.equals(qName)) {
            String index = attributes.getValue(ATT_PCB_INDEX);
            String name = attributes.getValue(ATT_PCB_NAME);
            String dbd = attributes.getValue(ATT_PCB_DBD);
            String segp = attributes.getValue(ATT_PCB_SEGP);
            String segd = attributes.getValue(ATT_PCB_SEGD);
            String type = attributes.getValue(ATT_PCB_TYPE);
            String procopts = attributes.getValue(ATT_PCB_PROCOPTS);
            String procseq = attributes.getValue(ATT_PCB_PROCSEQ);
            String error = attributes.getValue(ATT_PCB_ERROR);
            ImsPcb pcb = new ImsPcb(this.psb, name, index);
            pcb.setDbdName(dbd);
            pcb.setUseabilityNote(error);
            pcb.setSegp(segp);
            pcb.setSegd(segd);
            pcb.setType(type);
            pcb.setProcopts(procopts);
            pcb.setProcseq(procseq);
            this.pcbList.addPCB(pcb);
        } else {
            logger.warn((Object)("Unknown tag encountered " + qName));
        }
    }

    protected Result<List<ImsPcb>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.pcbList.getList());
        return result;
    }
}

