/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsDd;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.jhost.core.util.XmlTag;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDDSParser
extends UtilityFunctionParser<List<ImsDd>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_DBD_DDS = "dbd_dds";
    private static final String TAG_DD = "dd";
    private static final String ATT_DBD_DDS_NAME = "name";
    private static final String ATT_DD_DBD = "dbd";
    private static final String ATT_DD_NAME = "name";
    private static final String ATT_DD_DSN = "dsn";
    private static final String ATT_DD_ERROR = "error";
    private static final PDLogger logger = PDLogger.get(LDDSParser.class);
    private final List<ImsDd> ddList = new ArrayList<ImsDd>();
    private final StringBuilder errors = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_DBD_DDS.equals(qName)) {
            if (TAG_DD.equals(qName)) {
                String dbd = attributes.getValue(ATT_DD_DBD);
                String name = attributes.getValue("name");
                String dsn = attributes.getValue(ATT_DD_DSN);
                String error = attributes.getValue(ATT_DD_ERROR);
                ImsDd dd = new ImsDd(dbd, name);
                dd.setDsn(dsn);
                this.ddList.add(dd);
                if (error != null) {
                    if (this.errors.length() > 0) {
                        this.errors.append("\n");
                    }
                    this.errors.append(MessageFormat.format(Messages.LDDSParser_0, dbd, name, dsn, error));
                }
            } else {
                logger.warn((Object)("Unknown tag encountered " + qName));
            }
        }
    }

    protected Result<List<ImsDd>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.ddList);
        if (this.errors.length() > 0) {
            result.setRC(8);
            result.add(this.errors.toString());
        }
        return result;
    }

    public static String serialize(String databaseName, List<ImsDd> dds) {
        Objects.requireNonNull(dds, "Must provide a non-null dds list.");
        XmlTag dbd_dds = new XmlTag(TAG_DBD_DDS);
        dbd_dds.setAttribute("name", databaseName);
        for (ImsDd imsDd : dds) {
            XmlTag ddTag = dbd_dds.createChild(TAG_DD);
            ddTag.setAttribute(ATT_DD_DBD, imsDd.getDbdName());
            ddTag.setAttribute("name", imsDd.getName());
            ddTag.setAttribute(ATT_DD_DSN, imsDd.getDsn());
        }
        return dbd_dds.serialize();
    }
}

