/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsKeyField;
import com.ibm.etools.fm.core.model.ims.ImsSecondaryIndex;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDBDParser
extends UtilityFunctionParser<ImsDatabaseInfo> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_DBD = "dbd";
    private static final String TAG_SEG = "seg";
    private static final String TAG_KEYFLD = "keyfld";
    private static final String TAG_SECIDX = "secidx";
    private static final String TAG_SRCHFLD = "srchfld";
    private static final String ATT_DBD_DSN = "dsn";
    private static final String ATT_DBD_HALDB = "haldb";
    private static final String ATT_SEG_NAME = "name";
    private static final String ATT_SEG_LVL = "lvl";
    private static final String ATT_SEG_LEN = "len";
    private static final String ATT_SEG_KEYL = "keyl";
    private static final String ATT_SEG_PARENT = "parent";
    private static final String ATT_SEG_GROUP = "group";
    private static final String ATT_KEYFLD_NAME = "name";
    private static final String ATT_KEYFLD_POS = "pos";
    private static final String ATT_KEYFLD_LEN = "len";
    private static final String ATT_KEYFLD_TYPE = "type";
    private static final String ATT_SECIDX_NAME = "name";
    private static final String ATT_SECIDX_TARGSEG = "targseg";
    private static final String ATT_SECIDX_SRCSEG = "srcseg";
    private static final String ATT_SRCHFLD_NAME = "name";
    private static final PDLogger logger = PDLogger.get(LDBDParser.class);
    private final ImsDatabase database;
    private String dsn;
    private boolean isHalDb = false;
    private final List<ImsSegment> segments = new ArrayList<ImsSegment>();
    private final Map<String, ImsSegment> namesToSegments = new HashMap<String, ImsSegment>();
    private final List<ImsSecondaryIndex> indexes = new ArrayList<ImsSecondaryIndex>();

    public LDBDParser(ImsDatabase database) {
        this.database = database;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (TAG_DBD.equals(qName)) {
            String dsn = attributes.getValue(ATT_DBD_DSN);
            String haldb = attributes.getValue(ATT_DBD_HALDB);
            this.dsn = dsn;
            this.isHalDb = "1".equals(haldb);
        } else if (TAG_SEG.equals(qName)) {
            String name = attributes.getValue("name");
            String level = attributes.getValue(ATT_SEG_LVL);
            String len = attributes.getValue("len");
            String keylen = attributes.getValue(ATT_SEG_KEYL);
            String parent = attributes.getValue(ATT_SEG_PARENT);
            String group = attributes.getValue(ATT_SEG_GROUP);
            ImsSegment seg = new ImsSegment(name);
            seg.setLevel(Integer.parseInt(level));
            seg.setLength(Integer.parseInt(len));
            if (parent != null) {
                ImsSegment parentSeg = this.namesToSegments.get(parent);
                if (parentSeg == null) {
                    throw new IllegalStateException();
                }
                seg.setParent(parentSeg);
            }
            seg.setGroup(group);
            seg.setTotalKeyLength(keylen);
            this.segments.add(seg);
            this.namesToSegments.put(seg.getName(), seg);
        } else if (TAG_KEYFLD.equals(qName)) {
            String name = attributes.getValue("name");
            String pos = attributes.getValue(ATT_KEYFLD_POS);
            String len = attributes.getValue("len");
            String type = attributes.getValue(ATT_KEYFLD_TYPE);
            ImsSegment lastSeg = this.segments.get(this.segments.size() - 1);
            ImsKeyField imsKeyField = new ImsKeyField(lastSeg, name);
            imsKeyField.setPos(pos);
            imsKeyField.setLength(Integer.parseInt(len));
            imsKeyField.setType(ImsKeyField.ImsKeyFieldType.parseFromLdbdRep(type));
            LinkedList<ImsKeyField> keyFields = new LinkedList<ImsKeyField>(lastSeg.getKeyFields());
            keyFields.add(imsKeyField);
            lastSeg.setKeyFields(keyFields);
        } else if (TAG_SECIDX.equals(qName)) {
            String name = attributes.getValue("name");
            String targetSegmentName = attributes.getValue(ATT_SECIDX_TARGSEG);
            String sourceSegmentName = attributes.getValue(ATT_SECIDX_SRCSEG);
            ImsSecondaryIndex index = new ImsSecondaryIndex(name);
            ImsSegment targetSegment = this.namesToSegments.get(targetSegmentName);
            if (targetSegment == null) {
                throw new IllegalStateException();
            }
            index.setTarget(targetSegment);
            ImsSegment sourceSegment = this.namesToSegments.get(sourceSegmentName);
            if (sourceSegment == null) {
                throw new IllegalStateException();
            }
            index.setSource(sourceSegment);
            this.indexes.add(index);
        } else if (TAG_SRCHFLD.equals(qName)) {
            String name = attributes.getValue("name");
            ImsSecondaryIndex lastIndex = this.indexes.get(this.indexes.size() - 1);
            LinkedList<String> searchFieldNames = new LinkedList<String>(lastIndex.getSearchFieldNames());
            searchFieldNames.add(name);
            lastIndex.setSearchFieldNames(searchFieldNames);
        } else {
            logger.warn((Object)("Unknown tag encountered " + qName));
        }
    }

    protected Result<ImsDatabaseInfo> getResult() {
        Result result = super.getResult();
        if (result.isSuccessfulWithoutWarnings()) {
            result.setOutput((Object)new ImsDatabaseInfo(this.database, this.dsn, this.segments, this.indexes, this.isHalDb));
        }
        return result;
    }
}

