/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.ims;

import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.ims.SSDEFParser;
import com.ibm.etools.fm.core.socket.func.ims.SSDEFType;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;

public class LDBD
extends UtilityFunction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public LDBD() {
        super("LDBD");
    }

    public boolean isExpectingXmlOutput() {
        return true;
    }

    public void setDatabase(ImsDatabase db, ImsRegionType regionType) {
        this.setParameterValue("DBDMEM", db.getName());
        switch (regionType) {
            case BMP: {
                this.setParameterValue("REGNTYPE", "BMP");
                break;
            }
            case DLI: {
                this.setParameterValue("REGNTYPE", "DLI");
                break;
            }
            default: {
                throw new IllegalArgumentException(regionType.name());
            }
        }
        this.setParameterValue("IMSID", db.getSubsystem().getSubsystemID());
    }

    public void setFunctionCode(IPDHost pdHost, String function) {
        this.setParameterValue("FUNCTION", function);
    }

    public void setConfig(ImsSubsystemConfig config) {
        this.setPostHeaderData(SSDEFParser.toHostFormat(SSDEFType.LDBD, config));
    }

    public static enum PcblRegnType {
        BMP,
        DLI;

    }
}

