/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func.db2;

import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XSQLParser
extends UtilityFunctionParser<String[][]> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_DB2_LIST = "db2list";
    private static final String TAG_COLUMN = "col";
    private static final String TAG_ROW = "row";
    private static final String TAG_COLUMN_VALUE = "cv";
    private static final String ATTR_REFERENCE = "ref";
    private static final String ATTR_NAME = "nam";
    private static final String ATTR_VALUE = "val";
    private List<String[]> rows = new ArrayList<String[]>();
    private IPDHost host;
    private HostType hostType;

    public XSQLParser(IPDHost host) {
        this.host = host;
        this.hostType = host.getHostType();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_DB2_LIST.equals(qName)) {
            if (TAG_COLUMN.equals(qName)) {
                String name = StringUtils.parseHexString((String)attributes.getValue(ATTR_NAME), (String)this.host.getCodePage());
                if (this.rows.isEmpty()) {
                    this.rows.add(new String[]{name});
                } else {
                    String[] oldHeaderRow = this.rows.remove(0);
                    String[] newHeaderRow = new String[oldHeaderRow.length + 1];
                    System.arraycopy(oldHeaderRow, 0, newHeaderRow, 0, oldHeaderRow.length);
                    newHeaderRow[newHeaderRow.length - 1] = name;
                    this.rows.add(0, newHeaderRow);
                }
            } else if (TAG_ROW.equals(qName)) {
                int numColumns = this.rows.get(0).length;
                this.rows.add(new String[numColumns]);
            } else if (TAG_COLUMN_VALUE.equals(qName)) {
                String value = attributes.getValue(ATTR_VALUE);
                String colRef = attributes.getValue(ATTR_REFERENCE);
                int colNum = Integer.parseInt(colRef);
                String[] currentRow = this.rows.get(this.rows.size() - 1);
                if (value != null) {
                    value = StringUtils.parseHexString((String)value, (String)this.host.getCodePage());
                }
                currentRow[colNum - 1] = value;
            }
        }
    }

    public Result<String[][]> getResult() {
        Result result = super.getResult();
        result.setOutput((Object)((String[][])this.rows.toArray((T[])new String[0][])));
        return result;
    }
}

