/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.jhost.core.socket.func.ALLOCDD;
import com.ibm.etools.fm.jhost.core.socket.func.FREEDD;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionRunnerJhost;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.TimeUtils;
import com.ibm.pdtools.common.component.jhost.util.XMLUtils;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;

public class UtilityFunctionRunner
extends UtilityFunctionRunnerJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(UtilityFunctionRunner.class);

    private static <V> V executeRunnable(IPDHost pdHost, IPDConnectEndpoint endpoint, IHowIsGoing monitor, ConnectionRunnable<V> runnable) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(endpoint, "Please specify a non-null endpoint.");
        Throwable throwable = null;
        Object var5_6 = null;
        try (CommonConnectionFM connection = (CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(pdHost, endpoint, monitor);){
            if (connection == null) {
                String s = ConnPoolManagerFM.instance().getErrorMessageFromHost();
                ConnPoolManagerFM.instance().setErrorMessageFromHost("");
                throw new CommunicationException(s);
            }
            return runnable.run(connection, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Result<StringBuffer> execute(IPDHost pdHost, IPDConnectEndpoint endpoint, final UtilityFunction function, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(endpoint, "Please specify a non-null endpoint.");
        logger.trace((Object)("running function: " + function.getCommandString() + " data: " + (function.getPostHeaderData() == null ? "" : function.getPostHeaderData())));
        try {
            return UtilityFunctionRunner.executeRunnable(pdHost, endpoint, monitor, new ConnectionRunnable<Result<StringBuffer>>(){

                @Override
                public Result<StringBuffer> run(CommonConnectionFM connection, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                    return UtilityFunctionRunner.runCommand(connection, function, monitor);
                }
            });
        }
        catch (CommunicationException e) {
            DialogUtils.openErrorThreadSafe((String)Messages.Error, (Throwable)e);
            return new Result(e);
        }
    }

    public static <T extends UtilityFunctionParser<U>, U> Result<U> executeAndParse(IPDHost pdHost, IPDConnectEndpoint endpoint, UtilityFunction function, T parser, IHowIsGoing monitor) throws InterruptedException {
        Result<StringBuffer> commandResult = UtilityFunctionRunner.execute(pdHost, endpoint, function, monitor);
        return UtilityFunctionRunnerJhost.parse(commandResult, parser, (UtilityFunction)function, (String)pdHost.getCodePage());
    }

    public static <T extends UtilityFunctionParser<U>, U> Result<U> executeAndParse(CommonConnectionFM conn, UtilityFunction function, T parser, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Result<StringBuffer> commandResult = UtilityFunctionRunner.runCommand(conn, function, monitor);
        return UtilityFunctionRunner.parse(commandResult, parser, (UtilityFunction)function, (String)conn.getSystem().getCodePage());
    }

    public static <T extends UtilityFunctionParser<U>, U> Result<StringBuffer> execute(CommonConnectionFM conn, UtilityFunction function, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        try {
            Result<StringBuffer> result = UtilityFunctionRunner.runCommand(conn, function, monitor);
            return result;
        }
        finally {
            if (conn != null) {
                conn.unlock();
            }
        }
    }

    public static Result<StringBuffer> runCommand(CommonConnectionFM connection, UtilityFunction utilityFunction, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Result<StringBuffer> setHeadersOffResult;
        Result<StringBuffer> setErrorTypeResult;
        HashMap dds;
        Objects.requireNonNull(connection, "Must provide a non-null connection to run command.");
        Result<StringBuffer> result = null;
        StringWriter writer = new StringWriter();
        String builtCommand = utilityFunction.getCommandString();
        String data = utilityFunction.getPostHeaderData();
        long timeKey = System.nanoTime();
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("{0} {1} {2} {3}{4}", timeKey, connection.getSystem().getDescription(), connection.getSystem().getConnectionName(), builtCommand, data == null ? "" : " data: " + data));
        }
        if ((dds = new HashMap(utilityFunction.getDDs())).size() > 0) {
            monitor.worked(1);
            logger.trace((Object)(timeKey + " Allocating DDs: " + String.valueOf(dds)));
            ALLOCDD allocdd = new ALLOCDD();
            allocdd.setDDsToAllocate(dds);
            Result<StringBuffer> allocResult = UtilityFunctionRunner.runCommand(connection, (UtilityFunction)allocdd, monitor);
            if (!allocResult.isSuccessfulWithoutWarnings()) {
                return allocResult;
            }
        }
        if (!(setErrorTypeResult = connection.setXMLErrorsRaw(utilityFunction.isExpectingXmlOutput(), utilityFunction.isXmlMsgRequiredRegardless(), monitor)).isSuccessfulWithoutWarnings()) {
            return setErrorTypeResult;
        }
        if (utilityFunction.isHeaderDisabling() && !(setHeadersOffResult = connection.setHeaderPagesOff(monitor)).isSuccessfulWithoutWarnings()) {
            return setHeadersOffResult;
        }
        monitor.worked(1);
        Calendar before = Calendar.getInstance();
        result = connection.executeUtilityFunction(builtCommand, data, writer, monitor);
        monitor.worked(1);
        Calendar after = Calendar.getInstance();
        result.setOutput((Object)UtilityFunctionRunnerJhost.processOutput((UtilityFunction)utilityFunction, (StringBuffer)writer.getBuffer()));
        monitor.worked(1);
        if (PDLoggerJhost.isTraceEnabled()) {
            String formatDifference = TimeUtils.formatDifference((Calendar)before, (Calendar)after);
            logger.trace(new Object[]{timeKey, " completed in ", formatDifference, " with max RC=" + result.getRC()});
        }
        if (PDLoggerJhost.isTraceEnabled()) {
            int start = 0;
            int total = ((StringBuffer)result.getOutput()).length() / 1000000 + 1;
            while (start < ((StringBuffer)result.getOutput()).length()) {
                int end = Math.min(((StringBuffer)result.getOutput()).length(), start + 1000000);
                String splitOutput = ((StringBuffer)result.getOutput()).substring(start, end);
                if (PDLogger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format("{0} output ({1}/{2}):{3}", timeKey, start / 1000000 + 1, total, XMLUtils.prettyPrint((String)splitOutput)));
                }
                start += 1000000;
            }
            StringBuilder messagesCombined = result.getMessagesCombined();
            if (messagesCombined.length() > 0) {
                logger.trace(new Object[]{timeKey, " messages:\n", messagesCombined});
            }
        }
        if (dds.size() > 0) {
            monitor.worked(1);
            logger.trace((Object)(timeKey + " Freeing DDs: " + String.valueOf(dds.keySet())));
            FREEDD freedd = new FREEDD();
            freedd.setDDsToFree(dds.keySet());
            Result<StringBuffer> freeResult = UtilityFunctionRunner.runCommand(connection, (UtilityFunction)freedd, monitor);
            if (!freeResult.isSuccessfulWithoutWarnings()) {
                result.addSubResult(freeResult);
            }
            monitor.worked(1);
        }
        return result;
    }

    public static interface ConnectionRunnable<V> {
        public V run(CommonConnectionFM var1, IHowIsGoing var2) throws InterruptedException, CommunicationException;
    }
}

