/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.core.model.data.UssFileProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UFLParser
extends UtilityFunctionParser<List<UssFile>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static List<String> ignoredFiles = Arrays.asList("../", ".../");
    private static final String TAG_FILE_LIST = "Usslist";
    private static final String TAG_FILE = "Ufl";
    private static final String TAG_PROPERTY = "Property";
    private static final String ATT_FILE_NAME = "Name";
    private static final String ATT_FILE_NAME_HEX = "NameX";
    private static final String ATT_FILE_TYPE = "Type";
    private static final String ATT_PROP_KEY = "Key";
    private static final String ATT_PROP_VALUE = "Value";
    private static final String ATT_PROP_VALUE_HEX = "ValueX";
    private static final PDLogger logger = PDLogger.get(UFLParser.class);
    private List<UssFile> ussFiles = new ArrayList<UssFile>();
    private HashMap<String, String> fileProperties = new HashMap();
    private UssFile file;
    private final UssFile parentFile;

    public UFLParser(UssFile parent) {
        this.parentFile = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_FILE_LIST.equals(qName)) {
            if (TAG_FILE.equals(qName)) {
                UssFileType ussType;
                Object name = attributes.getValue("", ATT_FILE_NAME);
                String nameX = attributes.getValue("", ATT_FILE_NAME_HEX);
                if (nameX != null && name == null) {
                    name = StringUtils.parseHexString((String)nameX, (String)this.parentFile.getSystem().getCodePage());
                }
                String type = attributes.getValue("", ATT_FILE_TYPE);
                try {
                    ussType = UssFileType.valueOf(type);
                }
                catch (Exception e) {
                    logger.warn(new Object[]{name, " has unknown type of ", type});
                    ussType = UssFileType.Unkn;
                }
                if (ussType == UssFileType.Dir) {
                    name = (String)name + "/";
                }
                if (name == null) {
                    logger.warn((Object)"Null name encountered");
                } else if (UssFile.isValidName(this.parentFile.getSystem(), (String)name)) {
                    this.file = new UssFile(this.parentFile, (String)name, ussType);
                    if (!ignoredFiles.contains(name)) {
                        this.ussFiles.add(this.file);
                    }
                } else {
                    logger.warn(new Object[]{"Encountered invalid filename ", name});
                }
            } else if (TAG_PROPERTY.equals(qName)) {
                String key = attributes.getValue("", ATT_PROP_KEY);
                String value = attributes.getValue("", ATT_PROP_VALUE);
                String valuex = attributes.getValue("", ATT_PROP_VALUE_HEX);
                if (valuex != null && value == null) {
                    value = StringUtils.parseHexString((String)valuex, (String)this.parentFile.getSystem().getCodePage());
                }
                if (value == null) {
                    value = "";
                }
                if (this.file != null) {
                    this.fileProperties.put(key, value);
                } else {
                    logger.debug(new Object[]{"Property found outside uss file: ", key});
                }
            } else {
                logger.debug(new Object[]{"Unknown element encountered: ", qName});
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_FILE.equals(qName) && this.file != null) {
            this.file.setProperties(new UssFileProperties(this.fileProperties));
            this.file.setConfirmedExists(true);
            this.file = null;
        }
    }

    protected Result<List<UssFile>> getResult() {
        Result result = super.getResult();
        Collections.sort(this.ussFiles, new Comparator<UssFile>(){

            @Override
            public int compare(UssFile object1, UssFile object2) {
                if (object1 != null && object2 != null) {
                    return String.CASE_INSENSITIVE_ORDER.compare(object1.getName(), object2.getName());
                }
                return 0;
            }
        });
        result.setOutput(this.ussFiles);
        return result;
    }
}

