/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class NewUtilityFunction
extends UtilityFunction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(NewUtilityFunction.class);

    public NewUtilityFunction(String command) {
        super(command);
    }

    public <P extends IUtilFuncParam<R>, R> String getRawStringValue(P param) {
        return (String)this.getParameterValues().get(param.getName());
    }

    public <P extends IUtilFuncParam<R>, R> R getValueOrDefault(P param, IPDHost host) {
        String strValue = this.getRawStringValue(param);
        if (strValue == null) {
            return param.getDefaultValue();
        }
        return param.stringToValue(strValue, host);
    }

    public <P extends IUtilFuncParam<R>, R> void setValue(P param, R value, IPDHost host) {
        Objects.requireNonNull(param, "Must provide a non-null param");
        if (value == null) {
            this.setParameterValue(param.getName(), null);
        } else {
            String strValue = param.valueToString(value, host);
            this.setParameterValue(param.getName(), strValue);
        }
    }

    public List<IUtilFuncParam<?>> getAllParameters() {
        Field[] fields;
        ArrayList list = new ArrayList();
        Field[] fieldArray = fields = ((Object)((Object)this)).getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            IsUtilFuncParam annotation = field.getAnnotation(IsUtilFuncParam.class);
            if (annotation != null && IUtilFuncParam.class.isAssignableFrom(field.getType())) {
                try {
                    IUtilFuncParam param = (IUtilFuncParam)field.get(null);
                    list.add(param);
                }
                catch (IllegalAccessException e) {
                    logger.error((Throwable)e);
                }
            }
            ++n2;
        }
        return list;
    }

    public static abstract class AbstractUtilFuncParam<R>
    implements IUtilFuncParam<R> {
        private final String name;
        private final R defaultValue;

        public AbstractUtilFuncParam(String name, R defaultValue) {
            Objects.requireNonNull(name, "Must provide a non-null name");
            if (name.isEmpty()) {
                throw new NullPointerException();
            }
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public R getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public abstract String valueToString(R var1, IPDHost var2);

        @Override
        public abstract R stringToValue(String var1, IPDHost var2);

        public String toString() {
            return this.getName();
        }
    }

    public static class BooleanUtilFuncParam
    extends AbstractUtilFuncParam<Boolean> {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private final String trueValue;
        private final String falseValue;

        public BooleanUtilFuncParam(String name) {
            this(name, false);
        }

        public BooleanUtilFuncParam(String name, boolean defaultValue) {
            this(name, defaultValue, "YES", "NO");
        }

        public BooleanUtilFuncParam(String name, boolean defaultValue, String trueValue, String falseValue) {
            super(name, defaultValue);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public String valueToString(Boolean value, IPDHost host) {
            if (value == null) {
                throw new NullPointerException(this.getName());
            }
            return value != false ? this.trueValue : this.falseValue;
        }

        @Override
        public Boolean stringToValue(String stringValue, IPDHost host) {
            Objects.requireNonNull(stringValue, "Must provide a non-null stringValue");
            return stringValue.equals(this.trueValue);
        }
    }

    public static class EnumSetUtilFuncParam<R extends Enum<R>>
    extends AbstractUtilFuncParam<Set<R>> {
        private final Class<R> enumClass;

        public static <R extends Enum<R>> EnumSetUtilFuncParam<R> createDefaultNone(String name, Class<R> enumClass) {
            return new EnumSetUtilFuncParam<R>(name, EnumSet.noneOf(enumClass), enumClass);
        }

        public EnumSetUtilFuncParam(String name, Set<R> defaultValue, Class<R> enumClass) {
            super(name, defaultValue);
            this.enumClass = enumClass;
        }

        @Override
        public String valueToString(Set<R> value, IPDHost host) {
            if (value == null) {
                throw new NullPointerException(this.getName());
            }
            if (value.isEmpty()) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            for (Enum enumValue : value) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(enumValue.name());
            }
            return "(" + b.toString() + ")";
        }

        @Override
        public Set<R> stringToValue(String value, IPDHost host) {
            String[] names;
            Objects.requireNonNull(value, "Must provide a non-null value");
            if (value.isEmpty()) {
                return EnumSet.noneOf(this.enumClass);
            }
            HashSet<R> parsedEnums = new HashSet<R>();
            String strippedValue = value.substring(1, value.length() - 1);
            String[] stringArray = names = strippedValue.split(StringUtils.escapeRegex((String)","));
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                R parsed = Enum.valueOf(this.enumClass, name);
                parsedEnums.add(parsed);
                ++n2;
            }
            return EnumSet.copyOf(parsedEnums);
        }
    }

    public static class EnumUtilFuncParam<R extends Enum<R>>
    extends AbstractUtilFuncParam<R> {
        private final Class<R> enumClass;

        public static <R extends Enum<R>> EnumUtilFuncParam<R> create(String name, R defaultValue) {
            return new EnumUtilFuncParam<R>(name, defaultValue, defaultValue.getDeclaringClass());
        }

        public EnumUtilFuncParam(String name, R defaultValue, Class<R> enumClass) {
            super(name, defaultValue);
            this.enumClass = enumClass;
        }

        @Override
        public String valueToString(R value, IPDHost host) {
            if (value == null) {
                throw new NullPointerException(this.getName());
            }
            return ((Enum)value).name();
        }

        @Override
        public R stringToValue(String value, IPDHost host) {
            Objects.requireNonNull(value, "Must provide a non-null value");
            return Enum.valueOf(this.enumClass, value);
        }
    }

    public static interface IUtilFuncParam<R> {
        public String getName();

        public R getDefaultValue();

        public String valueToString(R var1, IPDHost var2);

        public R stringToValue(String var1, IPDHost var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface IsUtilFuncParam {
    }

    public static class StringUtilFuncParam
    extends AbstractUtilFuncParam<String> {
        private final StringUtilFuncParamType type;

        public static StringUtilFuncParam bracketed(String name) {
            return new StringUtilFuncParam(name, StringUtilFuncParamType.BRACKETED);
        }

        public static StringUtilFuncParam resourceEscaped(String name) {
            return new StringUtilFuncParam(name, StringUtilFuncParamType.RESOURCE_ESCAPED);
        }

        public static StringUtilFuncParam hexEscaped(String name) {
            return new StringUtilFuncParam(name, StringUtilFuncParamType.HEX_ESCAPED);
        }

        public static StringUtilFuncParam singleQuoted(String name) {
            return new StringUtilFuncParam(name, StringUtilFuncParamType.SINGLE_QUOTED);
        }

        public StringUtilFuncParam(String name) {
            this(name, StringUtilFuncParamType.NORMAL);
        }

        public StringUtilFuncParam(String name, StringUtilFuncParamType type) {
            this(name, type, "");
        }

        public StringUtilFuncParam(String name, StringUtilFuncParamType type, String defaultValue) {
            super(name, defaultValue);
            this.type = type;
        }

        @Override
        public String valueToString(String value, IPDHost host) {
            Objects.requireNonNull(value, "Must provide a non-null value");
            switch (this.type) {
                case BRACKETED: {
                    if (value.isEmpty()) {
                        return "";
                    }
                    return "(" + value + ")";
                }
                case RESOURCE_ESCAPED: {
                    if (value.isEmpty()) {
                        return "";
                    }
                    return com.ibm.etools.fm.core.util.StringUtils.escapeResourceForHost(value);
                }
                case HEX_ESCAPED: {
                    String tmpValue = value;
                    if (host.getHostType().getCommunicationEncoding() != host.getCodePage()) {
                        try {
                            byte[] hexBytes = value.getBytes(host.getCodePage());
                            tmpValue = new String(hexBytes, host.getHostType().getCommunicationEncoding());
                        }
                        catch (UnsupportedEncodingException e) {
                            tmpValue = value;
                        }
                    }
                    String hex = StringUtils.convertToHex((String)tmpValue, (String)host.getHostType().getCommunicationEncoding());
                    return StringUtils.getFormattedInputWithHexEscaper((String)hex);
                }
                case SINGLE_QUOTED: {
                    if (value.isEmpty()) {
                        return "";
                    }
                    return "'" + value + "'";
                }
            }
            return value;
        }

        @Override
        public String stringToValue(String stringValue, IPDHost host) {
            Objects.requireNonNull(stringValue, "Must provide a non-null stringValue");
            switch (this.type) {
                case BRACKETED: {
                    if (stringValue.isEmpty()) {
                        return "";
                    }
                    return stringValue.substring(1, stringValue.length() - 1);
                }
                case RESOURCE_ESCAPED: {
                    if (stringValue.isEmpty()) {
                        return "";
                    }
                    return StringUtils.unescapeResourceForHost((String)stringValue);
                }
                case HEX_ESCAPED: {
                    stringValue = StringUtils.getFormattedInputWithoutHexEscaper((String)stringValue);
                    String parsed = StringUtils.parseHexString((String)stringValue, (String)host.getCodePage());
                    if (parsed == null) {
                        return "";
                    }
                    return parsed;
                }
                case SINGLE_QUOTED: {
                    if (stringValue.isEmpty()) {
                        return "";
                    }
                    return stringValue.substring(1, stringValue.length() - 1);
                }
            }
            return stringValue;
        }

        public static enum StringUtilFuncParamType {
            NORMAL,
            BRACKETED,
            RESOURCE_ESCAPED,
            HEX_ESCAPED,
            SINGLE_QUOTED;

        }
    }
}

