/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.data.MessageQueueProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MQQLParser
extends UtilityFunctionParser<List<MessageQueue>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_MQLIST = "MQQueueList";
    private static final String TAG_MQ = "MQQueueId";
    private static final String TAG_PROPERTY = "Property";
    private static final String ATT_MQM_NAME = "MqMgr";
    private static final String ATT_MQ_NAME = "Name";
    private static final String ATT_PROP_KEY = "Key";
    private static final String ATT_PROP_VALUE = "Value";
    private static final String ATT_PROP_VALUE_HEX = "ValueX";
    private List<MessageQueue> mqs = new ArrayList<MessageQueue>();
    private final HashMap<String, String> properties = new HashMap();
    private MessageQueueManager manager;
    private String currentMQName = null;
    private static final PDLogger logger = PDLogger.get(MQQLParser.class);
    private final IPDHost host;

    public MQQLParser(IPDHost host) {
        this.host = host;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (TAG_MQLIST.equals(qName)) {
            String name = attributes.getValue("", ATT_MQM_NAME);
            if (name != null && MessageQueueManager.isValidName(this.host, name)) {
                this.manager = MessageQueueManager.create(this.host, name);
            } else {
                logger.debug(new Object[]{"Invalid message queue manager name ", name});
            }
        } else if (TAG_MQ.equals(qName)) {
            this.properties.clear();
            String name = attributes.getValue("", ATT_MQ_NAME);
            this.currentMQName = null;
            if (name != null && MessageQueue.isValidName(name, this.host.getCodePage()) && this.manager != null) {
                this.currentMQName = name;
            } else if (this.manager == null) {
                logger.debug(new Object[]{"MQ found outside MQM: ", name});
            } else {
                logger.debug(new Object[]{"Invalid queue name encountered ", name});
            }
        } else if (TAG_PROPERTY.equals(qName)) {
            String key = attributes.getValue("", ATT_PROP_KEY);
            String value = attributes.getValue("", ATT_PROP_VALUE);
            String valuex = attributes.getValue("", ATT_PROP_VALUE_HEX);
            if (valuex != null && value == null) {
                value = StringUtils.parseHexString((String)valuex, (String)this.host.getCodePage());
            }
            if (value == null) {
                value = "";
            }
            if (this.currentMQName != null) {
                this.properties.put(key, value);
            } else {
                logger.debug(new Object[]{"Property found outside message queue: ", key});
            }
        } else {
            logger.debug(new Object[]{"Unknown element encountered: ", qName});
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_MQ.equals(qName) && this.currentMQName != null && this.manager != null) {
            MessageQueueProperties mqProps = new MessageQueueProperties(this.properties);
            MessageQueue mq = MessageQueue.create(this.manager, this.currentMQName);
            mq.setProperties(mqProps);
            mq.setConfirmedExists(true);
            this.mqs.add(mq);
            this.currentMQName = null;
        }
    }

    public Result<List<MessageQueue>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.mqs);
        return result;
    }
}

