/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.data.MessageQueueManagerProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MQLParser
extends UtilityFunctionParser<List<MessageQueueManager>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_MQM_LIST = "MQManagerList";
    private static final String TAG_MQM = "MQManagerId";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_PROPERTY = "Property";
    private static final String ATT_MQM_NAME = "name";
    private static final String ATT_MQM_TEXT = "text";
    private static final String ATT_MQM_CONN_CODE = "conncode";
    private static final String ATT_MQM_CONN_REASON = "connreason";
    private static final String ATT_PROP_KEY = "Key";
    private static final String ATT_PROP_VALUE = "Value";
    private static final String ATT_PROP_VALUE_HEX = "ValueX";
    private static final Pattern pattern = Pattern.compile("([0-9]+)");
    private static final PDLogger logger = PDLogger.get(MQLParser.class);
    private final IPDHost host;
    private List<MessageQueueManager> mqManagers = new ArrayList<MessageQueueManager>();
    private MessageQueueManager currentMQM;
    private HashMap<String, String> properties = new HashMap();

    public MQLParser(IPDHost host) {
        this.host = host;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block16: {
            String message;
            Matcher matcher;
            super.startElement(uri, localName, qName, attributes);
            if (TAG_MESSAGE.contentEquals(qName) && this.currentMQM != null && (matcher = pattern.matcher(message = attributes.getValue("", ATT_MQM_TEXT))).find() && matcher.group().contentEquals("302")) {
                int cc = -1;
                int rc = -1;
                while (matcher.find()) {
                    cc = rc;
                    rc = Integer.parseInt(matcher.group());
                }
                if (cc != -1 && rc != -1) {
                    this.currentMQM.setConnectionCode(cc);
                    this.currentMQM.setConnectionReason(String.valueOf(rc));
                }
            }
            if (this.startElementedAlreadyHandled()) {
                return;
            }
            if (TAG_MQM.equals(qName)) {
                this.properties.clear();
                this.currentMQM = null;
                String name = attributes.getValue("", ATT_MQM_NAME);
                String connCode = attributes.getValue("", ATT_MQM_CONN_CODE);
                String connReason = attributes.getValue("", ATT_MQM_CONN_REASON);
                try {
                    int parsedConnCode = Integer.parseInt(connCode);
                    if (MessageQueueManager.isValidName(this.host, name)) {
                        this.currentMQM = MessageQueueManager.create(name, parsedConnCode, connReason, this.host);
                        break block16;
                    }
                    logger.debug(new Object[]{"Invalid message queue manager name encountered: ", name});
                }
                catch (NumberFormatException e) {
                    logger.debug(new Object[]{"Non-integer message queue manager connection code encountered: ", connCode});
                }
            } else if (TAG_PROPERTY.equals(qName)) {
                String key = attributes.getValue("", ATT_PROP_KEY);
                String value = attributes.getValue("", ATT_PROP_VALUE);
                String valuex = attributes.getValue("", ATT_PROP_VALUE_HEX);
                if (valuex != null && value == null) {
                    value = StringUtils.parseHexString((String)valuex, (String)this.host.getCodePage());
                }
                if (value == null) {
                    value = "";
                }
                if (this.currentMQM != null) {
                    this.properties.put(key, value);
                } else {
                    logger.debug(new Object[]{"Property found outside message queue manager: ", key});
                }
            } else if (!TAG_MQM_LIST.equals(qName)) {
                logger.debug(new Object[]{"Unknown tag encountered: ", qName});
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentMQM != null && TAG_MQM.equals(qName)) {
            this.currentMQM.setProperties(new MessageQueueManagerProperties(this.properties));
            this.currentMQM.setConfirmedExists(true);
            this.mqManagers.add(this.currentMQM);
            this.currentMQM = null;
        }
        super.endElement(uri, localName, qName);
    }

    public Result<List<MessageQueueManager>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.mqManagers);
        return result;
    }
}

