/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsBmpRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsDliRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfigDialogModel;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.jhost.core.util.XmlTag;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class I1SLParser
extends UtilityFunctionParser<List<ImsSubsystemConfig>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TAG_IMSSSID = "IMSssid";
    public static final String TAG_SSID = "ssid";
    private static final String TAG_DLIUPD = "dliupd";
    private static final String TAG_DLI = "dli";
    private static final String TAG_DFSVSAMP = "dfsvsamp";
    private static final String TAG_RESLIB = "reslib";
    private static final String TAG_IMSMAC = "imsmac";
    private static final String TAG_RECON = "recon";
    private static final String TAG_ACBLIB = "acblib";
    private static final String TAG_IMSLOGDSN = "logdsn";
    private static final String TAG_BMPUPD = "bmpupd";
    private static final String TAG_BMP = "bmp";
    private static final String TAG_PSBLIB = "psblib";
    private static final String TAG_DBDLIB = "dbdlib";
    private static final String TAG_TPLLIB = "tpllib";
    private static final String TAG_LOG = "log";
    private static final String TAG_XKEY = "xkey";
    private static final String TAG_LKEY = "lkey";
    private static final String TAG_RKEY = "rkey";
    public static final String ATT_SSID_NAME = "name";
    private static final String ATT_SSID_STATUS = "status";
    private static final String ATT_SSID_BMP_READ = "BMPread";
    private static final String ATT_SSID_DLI_READ = "DLIread";
    private static final String ATT_SSID_BMP_PSB_TYPE = "BMP_PSBtype";
    private static final String ATT_SSID_DLI_PSB_TYPE = "DLI_PSBtype";
    private static final String ATT_SSID_REG_TYPES = "REGtypes";
    private static final String ATT_SSID_AGN = "AGN";
    private static final String ATT_SSID_DYNALLOC = "DYNALLOC";
    private static final String ATT_SSID_IEFRDER = "iefrder";
    private static final String ATT_SSID_TIMEOUT = "timeout";
    private static final String ATT_SSID_CHKPMMSS = "chkpmmss";
    private static final String ATT_SSID_DESC = "desc";
    private static final String ATT_SSID_DIR = "dir";
    public static final String ATT_DLI_DYNB = "dynb";
    public static final String ATT_DLI_DBRC = "dbrc";
    public static final String ATT_DLI_IRLM = "irlm";
    public static final String ATT_DLI_IMSLOGUSAGE = "logusage";
    public static final String ATT_DLI_IRLM_NAME = "irlmname";
    public static final String ATT_DLI_GSG_NAME = "gsgname";
    public static final String ATT_DLI_TMI_NAME = "tminame";
    public static final String ATT_DLI_BUF = "buf";
    public static final String ATT_DLI_DYN_DD = "dyndd";
    public static final String ATT_SHARED_LOCK_MAX = "lockmax";
    public static final String ATT_SHARED_AUTO_SAVE = "autosave";
    public static final String ATT_SHARED_EDITF = "editf";
    public static final String ATT_SHARED_CRALL = "crall";
    public static final String ATT_SHARED_LOAD = "load";
    public static final String ATT_SHARED_BEDITF = "beditf";
    public static final String ATT_SHARED_PSB_BR = "PSBbr";
    public static final String ATT_SHARED_PSB_EX = "PSBex";
    public static final String ATT_SHARED_PSB_PR = "PSBpr";
    public static final String ATT_SHARED_PSB_BB = "PSBbb";
    private static final String ATT_DFSVSAMP_UPD = "upd";
    private static final String ATT_DFSVSAMP_DSN = "dsn";
    private static final String ATT_DFSVSAMP_MBR = "mbr";
    private static final String ATT_RESLIB_UPD = "upd";
    private static final String ATT_RESLIB_DSN = "dsn";
    private static final String ATT_RECON_UPD = "upd";
    private static final String ATT_RECON_PRIM = "prim";
    private static final String ATT_RECON_SEC = "sec";
    private static final String ATT_RECON_SPARE = "spare";
    private static final String ATT_ACBLIB_UPD = "upd";
    private static final String ATT_ACBLIB_DSN = "dsn";
    private static final String ATT_IMSMAC_UPD = "upd";
    private static final String ATT_IMSMAC_DSN = "dsn";
    private static final String ATT_IMSLOGDSN_UPD = "upd";
    private static final String ATT_IMSLOGDSN_VAL = "val";
    public static final String ATT_BMP_PARDLI = "pardli";
    public static final String ATT_BMP_NBA = "nba";
    public static final String ATT_BMP_OBA = "oba";
    private static final String ATT_PSBLIB_UPD = "upd";
    private static final String ATT_PSBLIB_DSN = "dsn";
    private static final String ATT_DBDLIB_UPD = "upd";
    private static final String ATT_DBDLIB_DSN = "dsn";
    private static final String ATT_TPLLIB_UPD = "upd";
    private static final String ATT_TPLLIB_DSN = "dsn";
    private static final String ATT_LOG_UNIT = "unit";
    private static final String ATT_LOG_PRIM = "prim";
    private static final String ATT_LOG_SEC = "sec";
    private static final String ATT_LOG_MCLASS = "mclass";
    private static final String ATT_LOG_SCLASS = "sclass";
    private static final String ATT_LOG_DCLASS = "dclass";
    private static final String ATT_LOG_DEVT = "devt";
    private static final String ATT_XKEY_UNIT = "unit";
    private static final String ATT_XKEY_PRIM = "prim";
    private static final String ATT_XKEY_SEC = "sec";
    private static final String ATT_XKEY_MCLASS = "mclass";
    private static final String ATT_XKEY_SCLASS = "sclass";
    private static final String ATT_XKEY_DCLASS = "dclass";
    private static final String ATT_XKEY_DEVT = "devt";
    private static final String ATT_LKEY_UNIT = "unit";
    private static final String ATT_LKEY_PRIM = "prim";
    private static final String ATT_LKEY_SEC = "sec";
    private static final String ATT_LKEY_MCLASS = "mclass";
    private static final String ATT_LKEY_SCLASS = "sclass";
    private static final String ATT_LKEY_DCLASS = "dclass";
    private static final String ATT_LKEY_VOL1 = "vol1";
    private static final String ATT_LKEY_VOL2 = "vol2";
    private static final String ATT_LKEY_VOL3 = "vol3";
    private static final String ATT_RKEY_UNIT = "unit";
    private static final String ATT_RKEY_PRIM = "prim";
    private static final String ATT_RKEY_SEC = "sec";
    private static final String ATT_RKEY_MCLASS = "mclass";
    private static final String ATT_RKEY_SCLASS = "sclass";
    private static final String ATT_RKEY_DCLASS = "dclass";
    private static final String ATT_RKEY_VOL1 = "vol1";
    private static final String ATT_RKEY_VOL2 = "vol2";
    private static final String ATT_RKEY_VOL3 = "vol3";
    private static final String NO_UPDATE_VALUE = "N";
    private static final PDLogger logger = PDLogger.get(I1SLParser.class);
    private final IPDHost host;
    private final List<ImsSubsystemConfig> subsystems = new ArrayList<ImsSubsystemConfig>();
    private Map<String, String> ssidAttribs = new HashMap<String, String>();
    private Map<String, String> dliUpdAttribs = new HashMap<String, String>();
    private Map<String, String> dliAttribs = new HashMap<String, String>();
    private Map<String, String> bmpUpdAttribs = new HashMap<String, String>();
    private Map<String, String> bmpAttribs = new HashMap<String, String>();
    private Member dfsvsamp = null;
    private boolean dfsvsampUpdateable = false;
    private List<DataSet> resLibs = new ArrayList<DataSet>();
    private boolean resLibsUpdateable = false;
    private DataSet imsMacroLib = null;
    private boolean imsMacroLibUpdateable = false;
    private DataSet reconPrimary;
    private DataSet reconSecondary;
    private DataSet reconSpare;
    private boolean reconUpdate = false;
    private DataSet acbLib = null;
    private boolean acbLibUpdateable = false;
    private String imsLogDsn = new String();
    private boolean imsLogDsnUpdateable = false;
    private List<DataSet> psbLibs = new ArrayList<DataSet>();
    private boolean psbLibsUpdateable = false;
    private List<DataSet> dbdLibs = new ArrayList<DataSet>();
    private boolean dbdLibsUpdateable = false;
    private List<DataSet> templateLibs = new ArrayList<DataSet>();
    private boolean templateLibsUpdateable = false;
    private ImsSubsystemConfig.TempDataSetAllocParamsDevType logAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsDevType();
    private ImsSubsystemConfig.TempDataSetAllocParamsDevType xkeyAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsDevType();
    private ImsSubsystemConfig.TempDataSetAllocParamsVolumes lkeyAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsVolumes();
    private ImsSubsystemConfig.TempDataSetAllocParamsVolumes rkeyAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsVolumes();

    public I1SLParser(IPDHost host) {
        this.host = host;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_IMSSSID.equals(qName)) {
            if (TAG_SSID.equals(qName)) {
                this.ssidAttribs = I1SLParser.buildAttributesMap((Attributes)attributes);
            } else if (TAG_DLIUPD.equals(qName)) {
                this.dliUpdAttribs = I1SLParser.buildAttributesMap((Attributes)attributes);
            } else if (TAG_DLI.equals(qName)) {
                this.dliAttribs = I1SLParser.buildAttributesMap((Attributes)attributes);
            } else if (TAG_DFSVSAMP.equals(qName)) {
                Member member;
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String mbr = I1SLParser.getValueTrimmed(attributes, ATT_DFSVSAMP_MBR);
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                        mbr = new String(mbr.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                this.dfsvsamp = member = Member.create(DataSet.create(this.host, dsn), mbr);
                this.dfsvsampUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_RESLIB.equals(qName)) {
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                DataSet dataSet = DataSet.create(this.host, dsn);
                this.resLibs.add(dataSet);
                this.resLibsUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_IMSMAC.equals(qName)) {
                DataSet dataSet;
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                this.imsMacroLib = dataSet = DataSet.create(this.host, dsn);
                this.imsMacroLibUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_RECON.equals(qName)) {
                String spare;
                String secondary;
                String primary = attributes.getValue("prim");
                if (primary != null) {
                    primary = primary.trim();
                }
                if ((secondary = attributes.getValue("sec")) != null) {
                    secondary = secondary.trim();
                }
                if ((spare = attributes.getValue(ATT_RECON_SPARE)) != null) {
                    spare = spare.trim();
                }
                String upd = attributes.getValue("upd");
                if (primary != null && primary.length() > 0) {
                    this.reconPrimary = DataSet.create(this.host, primary);
                }
                if (secondary != null && secondary.length() > 0) {
                    this.reconSecondary = DataSet.create(this.host, secondary);
                }
                if (spare != null && spare.length() > 0) {
                    this.reconSpare = DataSet.create(this.host, spare);
                }
                this.reconUpdate = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_ACBLIB.equals(qName)) {
                DataSet dataSet;
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                this.acbLib = dataSet = DataSet.create(this.host, dsn);
                this.acbLibUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_IMSLOGDSN.equals(qName)) {
                String val = I1SLParser.getValueTrimmed(attributes, ATT_IMSLOGDSN_VAL);
                if (val != null) {
                    this.imsLogDsn = new String(val);
                }
                String ulogdsn = attributes.getValue("upd");
                this.imsLogDsnUpdateable = I1SLParser.isUpdateAllowed(ulogdsn);
            } else if (TAG_BMPUPD.equals(qName)) {
                this.bmpUpdAttribs = I1SLParser.buildAttributesMap((Attributes)attributes);
            } else if (TAG_BMP.equals(qName)) {
                this.bmpAttribs = I1SLParser.buildAttributesMap((Attributes)attributes);
            } else if (TAG_PSBLIB.equals(qName)) {
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                DataSet dataSet = DataSet.create(this.host, dsn);
                this.psbLibs.add(dataSet);
                this.psbLibsUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_DBDLIB.equals(qName)) {
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                DataSet dataSet = DataSet.create(this.host, dsn);
                this.dbdLibs.add(dataSet);
                this.dbdLibsUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_TPLLIB.equals(qName)) {
                String dsn = I1SLParser.getValueTrimmed(attributes, "dsn");
                String upd = attributes.getValue("upd");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        dsn = new String(dsn.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                DataSet dataSet = DataSet.create(this.host, dsn);
                this.templateLibs.add(dataSet);
                this.templateLibsUpdateable = I1SLParser.isUpdateAllowed(upd);
            } else if (TAG_LOG.equals(qName)) {
                String unit = I1SLParser.getValueTrimmed(attributes, "unit");
                String primarySpace = I1SLParser.getValueTrimmed(attributes, "prim");
                String secondarySpace = I1SLParser.getValueTrimmed(attributes, "sec");
                String masterClass = I1SLParser.getValueTrimmed(attributes, "mclass");
                String storageClass = I1SLParser.getValueTrimmed(attributes, "sclass");
                String deviceClass = I1SLParser.getValueTrimmed(attributes, "dclass");
                String deviceType = I1SLParser.getValueTrimmed(attributes, "devt");
                this.logAllocParams.setUnit(unit);
                this.logAllocParams.setPrimarySpace(primarySpace);
                this.logAllocParams.setSecondarySpace(secondarySpace);
                this.logAllocParams.setMasterClass(masterClass);
                this.logAllocParams.setStorageClass(storageClass);
                this.logAllocParams.setDeviceClass(deviceClass);
                this.logAllocParams.setDeviceType(deviceType);
            } else if (TAG_XKEY.equals(qName)) {
                String unit = I1SLParser.getValueTrimmed(attributes, "unit");
                String primarySpace = I1SLParser.getValueTrimmed(attributes, "prim");
                String secondarySpace = I1SLParser.getValueTrimmed(attributes, "sec");
                String masterClass = I1SLParser.getValueTrimmed(attributes, "mclass");
                String storageClass = I1SLParser.getValueTrimmed(attributes, "sclass");
                String deviceClass = I1SLParser.getValueTrimmed(attributes, "dclass");
                String deviceType = I1SLParser.getValueTrimmed(attributes, "devt");
                this.xkeyAllocParams.setUnit(unit);
                this.xkeyAllocParams.setPrimarySpace(primarySpace);
                this.xkeyAllocParams.setSecondarySpace(secondarySpace);
                this.xkeyAllocParams.setMasterClass(masterClass);
                this.xkeyAllocParams.setStorageClass(storageClass);
                this.xkeyAllocParams.setDeviceClass(deviceClass);
                this.xkeyAllocParams.setDeviceType(deviceType);
            } else if (TAG_LKEY.equals(qName)) {
                String unit = I1SLParser.getValueTrimmed(attributes, "unit");
                String primarySpace = I1SLParser.getValueTrimmed(attributes, "prim");
                String secondarySpace = I1SLParser.getValueTrimmed(attributes, "sec");
                String masterClass = I1SLParser.getValueTrimmed(attributes, "mclass");
                String storageClass = I1SLParser.getValueTrimmed(attributes, "sclass");
                String deviceClass = I1SLParser.getValueTrimmed(attributes, "dclass");
                String vol1 = I1SLParser.getValueTrimmed(attributes, "vol1");
                String vol2 = I1SLParser.getValueTrimmed(attributes, "vol2");
                String vol3 = I1SLParser.getValueTrimmed(attributes, "vol3");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        vol1 = new String(vol1.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                        vol2 = new String(vol2.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                        vol3 = new String(vol3.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                this.lkeyAllocParams.setUnit(unit);
                this.lkeyAllocParams.setPrimarySpace(primarySpace);
                this.lkeyAllocParams.setSecondarySpace(secondarySpace);
                this.lkeyAllocParams.setMasterClass(masterClass);
                this.lkeyAllocParams.setStorageClass(storageClass);
                this.lkeyAllocParams.setDeviceClass(deviceClass);
                this.lkeyAllocParams.setVolume1(vol1);
                this.lkeyAllocParams.setVolume2(vol2);
                this.lkeyAllocParams.setVolume3(vol3);
            } else if (TAG_RKEY.equals(qName)) {
                String unit = I1SLParser.getValueTrimmed(attributes, "unit");
                String primarySpace = I1SLParser.getValueTrimmed(attributes, "prim");
                String secondarySpace = I1SLParser.getValueTrimmed(attributes, "sec");
                String masterClass = I1SLParser.getValueTrimmed(attributes, "mclass");
                String storageClass = I1SLParser.getValueTrimmed(attributes, "sclass");
                String deviceClass = I1SLParser.getValueTrimmed(attributes, "dclass");
                String vol1 = I1SLParser.getValueTrimmed(attributes, "vol1");
                String vol2 = I1SLParser.getValueTrimmed(attributes, "vol2");
                String vol3 = I1SLParser.getValueTrimmed(attributes, "vol3");
                if (this.host.getCodePage() != this.host.getCommunicationCodePage()) {
                    try {
                        vol1 = new String(vol1.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                        vol2 = new String(vol2.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                        vol3 = new String(vol3.getBytes(this.host.getCommunicationCodePage()), this.host.getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                this.rkeyAllocParams.setUnit(unit);
                this.rkeyAllocParams.setPrimarySpace(primarySpace);
                this.rkeyAllocParams.setSecondarySpace(secondarySpace);
                this.rkeyAllocParams.setMasterClass(masterClass);
                this.rkeyAllocParams.setStorageClass(storageClass);
                this.rkeyAllocParams.setDeviceClass(deviceClass);
                this.rkeyAllocParams.setVolume1(vol1);
                this.rkeyAllocParams.setVolume2(vol2);
                this.rkeyAllocParams.setVolume3(vol3);
            } else {
                logger.warn((Object)("Unknown tag encountered " + qName));
            }
        }
    }

    private static boolean isUpdateAllowed(String updValue) {
        return updValue == null || !updValue.equals(NO_UPDATE_VALUE);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_SSID.equals(qName)) {
            String name = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_NAME));
            String status = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_STATUS));
            String bmpRead = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_BMP_READ));
            String dliRead = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_DLI_READ));
            String bmpPsbType = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_BMP_PSB_TYPE));
            String dliPsbType = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_DLI_PSB_TYPE));
            String regTypes = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_REG_TYPES));
            String agn = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_AGN));
            String dynalloc = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_DYNALLOC));
            String iefrder = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_IEFRDER));
            String timeout = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_TIMEOUT));
            String chkpmmss = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_CHKPMMSS));
            String desc = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_DESC));
            String dir = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get(ATT_SSID_DIR));
            String ver = I1SLParser.emptyOrTrimmed(this.ssidAttribs.get("ver"));
            ImsSubsystem subsystem = new ImsSubsystem(this.host, name);
            ImsSubsystemConfig config = new ImsSubsystemConfig(subsystem);
            config.setAgnsUsed("Y".equals(agn));
            config.setDynalloc("Y".equals(dynalloc));
            config.setIefrder("Y".equals(iefrder));
            config.setTimeout(timeout);
            config.setChkpmmss(chkpmmss);
            config.setDescription(desc);
            config.setDir("1".equals(dir) || "Y".equals(dir));
            config.setOnline("1".equals(status));
            config.setPsbLibs(this.psbLibs);
            config.setPsbLibsUpdateable(this.psbLibsUpdateable);
            config.setDbdLibs(this.dbdLibs);
            config.setDbdLibsUpdateable(this.dbdLibsUpdateable);
            config.setTemplateLibs(this.templateLibs);
            config.setTemplateLibsUpdateable(this.templateLibsUpdateable);
            config.setDliSupported("D".equals(regTypes) || "A".equals(regTypes));
            config.setBmpSupported("B".equals(regTypes) || "A".equals(regTypes));
            config.setLogAllocationParameters(this.logAllocParams);
            config.setXKeysAllocationParameters(this.xkeyAllocParams);
            config.setLogicalKeysAllocationParameters(this.lkeyAllocParams);
            config.setRootKeysAllocationParameters(this.rkeyAllocParams);
            ImsDliRegionConfig dliConfig = new ImsDliRegionConfig(config);
            dliConfig.setDynamicAccessSupported("D".equals(dliPsbType) || "B".equals(dliPsbType));
            dliConfig.setStaticAccessSupported("S".equals(dliPsbType) || "B".equals(dliPsbType));
            dliConfig.setReadOnly("Y".equals(dliRead));
            dliConfig.setDfsvsamp(this.dfsvsamp);
            dliConfig.setDfsvsampUpdateable(this.dfsvsampUpdateable);
            dliConfig.setResLibs(this.resLibs);
            dliConfig.setResLibsUpdateable(this.resLibsUpdateable);
            dliConfig.setImsMacroLib(this.imsMacroLib);
            dliConfig.setImsMacroLibUpdateable(this.imsMacroLibUpdateable);
            dliConfig.setReconPrimary(this.reconPrimary);
            dliConfig.setReconSecondary(this.reconSecondary);
            dliConfig.setReconSpare(this.reconSpare);
            dliConfig.setReconUpdateable(this.reconUpdate);
            dliConfig.setAcbLib(this.acbLib);
            dliConfig.setAcbLibUpdateable(this.acbLibUpdateable);
            dliConfig.setImsLogLib(this.imsLogDsn);
            dliConfig.setImsLogLibUpdateable(this.imsLogDsnUpdateable);
            for (Map.Entry<String, String> entry : this.dliAttribs.entrySet()) {
                entry.setValue(entry.getValue().trim());
            }
            dliConfig.setSettingValues(this.dliAttribs);
            HashSet<String> dliReadOnlySettings = new HashSet<String>(this.dliUpdAttribs.keySet());
            if (dliReadOnlySettings.contains(ATT_SHARED_AUTO_SAVE)) {
                dliReadOnlySettings.add(ATT_SHARED_EDITF);
                dliReadOnlySettings.add(ATT_SHARED_CRALL);
            }
            dliConfig.setReadOnlySettings(dliReadOnlySettings);
            String updValueTmp = this.dliUpdAttribs.get(ATT_DLI_IMSLOGUSAGE);
            dliConfig.setImsLogUsageUpdateable(I1SLParser.isUpdateAllowed(updValueTmp));
            config.setDliConfig(dliConfig);
            ImsBmpRegionConfig bmpConfig = new ImsBmpRegionConfig(config);
            bmpConfig.setReadOnly("Y".equals(bmpRead));
            bmpConfig.setDynamicAccessSupported("D".equals(bmpPsbType) || "B".equals(bmpPsbType));
            bmpConfig.setStaticAccessSupported("S".equals(bmpPsbType) || "B".equals(bmpPsbType));
            for (Map.Entry<String, String> entry : this.bmpAttribs.entrySet()) {
                entry.setValue(entry.getValue().trim());
            }
            bmpConfig.setSettingValues(this.bmpAttribs);
            HashSet<String> bmpReadOnlySettings = new HashSet<String>(this.bmpUpdAttribs.keySet());
            if (bmpReadOnlySettings.contains(ATT_SHARED_AUTO_SAVE)) {
                bmpReadOnlySettings.add(ATT_SHARED_EDITF);
                bmpReadOnlySettings.add(ATT_SHARED_CRALL);
            }
            bmpConfig.setReadOnlySettings(bmpReadOnlySettings);
            config.setBmpConfig(bmpConfig);
            this.subsystems.add(config);
            this.ssidAttribs.clear();
            this.dliUpdAttribs.clear();
            this.dliAttribs.clear();
            this.bmpUpdAttribs.clear();
            this.bmpAttribs.clear();
            this.dfsvsamp = null;
            this.dfsvsampUpdateable = false;
            this.resLibs.clear();
            this.imsMacroLib = null;
            this.imsMacroLibUpdateable = false;
            this.reconPrimary = null;
            this.reconSecondary = null;
            this.reconSpare = null;
            this.reconUpdate = true;
            this.acbLib = null;
            this.acbLibUpdateable = false;
            this.imsLogDsn = new String();
            this.imsLogDsnUpdateable = false;
            this.psbLibs.clear();
            this.dbdLibs.clear();
            this.templateLibs.clear();
            this.logAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsDevType();
            this.xkeyAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsDevType();
            this.lkeyAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsVolumes();
            this.rkeyAllocParams = new ImsSubsystemConfig.TempDataSetAllocParamsVolumes();
        }
        super.endElement(uri, localName, qName);
    }

    public static String emptyOrTrimmed(String str) {
        return str == null ? "" : str.trim();
    }

    public Result<List<ImsSubsystemConfig>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.subsystems);
        return result;
    }

    public static String toHostFormat(ImsSubsystemConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Must specify a non-null ImsSubsystemConfig parameter.");
        }
        XmlTag imsSsid = new XmlTag(TAG_IMSSSID);
        XmlTag config_xml = I1SLParser.toXmlTag(config);
        HashSet keys = new HashSet(config_xml.getAttributes().keySet());
        HashSet<String> dli_noupd_tags = new HashSet<String>(Arrays.asList(TAG_DFSVSAMP, TAG_RESLIB, TAG_IMSMAC, TAG_RECON, TAG_ACBLIB, TAG_IMSLOGDSN));
        HashSet<String> noupd_tags = new HashSet<String>(Arrays.asList(TAG_PSBLIB, TAG_DBDLIB, TAG_TPLLIB));
        for (XmlTag child : config_xml.getChildren()) {
            String tag = child.getTagName();
            if (!noupd_tags.contains(tag)) continue;
            child.setAttribute("upd", null);
        }
        XmlTag new_config_xml = new XmlTag(config_xml.getTagName());
        new_config_xml.setAttribute(ATT_SSID_NAME, (String)config_xml.getAttributes().get(ATT_SSID_NAME));
        for (XmlTag child : config_xml.getChildren()) {
            if (child.getTagName().equals(TAG_DLIUPD) || child.getTagName().equals(TAG_BMPUPD)) continue;
            new_config_xml.addChild(child);
        }
        imsSsid.addChild(new_config_xml);
        return imsSsid.serialize();
    }

    public static String toHostFormat(ImsSubsystemConfigDialogModel config) {
        if (config == null) {
            throw new IllegalArgumentException("Must specify a non-null ImsSubsystemConfig parameter.");
        }
        XmlTag imsSsid = new XmlTag(TAG_IMSSSID);
        imsSsid.addChild(I1SLParser.toXmlTag(config));
        return imsSsid.serialize();
    }

    public static XmlTag toXmlTag_ssid(IPDHost pdHost, String subSystemID, boolean isOnline, boolean isBmpSupported, boolean isBmpReadOnly, boolean isBmpStaticAccessSupported, boolean isBmpDynamicAccessSupported, boolean isDliSupported, boolean isDliReadOnly, boolean isDliStaticAccessSupported, boolean isDliDynamicAccessSupported, boolean isAgnsUsed, boolean isDynalloc, String description, boolean isDir) {
        XmlTag ssid = new XmlTag(TAG_SSID);
        ssid.setAttribute(ATT_SSID_NAME, subSystemID);
        ssid.setAttribute(ATT_SSID_STATUS, isOnline ? "1" : "0");
        ssid.setAttribute(ATT_SSID_BMP_READ, isBmpReadOnly ? "Y" : NO_UPDATE_VALUE);
        ssid.setAttribute(ATT_SSID_DLI_READ, isDliReadOnly ? "Y" : NO_UPDATE_VALUE);
        if (isBmpDynamicAccessSupported && isBmpStaticAccessSupported) {
            ssid.setAttribute(ATT_SSID_BMP_PSB_TYPE, "B");
        } else if (isBmpDynamicAccessSupported) {
            ssid.setAttribute(ATT_SSID_BMP_PSB_TYPE, "D");
        } else if (isBmpStaticAccessSupported) {
            ssid.setAttribute(ATT_SSID_BMP_PSB_TYPE, "S");
        }
        if (isDliDynamicAccessSupported && isDliStaticAccessSupported) {
            ssid.setAttribute(ATT_SSID_DLI_PSB_TYPE, "B");
        } else if (isDliDynamicAccessSupported) {
            ssid.setAttribute(ATT_SSID_DLI_PSB_TYPE, "D");
        } else if (isDliStaticAccessSupported) {
            ssid.setAttribute(ATT_SSID_DLI_PSB_TYPE, "S");
        }
        if (isBmpSupported && isDliSupported) {
            ssid.setAttribute(ATT_SSID_REG_TYPES, "A");
        } else if (isBmpSupported) {
            ssid.setAttribute(ATT_SSID_REG_TYPES, "B");
        } else if (isDliSupported) {
            ssid.setAttribute(ATT_SSID_REG_TYPES, "D");
        }
        ssid.setAttribute(ATT_SSID_AGN, isAgnsUsed ? "Y" : NO_UPDATE_VALUE);
        ssid.setAttribute(ATT_SSID_DESC, description);
        ssid.setAttribute(ATT_SSID_DYNALLOC, isDynalloc ? "Y" : NO_UPDATE_VALUE);
        ssid.setAttribute(ATT_SSID_DIR, isDir ? "Y" : NO_UPDATE_VALUE);
        return ssid;
    }

    public static void toXmlTag_Dli_DFSVSAMP(XmlTag dli, String dfsvsampDsnName, String dfsvsampMemberName) {
        if (dli == null) {
            throw new IllegalArgumentException("Must provide a non-null dli XmlTag.");
        }
        if (dfsvsampDsnName != null) {
            XmlTag dsfvsamp = dli.createChild(TAG_DFSVSAMP);
            dsfvsamp.setAttribute("dsn", I1SLParser.padIfEmpty(dfsvsampDsnName.toUpperCase()));
            dsfvsamp.setAttribute(ATT_DFSVSAMP_MBR, I1SLParser.padIfEmpty(dfsvsampMemberName.toUpperCase()));
        }
    }

    public static void toXmlTag_Dli_ImsMacrolib(XmlTag dli, String imsMacroLibName) {
        if (dli == null) {
            throw new IllegalArgumentException("Must provide a non-null dli XmlTag.");
        }
        if (imsMacroLibName != null) {
            XmlTag imsmac = dli.createChild(TAG_IMSMAC);
            imsmac.setAttribute("dsn", I1SLParser.padIfEmpty(imsMacroLibName.toUpperCase()));
        }
    }

    public static void toXmlTag_Dli_Recon(XmlTag dli, String reconPrimaryName, String reconSecondaryName, String reconSpareName) {
        if (dli == null) {
            throw new IllegalArgumentException("Must provide a non-null dli XmlTag.");
        }
        XmlTag recon = dli.createChild(TAG_RECON);
        if (reconPrimaryName != null) {
            recon.setAttribute("prim", reconPrimaryName.toUpperCase());
        }
        if (reconSecondaryName != null) {
            recon.setAttribute("sec", reconSecondaryName.toUpperCase());
        }
        if (reconSpareName != null) {
            recon.setAttribute(ATT_RECON_SPARE, reconSpareName.toUpperCase());
        }
    }

    public static void toXmlTag_Dli_Acblib(XmlTag dli, String acbLibName) {
        if (dli == null) {
            throw new IllegalArgumentException("Must provide a non-null dli XmlTag.");
        }
        if (acbLibName != null) {
            XmlTag acblib = dli.createChild(TAG_ACBLIB);
            acblib.setAttribute("dsn", I1SLParser.padIfEmpty(acbLibName.toUpperCase()));
        }
    }

    public static void toXmlTag_Dli_LogDsn(XmlTag dli, String logDsnName, boolean isLogDsnUpdateable) {
        if (dli == null) {
            throw new IllegalArgumentException("Must provide a non-null dli XmlTag.");
        }
        if (isLogDsnUpdateable) {
            XmlTag logdsn = dli.createChild(TAG_IMSLOGDSN);
            logdsn.setAttribute(ATT_IMSLOGDSN_VAL, I1SLParser.padIfEmpty(logDsnName.toUpperCase()));
        }
    }

    public static void toXmlTag_Dli_ResLibs(XmlTag dli, List<?> resLibs) {
        if (dli == null) {
            throw new IllegalArgumentException("Must provide a non-null dli XmlTag.");
        }
        for (Object reslibrary : resLibs) {
            String libName;
            XmlTag reslib = dli.createChild(TAG_RESLIB);
            String string = libName = reslibrary instanceof DataSet ? ((DataSet)reslibrary).getName() : (String)reslibrary;
            if (libName == null || libName.length() <= 0) continue;
            reslib.setAttribute("dsn", I1SLParser.padIfEmpty(libName.toUpperCase()));
        }
    }

    public static void toXmlTag_Dli(XmlTag ssid, ImsDliRegionConfig dliConf, String dbrcStr, String dfsvsampDsnName, String dfsvsampMemberName, String imsMacroLibName, String reconPrimaryName, String reconSecondaryName, String reconSpareName, String acbLibName, List<?> resLibs, boolean isImsLogUsageUpdateable, String imsLogUsage, boolean supportsImsLogInSubSystem, String logDsnName) {
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        XmlTag dli = ssid.createChild(TAG_DLI);
        for (Map.Entry<String, String> setting : dliConf.getSettingValues().entrySet()) {
            if (dliConf.getReadOnlySettings().contains(setting.getKey())) continue;
            dli.setAttribute(setting.getKey(), I1SLParser.padIfEmpty(setting.getValue()));
        }
        dli.setAttribute(ATT_DLI_DBRC, dbrcStr);
        if (supportsImsLogInSubSystem && isImsLogUsageUpdateable) {
            dli.setAttribute(ATT_DLI_IMSLOGUSAGE, imsLogUsage);
        }
        I1SLParser.toXmlTag_Dli_DFSVSAMP(dli, dfsvsampDsnName, dfsvsampMemberName);
        I1SLParser.toXmlTag_Dli_ImsMacrolib(dli, imsMacroLibName);
        I1SLParser.toXmlTag_Dli_Recon(dli, reconPrimaryName, reconSecondaryName, reconSpareName);
        I1SLParser.toXmlTag_Dli_Acblib(dli, acbLibName);
        I1SLParser.toXmlTag_Dli_ResLibs(dli, resLibs);
        if (supportsImsLogInSubSystem) {
            I1SLParser.toXmlTag_Dli_LogDsn(dli, logDsnName, dliConf.isImsLogLibUpdateable());
        }
    }

    public static void toXmlTag_Bmp(XmlTag ssid, ImsBmpRegionConfig bmpConf) {
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        if (bmpConf == null) {
            throw new IllegalArgumentException("Must provide a non-null bmpConf.");
        }
        XmlTag bmpupd = ssid.createChild(TAG_BMPUPD);
        for (String setting : bmpConf.getReadOnlySettings()) {
            bmpupd.setAttribute(setting, NO_UPDATE_VALUE);
        }
        XmlTag bmp = ssid.createChild(TAG_BMP);
        for (Map.Entry<String, String> setting : bmpConf.getSettingValues().entrySet()) {
            bmp.setAttribute(setting.getKey(), I1SLParser.padIfEmpty(setting.getValue()));
        }
    }

    public static void toXmlTag_PsbLibs(XmlTag ssid, List<DataSet> psbLibs) {
        if (psbLibs == null) {
            throw new IllegalArgumentException("Must provide a non-null psbLibs.");
        }
        for (DataSet psbLibrary : psbLibs) {
            XmlTag psblib = ssid.createChild(TAG_PSBLIB);
            psblib.setAttribute("dsn", psbLibrary.getName().toUpperCase());
        }
    }

    public static void toXmlTag_PsbLibList(XmlTag ssid, List<String> psbLibs) {
        if (psbLibs != null) {
            for (String psbLibrary : psbLibs) {
                if (psbLibrary.isEmpty()) continue;
                XmlTag psblib = ssid.createChild(TAG_PSBLIB);
                psblib.setAttribute("dsn", psbLibrary.toUpperCase());
            }
        }
    }

    public static void toXmlTag_DbdLibs(XmlTag ssid, List<DataSet> dbdLibs) {
        if (dbdLibs == null) {
            throw new IllegalArgumentException("Must provide a non-null dbdLibs.");
        }
        for (DataSet dbdLibrary : dbdLibs) {
            XmlTag dbdlib = ssid.createChild(TAG_DBDLIB);
            dbdlib.setAttribute("dsn", dbdLibrary.getName().toUpperCase());
        }
    }

    public static void toXmlTag_DbdLibsList(XmlTag ssid, List<String> dbdLibs) {
        if (dbdLibs != null) {
            for (String dbdLibrary : dbdLibs) {
                if (dbdLibrary.isEmpty()) continue;
                XmlTag dbdlib = ssid.createChild(TAG_DBDLIB);
                dbdlib.setAttribute("dsn", dbdLibrary.toUpperCase());
            }
        }
    }

    public static void toXmlTag_TemplateLibs(XmlTag ssid, List<DataSet> templateLibs) {
        if (templateLibs == null) {
            throw new IllegalArgumentException("Must provide a non-null templateLibs.");
        }
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        for (DataSet templateLibrary : templateLibs) {
            XmlTag tpllib = ssid.createChild(TAG_TPLLIB);
            tpllib.setAttribute("dsn", templateLibrary.getName().toUpperCase());
        }
    }

    public static void toXmlTag_Log(XmlTag ssid, ImsSubsystemConfig.TempDataSetAllocParamsDevType logAllocParams) {
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        if (logAllocParams == null) {
            throw new IllegalArgumentException("Must provide a non-null logAllocParams.");
        }
        XmlTag log = ssid.createChild(TAG_LOG);
        log.setAttribute("unit", I1SLParser.padIfEmpty(logAllocParams.getUnit()));
        log.setAttribute("prim", I1SLParser.padIfEmpty(logAllocParams.getPrimarySpace()));
        log.setAttribute("sec", I1SLParser.padIfEmpty(logAllocParams.getSecondarySpace()));
        log.setAttribute("mclass", I1SLParser.padIfEmpty(logAllocParams.getMasterClass()));
        log.setAttribute("sclass", I1SLParser.padIfEmpty(logAllocParams.getStorageClass()));
        log.setAttribute("dclass", I1SLParser.padIfEmpty(logAllocParams.getDeviceClass()));
        log.setAttribute("devt", I1SLParser.padIfEmpty(logAllocParams.getDeviceType()));
    }

    public static void toXmlTag_xKey(XmlTag ssid, ImsSubsystemConfig.TempDataSetAllocParamsDevType xKeysAllocParams) {
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        if (xKeysAllocParams == null) {
            throw new IllegalArgumentException("Must provide a non-null xKeysAllocParams.");
        }
        XmlTag xkey = ssid.createChild(TAG_XKEY);
        xkey.setAttribute("unit", I1SLParser.padIfEmpty(xKeysAllocParams.getUnit()));
        xkey.setAttribute("prim", I1SLParser.padIfEmpty(xKeysAllocParams.getPrimarySpace()));
        xkey.setAttribute("sec", I1SLParser.padIfEmpty(xKeysAllocParams.getSecondarySpace()));
        xkey.setAttribute("mclass", I1SLParser.padIfEmpty(xKeysAllocParams.getMasterClass()));
        xkey.setAttribute("sclass", I1SLParser.padIfEmpty(xKeysAllocParams.getStorageClass()));
        xkey.setAttribute("dclass", I1SLParser.padIfEmpty(xKeysAllocParams.getDeviceClass()));
        xkey.setAttribute("devt", I1SLParser.padIfEmpty(xKeysAllocParams.getDeviceType()));
    }

    public static void toXmlTag_lKey(XmlTag ssid, ImsSubsystemConfig.TempDataSetAllocParamsVolumes logicalKeysAllocParams) {
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        XmlTag lkey = ssid.createChild(TAG_LKEY);
        lkey.setAttribute("unit", I1SLParser.padIfEmpty(logicalKeysAllocParams.getUnit()));
        lkey.setAttribute("prim", I1SLParser.padIfEmpty(logicalKeysAllocParams.getPrimarySpace()));
        lkey.setAttribute("sec", I1SLParser.padIfEmpty(logicalKeysAllocParams.getSecondarySpace()));
        lkey.setAttribute("mclass", I1SLParser.padIfEmpty(logicalKeysAllocParams.getMasterClass()));
        lkey.setAttribute("sclass", I1SLParser.padIfEmpty(logicalKeysAllocParams.getStorageClass()));
        lkey.setAttribute("dclass", I1SLParser.padIfEmpty(logicalKeysAllocParams.getDeviceClass()));
        lkey.setAttribute("vol1", I1SLParser.padIfEmpty(logicalKeysAllocParams.getVolume1()));
        lkey.setAttribute("vol2", I1SLParser.padIfEmpty(logicalKeysAllocParams.getVolume2()));
        lkey.setAttribute("vol3", I1SLParser.padIfEmpty(logicalKeysAllocParams.getVolume3()));
    }

    public static void toXmlTag_rKey(XmlTag ssid, ImsSubsystemConfig.TempDataSetAllocParamsVolumes rootKeysAllocParams) {
        if (ssid == null) {
            throw new IllegalArgumentException("Must provide a non-null ssid.");
        }
        XmlTag rkey = ssid.createChild(TAG_RKEY);
        rkey.setAttribute("unit", I1SLParser.padIfEmpty(rootKeysAllocParams.getUnit()));
        rkey.setAttribute("prim", I1SLParser.padIfEmpty(rootKeysAllocParams.getPrimarySpace()));
        rkey.setAttribute("sec", I1SLParser.padIfEmpty(rootKeysAllocParams.getSecondarySpace()));
        rkey.setAttribute("mclass", I1SLParser.padIfEmpty(rootKeysAllocParams.getMasterClass()));
        rkey.setAttribute("sclass", I1SLParser.padIfEmpty(rootKeysAllocParams.getStorageClass()));
        rkey.setAttribute("dclass", I1SLParser.padIfEmpty(rootKeysAllocParams.getDeviceClass()));
        rkey.setAttribute("vol1", I1SLParser.padIfEmpty(rootKeysAllocParams.getVolume1()));
        rkey.setAttribute("vol2", I1SLParser.padIfEmpty(rootKeysAllocParams.getVolume2()));
        rkey.setAttribute("vol3", I1SLParser.padIfEmpty(rootKeysAllocParams.getVolume3()));
    }

    public static XmlTag toXmlTag(ImsSubsystemConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Must provide a non-null config.");
        }
        XmlTag ssid = I1SLParser.toXmlTag_ssid(config.getSystem(), config.getSubsystem().getSubsystemID(), config.isOnline(), config.isBmpSupported(), config.getBmpConfig().isReadOnly(), config.getBmpConfig().isStaticAccessSupported(), config.getBmpConfig().isDynamicAccessSupported(), config.isDliSupported(), config.getDliConfig().isReadOnly(), config.getDliConfig().isStaticAccessSupported(), config.getDliConfig().isDynamicAccessSupported(), config.isAgnsUsed(), config.isDynalloc(), config.getDescription(), config.isDir());
        if (config.isDliSupported()) {
            ImsDliRegionConfig dliConfig = config.getDliConfig();
            I1SLParser.toXmlTag_Dli(ssid, dliConfig, ImsDliRegionConfig.getDbrcStr(dliConfig.isUsingDatabaseRecoveryControl()), dliConfig.getDfsvsamp() != null ? dliConfig.getDfsvsamp().asDataSet().getName() : null, dliConfig.getDfsvsamp() != null ? dliConfig.getDfsvsamp().asMember().getName() : null, dliConfig.getImsMacroLib() != null ? dliConfig.getImsMacroLib().getName() : null, dliConfig.getReconPrimary() != null ? dliConfig.getReconPrimary().getName() : null, dliConfig.getReconSecondary() != null ? dliConfig.getReconSecondary().getName() : null, dliConfig.getReconSpare() != null ? dliConfig.getReconSpare().getName() : null, dliConfig.getAcbLib() != null ? dliConfig.getAcbLib().getName() : null, dliConfig.getResLibs(), dliConfig.isImsLogUsageUpdateable(), dliConfig.getImsLogUsageValue(), true, dliConfig.getImsLogLib());
        } else if (config.isBmpSupported()) {
            I1SLParser.toXmlTag_Bmp(ssid, config.getBmpConfig());
        }
        I1SLParser.toXmlTag_PsbLibs(ssid, config.getPsbLibs());
        I1SLParser.toXmlTag_DbdLibs(ssid, config.getDbdLibs());
        I1SLParser.toXmlTag_TemplateLibs(ssid, config.getTemplateLibs());
        I1SLParser.toXmlTag_Log(ssid, config.getLogAllocationParameters());
        I1SLParser.toXmlTag_xKey(ssid, config.getXKeysAllocationParameters());
        I1SLParser.toXmlTag_lKey(ssid, config.getLogicalKeysAllocationParameters());
        I1SLParser.toXmlTag_rKey(ssid, config.getRootKeysAllocationParameters());
        return ssid;
    }

    public static XmlTag toXmlTag(ImsSubsystemConfigDialogModel configDialogModel) {
        if (configDialogModel == null) {
            throw new IllegalArgumentException("Must provide a non-null configDialogModel.");
        }
        ImsSubsystemConfig originalConfig = configDialogModel.getOriginalConfig();
        ImsBmpRegionConfig originalBmpConfig = originalConfig.getBmpConfig();
        ImsDliRegionConfig originalDliConfig = originalConfig.getDliConfig();
        XmlTag ssid = I1SLParser.toXmlTag_ssid(originalConfig.getSystem(), originalConfig.getSubsystem().getSubsystemID(), originalConfig.isOnline(), originalConfig.isBmpSupported(), originalBmpConfig.isReadOnly(), originalBmpConfig.isStaticAccessSupported(), originalBmpConfig.isDynamicAccessSupported(), originalConfig.isDliSupported(), originalDliConfig.isReadOnly(), originalDliConfig.isStaticAccessSupported(), originalDliConfig.isDynamicAccessSupported(), originalConfig.isAgnsUsed(), originalConfig.isDynalloc(), configDialogModel.getDescription(), originalConfig.isDir());
        if (originalConfig.isDliSupported()) {
            String dfsvsampDsn = null;
            String dfsvsampMember = null;
            String dfsvsamp = configDialogModel.getDfsvsamp();
            if (!dfsvsamp.isEmpty()) {
                int tempInd = dfsvsamp.indexOf(40);
                if (tempInd > 0) {
                    dfsvsampDsn = dfsvsamp.substring(0, tempInd);
                    dfsvsampMember = dfsvsamp.substring(tempInd + 1, dfsvsamp.length() - 1);
                } else {
                    dfsvsampDsn = dfsvsamp;
                }
            }
            I1SLParser.toXmlTag_Dli(ssid, originalDliConfig, ImsDliRegionConfig.getDbrcStr(configDialogModel.getDbrc()), dfsvsampDsn, dfsvsampMember, !configDialogModel.getImsMacroLib().isEmpty() ? configDialogModel.getImsMacroLib() : null, !configDialogModel.getReconPrimary().isEmpty() ? configDialogModel.getReconPrimary() : null, !configDialogModel.getReconSecondary().isEmpty() ? configDialogModel.getReconSecondary() : null, !configDialogModel.getReconSpare().isEmpty() ? configDialogModel.getReconSpare() : null, !configDialogModel.getAcbLib().isEmpty() ? configDialogModel.getAcbLib() : null, configDialogModel.getReslibs(), originalDliConfig.isImsLogUsageUpdateable(), ImsDliRegionConfig.getImsLogUsageStr(configDialogModel.getImsLogUsage()), true, configDialogModel.getImsLogLib());
        } else if (originalConfig.isBmpSupported()) {
            I1SLParser.toXmlTag_Bmp(ssid, originalBmpConfig);
        }
        I1SLParser.toXmlTag_PsbLibList(ssid, !configDialogModel.getPsbLibs().isEmpty() ? configDialogModel.getPsbLibs() : null);
        I1SLParser.toXmlTag_DbdLibsList(ssid, !configDialogModel.getDbdLibs().isEmpty() ? configDialogModel.getDbdLibs() : null);
        List<DataSet> templateLibs = ImsSubsystemConfigDialogModel.fromStringsToDataSets(configDialogModel.getSystem(), configDialogModel.getTemplateLibs());
        I1SLParser.toXmlTag_TemplateLibs(ssid, templateLibs);
        I1SLParser.toXmlTag_Log(ssid, originalConfig.getLogAllocationParameters());
        I1SLParser.toXmlTag_xKey(ssid, originalConfig.getXKeysAllocationParameters());
        I1SLParser.toXmlTag_lKey(ssid, originalConfig.getLogicalKeysAllocationParameters());
        I1SLParser.toXmlTag_rKey(ssid, originalConfig.getRootKeysAllocationParameters());
        return ssid;
    }

    private static String padIfEmpty(String str) {
        return str != null && str.isEmpty() ? " " : str;
    }

    private static String getValueTrimmed(Attributes attributes, String key) {
        String value = attributes.getValue(key);
        if (value != null) {
            return value.trim();
        }
        return null;
    }
}

