/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DSFMParser
extends UtilityFunctionParser<List<Member>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_MEMLIST = "memlist";
    private static final String TAG_MEMBER = "member";
    private static final String ATT_MEMBER_NAME = "name";
    private static final String ATT_MEMBER_LIB = "lib";
    private static final String ATT_MEMBER_TYPE = "type";
    private static final String ATT_MEMBER_XML = "xml";
    private static final String ATT_MEMBER_DESC = "desc";
    private static final String ATT_MEMBER_OWNER = "owner";
    private static final String ATT_MEMBER_OBJECT = "object";
    private static final String ATT_MEMBER_SSID = "ssid";
    private static final String ATT_MEMBER_LOCK = "lock";
    private static final String ATT_MEMBER_LZERO = "lzero";
    private static final PDLogger logger = PDLogger.get(DSFMParser.class);
    private IPDHost pdHost;
    private final List<DataSet> providedDataSets;
    private final List<Member> loadedMembers = new ArrayList<Member>();

    public DSFMParser(IPDHost host, List<String> dsns) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (String dsn : dsns) {
            dataSets.add(DataSet.create(host, dsn));
        }
        this.providedDataSets = Collections.unmodifiableList(dataSets);
        this.pdHost = host;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (TAG_MEMBER.equals(qName)) {
            String xmlStr;
            String name = attributes.getValue("", ATT_MEMBER_NAME);
            String intStr = attributes.getValue("", ATT_MEMBER_LIB);
            DataSet ds = intStr != null ? this.providedDataSets.get(Integer.parseInt(intStr) - 1) : DataSet.create(this.pdHost, "dir");
            Member mem = Member.createNonStandard(ds, name);
            Member.TemplateInfo.DsfmTemplateType type = null;
            String strType = attributes.getValue("", ATT_MEMBER_TYPE);
            if (strType != null) {
                try {
                    type = Member.TemplateInfo.DsfmTemplateType.valueOf(strType);
                }
                catch (IllegalArgumentException e) {
                    logger.warn((Object)("Unknown template type encountered: [" + strType + "]"));
                }
            }
            boolean xml = (xmlStr = attributes.getValue("", ATT_MEMBER_XML)) != null && Integer.parseInt(xmlStr) == 1;
            String desc = attributes.getValue("", ATT_MEMBER_DESC);
            String owner = attributes.getValue("", ATT_MEMBER_OWNER);
            String object = attributes.getValue("", ATT_MEMBER_OBJECT);
            String ssid = attributes.getValue("", ATT_MEMBER_SSID);
            String lzero = attributes.getValue("", ATT_MEMBER_LZERO);
            String lock = attributes.getValue("", ATT_MEMBER_LOCK);
            boolean locked = false;
            boolean leadingZero = false;
            if (lock != null && lock.equals("1")) {
                locked = true;
            }
            if (lzero != null && lzero.equals("1")) {
                leadingZero = true;
            }
            Member.TemplateInfo templateInfo = new Member.TemplateInfo(type, xml, desc, owner, object, ssid, locked, leadingZero);
            mem.setTemplateInfo(templateInfo);
            this.loadedMembers.add(mem);
        } else if (!TAG_MEMLIST.equals(qName)) {
            logger.debug(new Object[]{"Unknown tag encountered: ", qName});
        }
    }

    public Result<List<Member>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.loadedMembers);
        return result;
    }
}

