/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DSFM
extends UtilityFunction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ALL_MEMBERS = "*";
    private IPDHost host;

    public DSFM(IPDHost host) {
        super("DSFM");
        this.host = host;
    }

    public boolean isExpectingXmlOutput() {
        return true;
    }

    public void setDsnList(List<String> dsnList) {
        Objects.requireNonNull(dsnList, "Must provide a non-null dsnList");
        if (dsnList.isEmpty() || dsnList.size() > 12) {
            throw new IllegalArgumentException(Integer.toString(dsnList.size()));
        }
        StringBuilder value = new StringBuilder();
        for (String dsn : dsnList) {
            if (value.length() > 0) {
                value.append(",");
            }
            if (!DataSet.isValidName(dsn, this.host.getCodePage())) {
                throw new IllegalArgumentException("dsn='" + (dsn == null ? "null" : dsn) + "'");
            }
            value.append(dsn);
        }
        this.setParameterValue("DSNLIST", "(" + value.toString() + ")");
    }

    public void setMember(String member) {
        this.setParameterValue("MEMBER", member);
    }

    public void setTypes(List<Member.TemplateInfo.DsfmTemplateType> includedTypes) {
        StringBuilder value = new StringBuilder();
        if (includedTypes.isEmpty() || includedTypes.containsAll(Arrays.asList(Member.TemplateInfo.DsfmTemplateType.values()))) {
            value.append("ALL");
        } else {
            for (Member.TemplateInfo.DsfmTemplateType type : includedTypes) {
                if (value.length() > 0) {
                    value.append(",");
                }
                value.append((Object)type);
            }
        }
        this.setParameterValue("TYPE", "(" + value.toString() + ")");
    }

    public void setXMLVER() {
        this.setParameterValue("XMLVER", "1");
    }
}

