/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.core.model.data.MemberProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DSFLParser
extends UtilityFunctionParser<List<DataSet>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_DATA_SET_LIST = "Dslist";
    private static final String TAG_DATA_SET = "Dsn";
    private static final String TAG_CLUSTER = "Cluster";
    private static final String TAG_DATA = "Data";
    private static final String TAG_INDEX = "Index";
    private static final String TAG_VOLUME = "Volser";
    private static final String TAG_MEMBER = "Mem";
    private static final String TAG_PROPERTY = "Property";
    private static final String ATT_DATA_SET_NAME = "Name";
    private static final String ATT_DATA_SET_TYPE = "Type";
    private static final String ATT_VOL_VALUE = "Value";
    private static final String ATT_MEMBER_NAME = "Name";
    private static final String ATT_MEMBER_NAME_HEX = "NameX";
    private static final String ATT_PROP_KEY = "Key";
    private static final String ATT_PROP_VALUE = "Value";
    private static final String ATT_PROP_VALUE_HEX = "ValueX";
    private static final String IGNORED_PROPERTY_TRACK_PREFIX = "Track extent ";
    private static final String IGNORED_PROPERTY_VOLSER = "Volser";
    private static final String IGNORED_PROPERTY_VOLUME_SEQ = "Volume sequence";
    private static final String IGNORED_PROPERTY_TYPE = "Type";
    private static final PDLogger logger = PDLogger.get(DSFLParser.class);
    private List<DataSet> allParsedDataSets = new ArrayList<DataSet>();
    private List<String> associatedDataSetNames = new ArrayList<String>();
    private List<Volume> baseDataSetVolumes = new ArrayList<Volume>();
    private HashMap<String, String> dataSetProperties = new HashMap();
    private List<Volume> vsamDataVolumes = new ArrayList<Volume>();
    private HashMap<String, String> vsamDataProperties = new HashMap();
    private List<Volume> vsamIndexVolumes = new ArrayList<Volume>();
    private HashMap<String, String> vsamIndexProperties = new HashMap();
    private List<Volume> currentVolumes = null;
    private HashMap<String, String> currentProperties = null;
    private boolean inCluster = false;
    private DataSet baseDataSet = null;
    private String baseDataSetName = null;
    private String baseDataSetType = null;
    private List<String> baseDataSetMemberNames = new ArrayList<String>();
    private List<MemberProperties> baseDataSetMemberProps = new ArrayList<MemberProperties>();
    private final IPDHost host;
    private final boolean membersCanBePresent;

    public DSFLParser(IPDHost host, boolean membersLoaded) {
        this.host = host;
        this.membersCanBePresent = membersLoaded;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_DATA_SET_LIST.equals(qName)) {
            if (TAG_DATA_SET.equals(qName)) {
                this.associatedDataSetNames.clear();
                this.baseDataSetVolumes.clear();
                this.dataSetProperties.clear();
                this.vsamDataVolumes.clear();
                this.vsamDataProperties.clear();
                this.vsamIndexVolumes.clear();
                this.vsamIndexProperties.clear();
                this.currentVolumes = this.baseDataSetVolumes;
                this.currentProperties = this.dataSetProperties;
                this.baseDataSetMemberNames.clear();
                this.baseDataSetMemberProps.clear();
                this.baseDataSet = null;
                this.baseDataSetName = null;
                this.baseDataSetType = null;
                this.inCluster = false;
                String dsn = attributes.getValue("", "Name");
                String type = attributes.getValue("", "Type");
                if (dsn != null) {
                    this.baseDataSetName = dsn;
                }
                if (type != null) {
                    this.baseDataSetType = type;
                }
            } else if (TAG_CLUSTER.equals(qName)) {
                this.currentProperties = this.dataSetProperties;
                this.currentVolumes = this.baseDataSetVolumes;
                this.inCluster = true;
            } else if (TAG_DATA.equals(qName)) {
                this.currentProperties = this.vsamDataProperties;
                this.currentVolumes = this.vsamDataVolumes;
                this.inCluster = false;
            } else if (TAG_INDEX.equals(qName)) {
                this.currentProperties = this.vsamIndexProperties;
                this.currentVolumes = this.vsamIndexVolumes;
                this.inCluster = false;
            } else if ("Volser".equals(qName)) {
                String name = attributes.getValue("", "Value");
                if (Volume.isValid(name, this.host.getCodePage())) {
                    this.baseDataSetVolumes.add(Volume.create(this.host, name));
                }
            } else if (TAG_PROPERTY.equals(qName)) {
                String key = attributes.getValue("", ATT_PROP_KEY);
                String value = attributes.getValue("", "Value");
                String valuex = attributes.getValue("", ATT_PROP_VALUE_HEX);
                if (valuex != null && value == null) {
                    value = StringUtils.parseHexString((String)valuex, (String)this.host.getCodePage());
                }
                if (value == null) {
                    value = "";
                }
                value = value.trim();
                if (key.equals("Type") && value != null && !DataSetType.DATA.toString().equals(value) && !DataSetType.INDEX.toString().equals(value)) {
                    this.baseDataSetType = value;
                }
                if (key.equals("Name")) {
                    if (this.inCluster) {
                        this.baseDataSetName = value;
                    } else {
                        this.associatedDataSetNames.add(value);
                    }
                }
                if (key.equals("Volser")) {
                    boolean found = false;
                    for (Volume volume : this.currentVolumes) {
                        if (!volume.getVolserID().equals(value)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (Volume.isValid(value, this.host.getCodePage())) {
                            this.currentVolumes.add(Volume.create(this.host, value));
                        } else {
                            logger.debug(new Object[]{this.baseDataSetName, " has invalid volume property ", value});
                        }
                    }
                }
                if (key.equals("Primary space amount")) {
                    key = "Primary space";
                } else if (key.equals("Secondary space amount")) {
                    key = "Secondary space";
                } else if (key.equals("Space allocation type")) {
                    key = "Space type";
                }
                if (!(key.startsWith(IGNORED_PROPERTY_TRACK_PREFIX) || key.equals("Volser") || key.equals(IGNORED_PROPERTY_VOLUME_SEQ) || key.equals("Type"))) {
                    if (this.currentProperties != null) {
                        this.currentProperties.put(key, value);
                    } else {
                        logger.debug(new Object[]{"Property found outside data set: ", key});
                    }
                }
            } else if (TAG_MEMBER.equals(qName)) {
                String name = attributes.getValue("", "Name");
                String namex = attributes.getValue("", ATT_MEMBER_NAME_HEX);
                if (this.baseDataSetName == null) {
                    logger.warn(new Object[]{"Ignoring member without parent data set: ", name});
                    return;
                }
                if (name == null && namex != null) {
                    name = StringUtils.parseHexString((String)namex, (String)this.host.getCodePage());
                }
                if (name == null) {
                    name = "";
                }
                this.baseDataSetMemberNames.add(name);
                this.baseDataSetMemberProps.add(this.parseMemberProperties(attributes));
            } else {
                logger.debug(new Object[]{"Unknown element encountered: ", qName});
            }
        }
    }

    private MemberProperties parseMemberProperties(Attributes attributes) {
        HashMap<String, String> memProps = new HashMap<String, String>();
        String value = attributes.getValue("AliasX");
        if (value != null) {
            memProps.put("AliasX", StringUtils.parseHexString((String)value, (String)this.host.getCodePage()));
        }
        DSFLParser.parseAttrProperty(memProps, attributes, "Size");
        DSFLParser.parseAttrProperty(memProps, attributes, "Created");
        DSFLParser.parseAttrProperty(memProps, attributes, "Changedate");
        DSFLParser.parseAttrProperty(memProps, attributes, "Changetime");
        DSFLParser.parseAttrProperty(memProps, attributes, "ID");
        DSFLParser.parseAttrProperty(memProps, attributes, "Init");
        DSFLParser.parseAttrProperty(memProps, attributes, "Mod");
        DSFLParser.parseAttrProperty(memProps, attributes, "VVMM");
        DSFLParser.parseAttrProperty(memProps, attributes, "AC");
        DSFLParser.parseAttrProperty(memProps, attributes, "AM");
        DSFLParser.parseAttrProperty(memProps, attributes, "RM");
        DSFLParser.parseAttrProperty(memProps, attributes, "Attributes");
        DSFLParser.parseAttrProperty(memProps, attributes, "TTR");
        DSFLParser.parseAttrProperty(memProps, attributes, "EPA");
        DSFLParser.parseAttrProperty(memProps, attributes, "SSI");
        return new MemberProperties(memProps);
    }

    private static void parseAttrProperty(HashMap<String, String> props, Attributes attributes, String key) {
        String value = attributes.getValue(key);
        if (value != null) {
            props.put(key, value);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_DATA_SET.equals(qName)) {
            ArrayList<DataSet> dataSetAssociations = new ArrayList<DataSet>();
            if (this.baseDataSetName != null && DataSet.isValidName(this.baseDataSetName, this.host.getCodePage())) {
                this.baseDataSet = DataSet.create(this.host, this.baseDataSetName);
                try {
                    this.baseDataSet.setType(DataSetType.valueOf(this.baseDataSetType.toUpperCase()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Invalid data set type " + this.baseDataSetType), (Throwable)e);
                    this.baseDataSet.setType(DataSetType.UNKNOWN);
                }
                this.allParsedDataSets.add(this.baseDataSet);
                ArrayList<Member> actualMembers = new ArrayList<Member>();
                int i = 0;
                while (i < this.baseDataSetMemberNames.size()) {
                    Member mem = Member.createNonStandard(this.baseDataSet, this.baseDataSetMemberNames.get(i));
                    mem.setProperties(this.baseDataSetMemberProps.get(i));
                    mem.setConfirmedExists(true);
                    actualMembers.add(mem);
                    ++i;
                }
                this.baseDataSet.setMembers(this.membersCanBePresent ? actualMembers : null);
                this.baseDataSet.setConfirmedExists(true);
                this.baseDataSet.setProperties(new DataSetProperties(this.dataSetProperties));
                this.baseDataSet.setVolumes(this.baseDataSetVolumes);
                this.associatedDataSetNames.remove(this.baseDataSet.getName());
                dataSetAssociations.add(this.baseDataSet);
            } else if (this.baseDataSetName != null) {
                logger.debug((Object)("Found data set with invalid name: " + this.baseDataSetName));
            }
            DataSet dataComponent = null;
            if (this.vsamDataProperties.size() > 0) {
                String name = this.vsamDataProperties.get("Name");
                this.associatedDataSetNames.remove(name);
                dataComponent = DataSet.create(this.host, name);
                dataComponent.setVolumes(this.vsamDataVolumes);
                dataComponent.setType(DataSetType.DATA);
                dataComponent.setProperties(new DataSetProperties(this.vsamDataProperties));
                dataSetAssociations.add(dataComponent);
                this.baseDataSet.setCrossRegion(this.vsamDataProperties.get("Shareoptions region"));
                this.baseDataSet.setCrossSystem(this.vsamDataProperties.get("Shareoptions system"));
                this.allParsedDataSets.add(dataComponent);
            }
            DataSet indexComponent = null;
            if (this.vsamIndexProperties.size() > 0) {
                String name = this.vsamIndexProperties.get("Name");
                this.associatedDataSetNames.remove(name);
                indexComponent = DataSet.create(this.host, name);
                indexComponent.setVolumes(this.vsamIndexVolumes);
                indexComponent.setType(DataSetType.INDEX);
                indexComponent.setProperties(new DataSetProperties(this.vsamIndexProperties));
                this.baseDataSet.setCrossRegion(this.vsamIndexProperties.get("Shareoptions region"));
                this.baseDataSet.setCrossSystem(this.vsamIndexProperties.get("Shareoptions system"));
                dataSetAssociations.add(indexComponent);
                this.allParsedDataSets.add(indexComponent);
            }
            block3: for (String associatedName : this.associatedDataSetNames) {
                if (DataSet.isValidName(associatedName, this.host.getCodePage())) {
                    for (DataSet parsedDataSet : this.allParsedDataSets) {
                        if (!parsedDataSet.getName().equals(associatedName)) continue;
                        dataSetAssociations.add(parsedDataSet);
                        continue block3;
                    }
                    dataSetAssociations.add(DataSet.create(this.host, associatedName));
                    continue;
                }
                logger.debug(new Object[]{this.baseDataSet.getName(), ": invalid associated data set name ", associatedName});
            }
            if (this.baseDataSet != null) {
                this.baseDataSet.setAssociatedDataSets(dataSetAssociations);
            }
            if (dataComponent != null) {
                dataComponent.setAssociatedDataSets(dataSetAssociations);
            }
            if (indexComponent != null) {
                indexComponent.setAssociatedDataSets(dataSetAssociations);
            }
            this.currentProperties = null;
        }
    }

    protected Result<List<DataSet>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.allParsedDataSets);
        return result;
    }
}

