/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import java.util.Objects;

public class DSAQ
extends NewUtilityFunction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam DSNOUT = NewUtilityFunction.StringUtilFuncParam.resourceEscaped("DSNOUT");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam LIKE = new NewUtilityFunction.StringUtilFuncParam("LIKE");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.EnumUtilFuncParam<SpaceUnit> SPACEU = NewUtilityFunction.EnumUtilFuncParam.create("SPACEU", SpaceUnit.BLK);
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam SPACEP = new NewUtilityFunction.StringUtilFuncParam("SPACEP");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam SPACES = new NewUtilityFunction.StringUtilFuncParam("SPACES");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam VOLUME = new NewUtilityFunction.StringUtilFuncParam("VOLUME");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam UNIT = new NewUtilityFunction.StringUtilFuncParam("UNIT");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam DATACLAS = new NewUtilityFunction.StringUtilFuncParam("DATACLAS");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam STORCLAS = new NewUtilityFunction.StringUtilFuncParam("STORCLAS");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam MGMTCLAS = new NewUtilityFunction.StringUtilFuncParam("MGMTCLAS");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam DIR = new NewUtilityFunction.StringUtilFuncParam("DIR");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.EnumUtilFuncParam<QsamRecordFormat> RECFMOUT = NewUtilityFunction.EnumUtilFuncParam.create("RECFMOUT", QsamRecordFormat.U);
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam DSNV = new NewUtilityFunction.StringUtilFuncParam("DSNV");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam NGEN = new NewUtilityFunction.StringUtilFuncParam("NGEN");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam DSKEYLBL = new NewUtilityFunction.StringUtilFuncParam("DSKEYLBL");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam RECSIZE = new NewUtilityFunction.StringUtilFuncParam("RECSIZE");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam BLKSIZE = new NewUtilityFunction.StringUtilFuncParam("BLKSIZE");
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.EnumUtilFuncParam<QsamSpaceType> DSNTYPE = NewUtilityFunction.EnumUtilFuncParam.create("DSNTYPE", QsamSpaceType.BASIC);
    @NewUtilityFunction.IsUtilFuncParam
    public static final NewUtilityFunction.StringUtilFuncParam EXPDT = new NewUtilityFunction.StringUtilFuncParam("EXPDT");

    public DSAQ() {
        super("DSAQ");
    }

    public static enum QsamRecordFormat {
        U,
        F,
        FB,
        FA,
        FM,
        FBA,
        FBM,
        V,
        VB,
        VS,
        VA,
        VM,
        VBS,
        VBA,
        VBM,
        VSA,
        VSM,
        VBSA,
        VBSM,
        D,
        DB,
        DS,
        DA,
        DBS,
        DBA,
        DSA,
        DBSA;


        public static QsamRecordFormat fromProperties(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return QsamRecordFormat.valueOf(value);
            }
            catch (Exception e) {
                return U;
            }
        }

        public boolean isUndefinedLength() {
            return this.name().contains("U");
        }

        public boolean isFixedLength() {
            return this.name().contains("F");
        }

        public boolean isVariableLength() {
            return this.name().contains("V") || this.name().contains("D");
        }

        public boolean isBlocked() {
            return this.name().contains("B");
        }
    }

    public static enum QsamSpaceType {
        BASIC,
        EXTR,
        EXTP,
        LARGE,
        LIBRARY,
        PDS;


        public static QsamSpaceType fromDataSetType(DataSetType type) {
            Objects.requireNonNull(type, "Must provide a non-null type.");
            switch (type) {
                case PS: 
                case DA: {
                    return BASIC;
                }
                case LIBRARY: {
                    return LIBRARY;
                }
                case PDS: {
                    return PDS;
                }
                case GDS: {
                    return BASIC;
                }
            }
            return null;
        }
    }

    public static enum SpaceUnit {
        BLK,
        TRK,
        CYL,
        KB,
        MB;


        public static SpaceUnit fromProperties(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return SpaceUnit.valueOf(value);
            }
            catch (Exception e) {
                if (value.equals("Block")) {
                    return BLK;
                }
                if (value.equals("Track")) {
                    return TRK;
                }
                if (value.equals("Cylinder")) {
                    return CYL;
                }
                if (value.equals("kb")) {
                    return KB;
                }
                if (value.equals("mb")) {
                    return MB;
                }
                return null;
            }
        }
    }
}

