/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.jhost.core.util.EnumUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class D2SLParser
extends UtilityFunctionParser<List<Db2Subsystem>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_DB2_SS_LIST = "db2ssid";
    private static final String TAG_DB2_SS = "ssid";
    private static final String ATT_DB2_SS_NAME = "name";
    private static final String ATT_DB2_SS_STATUS = "status";
    private static final String ATT_DB2_SS_SEL = "sel";
    private static final String ATT_DB2_SS_DESC = "desc";
    private static final String ATT_DB2_SS_PREFIX = "prefix";
    private List<Db2Subsystem> allSubsystems = new ArrayList<Db2Subsystem>();
    private Db2Subsystem lastSubsystem = null;
    private final IPDHost host;

    public D2SLParser(IPDHost host) {
        this.host = host;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_DB2_SS_LIST.equals(qName) && TAG_DB2_SS.equals(qName)) {
            String ssid = attributes.getValue("", ATT_DB2_SS_NAME);
            String status = attributes.getValue("", ATT_DB2_SS_STATUS);
            String sel = attributes.getValue("", ATT_DB2_SS_SEL);
            String desc = attributes.getValue("", ATT_DB2_SS_DESC);
            String prefix = attributes.getValue("", ATT_DB2_SS_PREFIX);
            this.lastSubsystem = new Db2Subsystem(this.host, ssid);
            this.lastSubsystem.setStatus((Db2Subsystem.STATUS)EnumUtils.lookup(Db2Subsystem.STATUS.class, (String)status));
            this.lastSubsystem.setCanConnect("1".equals(sel));
            this.lastSubsystem.setDescription(StringUtils.parseHexString((String)desc, (String)this.host.getCodePage()));
            this.lastSubsystem.setPrefix(StringUtils.parseHexString((String)prefix, (String)this.host.getCodePage()));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_DB2_SS.equals(qName) && this.lastSubsystem != null) {
            this.allSubsystems.add(this.lastSubsystem);
        }
    }

    protected Result<List<Db2Subsystem>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.allSubsystems);
        return result;
    }
}

