/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.data.CicsTemporaryStorageProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CTSLParser
extends UtilityFunctionParser<List<CicsTemporaryStorage>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CTSLParser.class);
    private static final String TAG_CICS_TS_LIST = "cicstsl";
    private static final String TAG_TSQ = "tsq";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TRAN = "tran";
    private static final String[] HEX_ATTRS = new String[]{"tran"};
    private List<CicsTemporaryStorage> allTSs = new ArrayList<CicsTemporaryStorage>();
    private CicsAppl cicsAppl = null;

    public CTSLParser(CicsAppl cicsAppl) {
        this.cicsAppl = cicsAppl;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_CICS_TS_LIST.equals(qName) && TAG_TSQ.equals(qName)) {
            String name = StringUtils.parseHexString((String)attributes.getValue(ATTR_NAME), (String)this.cicsAppl.getSystem().getCodePage());
            if (name != null && CicsTemporaryStorage.isValidName(this.cicsAppl.getSystem(), name)) {
                CicsTemporaryStorage aCicsTS = CicsTemporaryStorage.create(this.cicsAppl, name);
                aCicsTS.setConfirmedExists(true);
                HashMap<String, String> rawProperties = new HashMap<String, String>();
                int i = 0;
                while (i < attributes.getLength()) {
                    String key = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    if (ArrayUtils.findIndexOf((Object)key, (Object[])HEX_ATTRS, (int)-1) != -1) {
                        value = StringUtils.parseHexString((String)value, (String)this.cicsAppl.getSystem().getCodePage());
                    }
                    if (!ATTR_NAME.equals(key) && key != null && value != null) {
                        rawProperties.put(key, value);
                    }
                    ++i;
                }
                aCicsTS.setProperties((ImmutableProperties)new CicsTemporaryStorageProperties(rawProperties));
                this.allTSs.add(aCicsTS);
            } else {
                logger.debug((Object)("Invalid CICS TS name of " + name));
            }
        }
    }

    protected Result<List<CicsTemporaryStorage>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.allTSs);
        return result;
    }
}

