/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.model.data.CicsTransientDataProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CTDLParser
extends UtilityFunctionParser<List<CicsTransientData>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CTDLParser.class);
    private static final String TAG_CICS_TD_LIST = "cicstdl";
    private static final String TAG_INDIRECT_TD_QUEUE = "indq";
    private static final String TAG_EXTRAPARTITION_TD_QUEUE = "extq";
    private static final String TAG_INTRAPARTITION_TD_QUEUE = "intq";
    private static final String TAG_REMOTE_TD_QUEUE = "remq";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_INAME = "iname";
    private static final String ATTR_MEMBER = "member";
    private static final String ATTR_TRAN = "tran";
    private static final String ATTR_TERM = "term";
    private static final String ATTR_RNAME = "rname";
    private static final String[] HEX_ATTRS = new String[]{"iname", "member", "tran", "term", "rname"};
    private List<CicsTransientData> allTDs = new ArrayList<CicsTransientData>();
    private CicsAppl cicsAppl = null;

    public CTDLParser(CicsAppl cicsAppl) {
        this.cicsAppl = cicsAppl;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_CICS_TD_LIST.equals(qName) && (TAG_INDIRECT_TD_QUEUE.equals(qName) || TAG_EXTRAPARTITION_TD_QUEUE.equals(qName) || TAG_INTRAPARTITION_TD_QUEUE.equals(qName) || TAG_REMOTE_TD_QUEUE.equals(qName))) {
            String name = StringUtils.parseHexString((String)attributes.getValue(ATTR_NAME), (String)this.cicsAppl.getSystem().getCodePage());
            if (CicsTransientData.isValidName(this.cicsAppl.getSystem(), name)) {
                CicsTransientData aCicsTD = CicsTransientData.create(this.cicsAppl, name);
                aCicsTD.setConfirmedExists(true);
                HashMap<String, String> rawProperties = new HashMap<String, String>();
                int i = 0;
                while (i < attributes.getLength()) {
                    String key = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    if (ArrayUtils.findIndexOf((Object)key, (Object[])HEX_ATTRS, (int)-1) != -1) {
                        value = StringUtils.parseHexString((String)value, (String)this.cicsAppl.getSystem().getCodePage());
                    }
                    if (!ATTR_NAME.equals(key) && key != null && value != null) {
                        rawProperties.put(key, value);
                    }
                    ++i;
                }
                aCicsTD.setProperties((ImmutableProperties)new CicsTransientDataProperties(rawProperties));
                if (TAG_INDIRECT_TD_QUEUE.equals(qName)) {
                    aCicsTD.setTDType(CicsTransientData.TD_TYPE.INDIRECT_TD);
                } else if (TAG_EXTRAPARTITION_TD_QUEUE.equals(qName)) {
                    aCicsTD.setTDType(CicsTransientData.TD_TYPE.EXTRAPARTITION_TD);
                } else if (TAG_INTRAPARTITION_TD_QUEUE.equals(qName)) {
                    aCicsTD.setTDType(CicsTransientData.TD_TYPE.INTRAPARTITION_TD);
                } else if (TAG_REMOTE_TD_QUEUE.equals(qName)) {
                    aCicsTD.setTDType(CicsTransientData.TD_TYPE.REMOTE_TD);
                }
                this.allTDs.add(aCicsTD);
            } else {
                logger.error((Object)("Can't create a TD with name: " + name));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    protected Result<List<CicsTransientData>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.allTDs);
        return result;
    }
}

