/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.data.CicsFileProperties;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CFILParser
extends UtilityFunctionParser<List<CicsFile>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_CICS_FILE_LIST = "cicsfil";
    private static final String TAG_FILE = "file";
    private static final String ATTR_NAME = "name";
    private List<CicsFile> allFiles = new ArrayList<CicsFile>();
    private CicsAppl cicsAppl = null;

    public CFILParser(CicsAppl cicsAppl) {
        this.cicsAppl = cicsAppl;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_CICS_FILE_LIST.equals(qName) && TAG_FILE.equals(qName)) {
            String name = attributes.getValue(ATTR_NAME);
            CicsFile aCicsFile = CicsFile.create(this.cicsAppl, name);
            aCicsFile.setConfirmedExists(true);
            HashMap<String, String> rawProperties = new HashMap<String, String>();
            int i = 0;
            while (i < attributes.getLength()) {
                String key = attributes.getQName(i);
                String value = attributes.getValue(i);
                if (!ATTR_NAME.equals(key) && key != null && value != null) {
                    rawProperties.put(key, value);
                }
                ++i;
            }
            aCicsFile.setProperties((ImmutableProperties)CicsFileProperties.create(rawProperties));
            this.allFiles.add(aCicsFile);
        }
    }

    protected Result<List<CicsFile>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.allFiles);
        return result;
    }
}

