/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.socket.func;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CAPLParser
extends UtilityFunctionParser<List<CicsAppl>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TAG_CICS_APP_LIST = "cicsapl";
    private static final String TAG_APPL_ID = "applid";
    private static final String TAG_CONN = "conn";
    private static final String ATT_APPLID_NAME = "name";
    private static final String ATT_APPLID_DESC = "desc";
    private List<CicsAppl> allApps = new ArrayList<CicsAppl>();
    private CicsAppl lastCicsApp = null;
    private final IPDHost system;

    public CAPLParser(IPDHost system) {
        this.system = system;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.startElementedAlreadyHandled()) {
            return;
        }
        if (!TAG_CICS_APP_LIST.equals(qName)) {
            if (TAG_APPL_ID.equals(qName)) {
                String appID = attributes.getValue("", ATT_APPLID_NAME);
                String desc = attributes.getValue("", ATT_APPLID_DESC);
                this.lastCicsApp = CicsAppl.create(this.system, appID);
                this.lastCicsApp.setDescription(desc);
            } else {
                TAG_CONN.equals(qName);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_APPL_ID.equals(qName) && this.lastCicsApp != null) {
            this.allApps.add(this.lastCicsApp);
        }
    }

    protected void handleMessage(String number, String text) {
        if (this.lastCicsApp != null) {
            this.lastCicsApp.addMessage(text);
        } else {
            super.handleMessage(number, text);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.lastCicsApp != null) {
            if (s.equals("1")) {
                this.lastCicsApp.setCanConnect(true);
            } else {
                this.lastCicsApp.setCanConnect(false);
            }
        }
    }

    protected Result<List<CicsAppl>> getResult() {
        Result result = super.getResult();
        result.setOutput(this.allApps);
        return result;
    }
}

