/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.SessionTemplate;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsTemplateOptions;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.SSOP;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProviderName;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class SessionTemplate1
extends SessionTemplate {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SessionTemplate1.class);
    public static final String IMS_TEMPLATE_EXTENSION = ".fmt1";
    private ImsTemplateOptions imsTemplateOptions;
    private ImsDatabaseInfo imsDatabaseInfo;

    public SessionTemplate1(ImsTemplateOptions imsTemplateOptions) {
        super(imsTemplateOptions.getTemplate());
        this.imsTemplateOptions = imsTemplateOptions;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SessionTemplate1) {
            SessionTemplate1 otherSession = (SessionTemplate1)obj;
            return otherSession.imsTemplateOptions.equals(this.imsTemplateOptions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.imsTemplateOptions.hashCode();
    }

    @Override
    public Result<StringBuffer> start(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"starting a new template edit session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            ImsSubsystemConfig config = this.imsTemplateOptions.getSubsystem().getCanonicalConfig();
            boolean isStatic = config.isDir() || config.isStaticOnly(this.imsTemplateOptions.getRegionType());
            Result<ImsDatabaseInfo> infoLookupResult = this.imsTemplateOptions.getDatabase().loadInfo(monitor, isStatic ? "XTPED" : null, this.imsTemplateOptions.getRegionType());
            if (!infoLookupResult.isSuccessfulWithoutWarnings()) {
                result.addSubResult(infoLookupResult);
                result.setRC(result.getRC());
                return result;
            }
            this.imsDatabaseInfo = (ImsDatabaseInfo)infoLookupResult.getOutput();
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), monitor);
            SSOP ssop = new SSOP();
            ssop.setConfig(config, isStatic ? ImsAccessMode.STATIC : null);
            Result<StringBuffer> setSubsysOptionsResult = UtilityFunctionRunner.runCommand(this.connection, ssop, monitor);
            if (!setSubsysOptionsResult.isSuccessfulWithoutWarnings()) {
                String msgs = setSubsysOptionsResult.getMessagesCombined().toString();
                logger.trace(new Object[]{"Failed to set IMS subsystem options", msgs});
                result.addSubResult(setSubsysOptionsResult);
                return result;
            }
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.imsTemplateOptions.getTemplate(), (String)"", (String)IMS_TEMPLATE_EXTENSION);
            this.connection.browseTemplate1InXML(this.imsTemplateOptions, this.fromCacheFile.getLocation().toString(), (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add(MessageFormat.format(Messages.CommEditTemplateSession_START_ERR, this.imsTemplateOptions.getTemplate().getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    public Result<StringBuffer> startWithLocalContentsForNewTemplate(IHowIsGoing monitor, StringBuffer newTemplateContents) throws InterruptedException {
        logger.trace((Object)"starting a new template edit session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            ImsSubsystemConfig config = this.imsTemplateOptions.getSubsystem().getCanonicalConfig();
            boolean isStatic = config.isDir() || config.isStaticOnly(this.imsTemplateOptions.getRegionType());
            Result<ImsDatabaseInfo> infoLookupResult = this.imsTemplateOptions.getDatabase().loadInfo(monitor, isStatic ? "XTPED" : null, this.imsTemplateOptions.getRegionType());
            if (!infoLookupResult.isSuccessfulWithoutWarnings()) {
                result.addSubResult(infoLookupResult);
                result.setRC(result.getRC());
                return result;
            }
            this.imsDatabaseInfo = (ImsDatabaseInfo)infoLookupResult.getOutput();
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), monitor);
            SSOP ssop = new SSOP();
            ssop.setConfig(config, isStatic ? ImsAccessMode.STATIC : null);
            Result<StringBuffer> setSubsysOptionsResult = UtilityFunctionRunner.runCommand(this.connection, ssop, monitor);
            if (!setSubsysOptionsResult.isSuccessfulWithoutWarnings()) {
                String msgs = setSubsysOptionsResult.getMessagesCombined().toString();
                logger.trace(new Object[]{"Failed to set IMS subsystem options", msgs});
                result.addSubResult(setSubsysOptionsResult);
                return result;
            }
            result.addSubResult(this.connection.createNewTemplate(monitor, this.imsTemplateOptions.getTemplate()));
            if (!result.isSuccessfulWithoutWarnings()) {
                return result;
            }
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.imsTemplateOptions.getTemplate(), (String)"", (String)IMS_TEMPLATE_EXTENSION);
            if (!this.fromCacheFile.exists()) {
                this.fromCacheFile.create((InputStream)new ByteArrayInputStream(newTemplateContents.toString().getBytes(StandardCharsets.UTF_8)), true, (IProgressMonitor)monitor.getMonitor());
            } else {
                this.fromCacheFile.setContents((InputStream)new ByteArrayInputStream(newTemplateContents.toString().getBytes(StandardCharsets.UTF_8)), true, true, (IProgressMonitor)monitor.getMonitor());
            }
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add(MessageFormat.format(Messages.CommEditTemplateSession_START_ERR, this.imsTemplateOptions.getTemplate().getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    public ImsDatabaseInfo getDatabaseInfo() {
        return this.imsDatabaseInfo;
    }

    public ImsTemplateOptions getFromTemplateOptions() {
        return this.imsTemplateOptions;
    }

    public IPDConnectEndpoint getEndpoint() {
        return this.imsTemplateOptions.getSubsystem();
    }
}

