/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.I1SLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.XSSDF;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ImsSubsystemQuery
extends PDPlatformObject
implements IEntityEventDispatcher<ImsSubsystemQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_CHAR_WILDCARD = "*";
    public static final Object PROPERTY_LOADED_SUBSYSTEMS = new Object();
    private final IPDHost host;
    private String query;
    private List<ImsSubsystemConfig> subsystemConfigs = null;
    private final EntityEventDispatcher<ImsSubsystemQuery> eventDispatcher = new EntityEventDispatcher((Object)this);
    private Object remoteListener = null;

    public static ImsSubsystemQuery createForHost(IPDHost host) {
        return new ImsSubsystemQuery(host, MULTI_CHAR_WILDCARD);
    }

    public ImsSubsystemQuery(IPDHost host, String query) {
        this.host = host;
        this.query = query;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImsSubsystemQuery)) {
            return false;
        }
        ImsSubsystemQuery other = (ImsSubsystemQuery)((Object)o);
        return this.host.equals(other.host) && this.query.equals(other.query);
    }

    public int hashCode() {
        int result = 37;
        result = 37 * result + this.host.hashCode();
        result = 37 * result + this.query.hashCode();
        return result;
    }

    public String getQuery() {
        return this.query;
    }

    public IPDHost getSystem() {
        return this.host;
    }

    public void setSubsystems(List<ImsSubsystemConfig> subsystems) {
        this.subsystemConfigs = subsystems;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_SUBSYSTEMS);
    }

    public List<ImsSubsystemConfig> getSubsystems() {
        if (this.subsystemConfigs == null) {
            return this.subsystemConfigs;
        }
        return Collections.unmodifiableList(this.subsystemConfigs);
    }

    public Result<List<ImsSubsystemConfig>> loadSubsystems(IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(this.host, "Need to set a non-null host first.");
        FMHost fmHost = (FMHost)this.host.getFMHostSystem();
        try {
            fmHost.loadServerVersion(this.host, monitor);
        }
        catch (CommunicationException ce) {
            Result result = new Result();
            result.setRC(8);
            result.add(Messages.ImsSubsystemQuery_0);
            result.add(ce);
            return result;
        }
        fmHost.ensureSupported(this.host, FMFeature.IMS_LISTINGS);
        XSSDF xssdf = new XSSDF();
        xssdf.setSSID(this.getQuery());
        Result result = UtilityFunctionRunner.executeAndParse(this.host, new ImsSubsystem(this.getSystem()), xssdf, new I1SLParser(this.host), monitor);
        this.setSubsystems((List)result.getOutput());
        return result;
    }

    public Object getLoadFinishedListener() {
        return this.remoteListener;
    }

    public void setLoadFinishedListener(Object listener) {
        this.remoteListener = listener;
    }

    public void addListener(EListener<EntityEvent<ImsSubsystemQuery>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<ImsSubsystemQuery>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPDImageName() {
        return "ims_subsystem_browse";
    }

    public String getPDLabel() {
        return this.getQuery();
    }
}

