/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ims.ImsBmpRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsDliRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.I1SLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.VSSID;
import com.ibm.etools.fm.core.socket.func.ims.XSSDF;
import com.ibm.etools.fm.core.socket.func.ims.XSSDFParser;
import com.ibm.etools.fm.jhost.core.util.ConversionUtil;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ImsSubsystemConfigDialogModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ImsSubsystemConfig originalconfig;
    private boolean resetToDefault = false;
    private String description;
    private List<String> psbLibs = new ArrayList<String>();
    private List<String> dbdLibs = new ArrayList<String>();
    private List<String> templateLibs = new ArrayList<String>();
    private ImsSubsystemConfig.TempDataSetAllocParamsDevType logAllocationParameters;
    private ImsSubsystemConfig.TempDataSetAllocParamsDevType xKeysAllocationParameters;
    private ImsSubsystemConfig.TempDataSetAllocParamsVolumes logicalKeysAllocationParameters;
    private ImsSubsystemConfig.TempDataSetAllocParamsVolumes rootKeysAllocationParameters;
    private boolean pardli1;
    private String nba = "";
    private String oba = "";
    private String bmpLockMax = "";
    private boolean bmpAutoSave;
    private String bmpEditF = "";
    private String bmpCrall = "";
    private String bmpLoad = "";
    private String bmpBEditF = "";
    private boolean bmpPsbBr;
    private boolean bmpPsbEx;
    private boolean bmpPsbPr;
    private boolean bmpPsbBb;
    private String dfsvsamp = "";
    private List<String> reslibs = new ArrayList<String>();
    private String imsMacroLib = "";
    private String reconPrimary = "";
    private String reconSecondary = "";
    private String reconSpare = "";
    private String acbLib = "";
    private String imsLogLib = "";
    private boolean dynB;
    private ImsDliRegionConfig.DefaultableBoolean dbrc;
    private ImsDliRegionConfig.DefaultableBoolean irlm;
    private ImsSubsystemConfig.ImsLogUsage imsLogUsage;
    private String irlmName = "";
    private String gsgName = "";
    private String tmiName = "";
    private String buf = "";
    private String dliLockMax = "";
    private boolean dliAutoSave;
    private String dliEditF = "";
    private String dliCrall = "";
    private String dliLoad = "";
    private String dliBEditF = "";
    private boolean dliPsbBr;
    private boolean dliPsbEx;
    private boolean dliPsbPr;
    private boolean dliPsbBb;
    private static final PDLogger logger = PDLogger.get(ImsSubsystemConfigDialogModel.class);

    public ImsSubsystemConfigDialogModel(ImsSubsystemConfig config) {
        super(Objects.requireNonNull(config, "Must provide a non-null config.").getSystem());
        this.originalconfig = config;
        this.updateStateFrom(config);
    }

    public void updateStateFrom(ImsSubsystemConfig config) {
        this.description = config.getDescription();
        this.psbLibs.clear();
        List<DataSet> psbLibsTmp = config.getPsbLibs();
        int i = 0;
        while (i < 6) {
            String lib = "";
            if (i < psbLibsTmp.size()) {
                lib = psbLibsTmp.get(i).getFormattedName();
            }
            this.psbLibs.add(lib);
            ++i;
        }
        this.dbdLibs.clear();
        List<DataSet> dbdLibsTmp = config.getDbdLibs();
        int i2 = 0;
        while (i2 < 6) {
            String lib = "";
            if (i2 < dbdLibsTmp.size()) {
                lib = dbdLibsTmp.get(i2).getFormattedName();
            }
            this.dbdLibs.add(lib);
            ++i2;
        }
        this.templateLibs.clear();
        List<DataSet> templateLibsTmp = config.getTemplateLibs();
        int i3 = 0;
        while (i3 < 6) {
            String lib = "";
            if (i3 < templateLibsTmp.size()) {
                lib = templateLibsTmp.get(i3).getFormattedName();
            }
            this.templateLibs.add(lib);
            ++i3;
        }
        this.logAllocationParameters = new ImsSubsystemConfig.TempDataSetAllocParamsDevType(config.getLogAllocationParameters());
        this.xKeysAllocationParameters = new ImsSubsystemConfig.TempDataSetAllocParamsDevType(config.getXKeysAllocationParameters());
        this.logicalKeysAllocationParameters = new ImsSubsystemConfig.TempDataSetAllocParamsVolumes(config.getLogicalKeysAllocationParameters());
        this.rootKeysAllocationParameters = new ImsSubsystemConfig.TempDataSetAllocParamsVolumes(config.getRootKeysAllocationParameters());
        ImsBmpRegionConfig bmpConfig = config.getBmpConfig();
        this.pardli1 = bmpConfig.isDliProcessingInImsRegion();
        this.nba = bmpConfig.getNumFastPathDbBuffers();
        this.oba = bmpConfig.getNumFastPathAdditionalBuffers();
        this.bmpLockMax = bmpConfig.getLockMax();
        this.bmpAutoSave = bmpConfig.isAutoSave();
        this.bmpEditF = bmpConfig.getEditCheckpointFrequency();
        this.bmpCrall = bmpConfig.getChangeRepeatAllCheckpointFrequency();
        this.bmpLoad = bmpConfig.getLoadCheckpointFrequency();
        this.bmpBEditF = bmpConfig.getBatchEditCheckpointFrequency();
        this.bmpPsbBr = bmpConfig.isBrowseIntegrityMaintained();
        this.bmpPsbEx = bmpConfig.isExtractIntegrityMaintained();
        this.bmpPsbPr = bmpConfig.isPrintIntegrityMaintained();
        this.bmpPsbBb = bmpConfig.isBatchBrowseIntegrityMaintained();
        ImsDliRegionConfig dliConfig = config.getDliConfig();
        if (dliConfig.getDfsvsamp() != null) {
            this.dfsvsamp = dliConfig.getDfsvsamp().getFormattedName();
        }
        this.reslibs.clear();
        List<DataSet> resLibs = dliConfig.getResLibs();
        int i4 = 0;
        while (i4 < 6) {
            String lib = "";
            if (i4 < resLibs.size()) {
                lib = resLibs.get(i4).getFormattedName();
            }
            this.reslibs.add(lib);
            ++i4;
        }
        if (dliConfig.getImsMacroLib() != null) {
            this.imsMacroLib = dliConfig.getImsMacroLib().getFormattedName();
        }
        this.reconPrimary = dliConfig.getReconPrimary() != null ? dliConfig.getReconPrimary().getFormattedName() : "";
        this.reconSecondary = dliConfig.getReconSecondary() != null ? dliConfig.getReconSecondary().getFormattedName() : "";
        String string = this.reconSpare = dliConfig.getReconSpare() != null ? dliConfig.getReconSpare().getFormattedName() : "";
        if (dliConfig.getAcbLib() != null) {
            this.acbLib = dliConfig.getAcbLib().getFormattedName();
        }
        if (dliConfig.getImsLogLib() != null) {
            this.imsLogLib = dliConfig.getImsLogLib();
        }
        this.dynB = dliConfig.isDynamicBackoutEnabled();
        this.dbrc = dliConfig.isUsingDatabaseRecoveryControl();
        this.irlm = dliConfig.isUsingInternalResourceLockManager();
        this.imsLogUsage = dliConfig.getImsLogUsage();
        this.irlmName = dliConfig.getInternalResourceLockManagerName();
        this.gsgName = dliConfig.getGlobalServiceGroupName();
        this.tmiName = dliConfig.getTransportManagerInstanceName();
        this.buf = dliConfig.getBufferCount();
        this.dliLockMax = dliConfig.getLockMax();
        this.dliAutoSave = dliConfig.isAutoSave();
        this.dliEditF = dliConfig.getEditCheckpointFrequency();
        this.dliCrall = dliConfig.getChangeRepeatAllCheckpointFrequency();
        this.dliLoad = dliConfig.getLoadCheckpointFrequency();
        this.dliBEditF = dliConfig.getBatchEditCheckpointFrequency();
        this.dliPsbBr = dliConfig.isBrowseIntegrityMaintained();
        this.dliPsbEx = dliConfig.isExtractIntegrityMaintained();
        this.dliPsbPr = dliConfig.isPrintIntegrityMaintained();
        this.dliPsbBb = dliConfig.isBatchBrowseIntegrityMaintained();
    }

    public String getValidationErrorMessage() {
        int i;
        if (!this.originalconfig.isDir()) {
            boolean hasPsbLib = false;
            i = 0;
            while (i < this.psbLibs.size()) {
                String lib = this.psbLibs.get(i);
                if (!lib.isEmpty() && !DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                    return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_PSB_LIB_X_Y_NAME_INVALID, i + 1, lib);
                }
                if (DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                    hasPsbLib = true;
                }
                ++i;
            }
            if (!hasPsbLib) {
                return Messages.ImsSubsystemConfigDialogModel_ERROR_MISSING_PSB_LIB;
            }
            boolean hasDbdLib = false;
            int i2 = 0;
            while (i2 < this.dbdLibs.size()) {
                String lib = this.dbdLibs.get(i2);
                if (!lib.isEmpty() && !DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                    return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_DBD_LIB_X_Y_NAME_INVALID, i2 + 1, lib);
                }
                if (DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                    hasDbdLib = true;
                }
                ++i2;
            }
            if (!hasDbdLib) {
                return Messages.ImsSubsystemConfigDialogModel_ERROR_MISSING_DBD_LIB;
            }
        }
        boolean hasTemplateLib = false;
        i = 0;
        while (i < this.templateLibs.size()) {
            String lib = this.templateLibs.get(i);
            if (!lib.isEmpty() && !DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_TEMPLATE_LIB_X_Y_NAME_INVALID, i + 1, lib);
            }
            if (DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                hasTemplateLib = true;
            }
            ++i;
        }
        if (!hasTemplateLib) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_MISSING_TEMPLATE_LIB;
        }
        if (!this.logicalKeysAllocationParameters.getVolume1().isEmpty() && !Volume.isValid(this.logicalKeysAllocationParameters.getVolume1(), this.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_LOGICAL_KEY_VOL_1_NAME_INVALID, this.logicalKeysAllocationParameters.getVolume1());
        }
        if (!this.logicalKeysAllocationParameters.getVolume2().isEmpty() && !Volume.isValid(this.logicalKeysAllocationParameters.getVolume2(), this.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_LOGICAL_KEY_VOL_2_NAME_INVALID, this.logicalKeysAllocationParameters.getVolume2());
        }
        if (!this.logicalKeysAllocationParameters.getVolume3().isEmpty() && !Volume.isValid(this.logicalKeysAllocationParameters.getVolume3(), this.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_LOGICAL_KEY_VOL_3_NAME_INVALID, this.logicalKeysAllocationParameters.getVolume3());
        }
        if (!this.rootKeysAllocationParameters.getVolume1().isEmpty() && !Volume.isValid(this.rootKeysAllocationParameters.getVolume1(), this.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_ROOT_KEY_VOL_1_NAME_INVALID, this.rootKeysAllocationParameters.getVolume1());
        }
        if (!this.rootKeysAllocationParameters.getVolume2().isEmpty() && !Volume.isValid(this.rootKeysAllocationParameters.getVolume2(), this.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_ROOT_KEY_VOL_2_NAME_INVALID, this.rootKeysAllocationParameters.getVolume2());
        }
        if (!this.rootKeysAllocationParameters.getVolume3().isEmpty() && !Volume.isValid(this.rootKeysAllocationParameters.getVolume3(), this.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_ROOT_KEY_VOL_3_NAME_INVALID, this.rootKeysAllocationParameters.getVolume3());
        }
        String msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.nba, 1, 9999, Messages.ImsSubsystemConfigDialogModel_ERROR_NUMBER_DB_BUFFERS);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.oba, 1, 9999, Messages.ImsSubsystemConfigDialogModel_ERROR_NUMBER_FIXED_PAGE_BUFFERS);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.bmpLockMax, 0, Short.MAX_VALUE, Messages.ImsSubsystemConfigDialogModel_ERROR_BMP_MAX_LOCKS_PER_FUNCTION);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.bmpEditF, 1, 99, Messages.ImsSubsystemConfigDialogModel_ERROR_BMP_EDIT_CHKPT_FREQ);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.bmpCrall, 1, 9999, Messages.ImsSubsystemConfigDialogModel_ERROR_BMP_CHANGE_REPEATALL_CHKPT_FREQ);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.bmpLoad, 1, 99999, Messages.ImsSubsystemConfigDialogModel_ERROR_BMP_LOAD_CHKPT_FREQ);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.bmpBEditF, 1, 99999, Messages.ImsSubsystemConfigDialogModel_ERROR_BMP_BATCH_EDIT_CHKPT_FREQ);
        if (msg != null) {
            return msg;
        }
        if (this.dfsvsamp.isEmpty()) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_DFSVSAMP_must_be_specified;
        }
        if (!Member.isParseable(this.dfsvsamp, true, this.getHostProvider().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_DFSVSAMP_X_NOT_A_DS_WITH_MEMBER, this.dfsvsamp);
        }
        boolean hasResLib = false;
        int i3 = 0;
        while (i3 < this.reslibs.size()) {
            String lib = this.reslibs.get(i3);
            if (!lib.isEmpty() && !DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_RESLIB_X_Y_INVALID_NAME, i3 + 1, lib);
            }
            if (DataSet.isValidName(lib, this.getHostProvider().getCodePage())) {
                hasResLib = true;
            }
            ++i3;
        }
        if (!hasResLib) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_AT_LEAST_1_RESLIB;
        }
        if (this.imsMacroLib.isEmpty()) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_MISSING_IMS_MACRO_LIB;
        }
        if (!DataSet.isValidName(this.imsMacroLib, this.getHostProvider().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_IMS_MACRO_LIB_NAME_INVALID, this.imsMacroLib);
        }
        if (!this.reconPrimary.isEmpty() && !DataSet.isValidName(this.reconPrimary, this.getHostProvider().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_RECON_PRIMARY_X_NAME_INVALID, this.reconPrimary);
        }
        if (!this.reconSecondary.isEmpty() && !DataSet.isValidName(this.reconSecondary, this.getHostProvider().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_RECON_SECONDARY_X_NAME_INVALID, this.reconSecondary);
        }
        if (!this.reconSpare.isEmpty() && !DataSet.isValidName(this.reconSpare, this.getHostProvider().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_RECON_SPARE_X_NAME_INVALID, this.reconSpare);
        }
        if (this.acbLib.isEmpty()) {
            return Messages.ImsSubsystemConfigDialogModel_ACBLIB_must_be_specified;
        }
        if (!DataSet.isValidName(this.acbLib, this.getHostProvider().getCodePage())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_ACBLIB_NAME_INVALID, this.acbLib);
        }
        if (this.dbrc == ImsDliRegionConfig.DefaultableBoolean.YES && this.imsLogUsage == ImsSubsystemConfig.ImsLogUsage.NONE) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_ENABLED_DBRC_IMSLOG_NONE;
        }
        if (this.irlmName.length() > 4) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_IRLM_NAME_INVALID;
        }
        if (this.gsgName.length() > 8) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_GSG_NAME_INVALID;
        }
        if (this.tmiName.length() > 4) {
            return Messages.ImsSubsystemConfigDialogModel_ERROR_TMI_NAME_INVALID;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.buf, 1, 999, Messages.ImsSubsystemConfigDialogModel_BUFFER_COUNT);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.dliLockMax, 0, Short.MAX_VALUE, Messages.ImsSubsystemConfigDialogModel_DLI_MAX_LOCKS_INVALID);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.dliEditF, 1, 99, Messages.ImsSubsystemConfigDialogModel_DLI_EDIT_CHKPNT_FREQ_INVALID);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.dliCrall, 1, 9999, Messages.ImsSubsystemConfigDialogModel_DLI_CHANGE_EDIT_CHKPNT_FREQ_INVALID);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.dliLoad, 1, 99999, Messages.ImsSubsystemConfigDialogModel_DLI_LOAD_CHKPNT_FREQ_INVALID);
        if (msg != null) {
            return msg;
        }
        msg = ImsSubsystemConfigDialogModel.ensureIsEmptyOrIsIntInRange(this.dliBEditF, 1, 99999, Messages.ImsSubsystemConfigDialogModel_DLI_BATCH_EDIT_CHKPNT_FREQ_INVALID);
        if (msg != null) {
            return msg;
        }
        return null;
    }

    private static String ensureIsEmptyOrIsIntInRange(String val, int min, int max, String name) {
        if (val.isEmpty()) {
            return null;
        }
        if (!ConversionUtil.isInt((String)val)) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_X_MUST_BE_NUMERIC, name);
        }
        int nba = ConversionUtil.toInt((String)val);
        if (nba < min || nba > max) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_X_MUST_BE_BETWEEN_Y_TO_Z, name, min, max);
        }
        return null;
    }

    public void saveEditsTo(ImsSubsystemConfig config) {
        config.setCustom(!this.resetToDefault);
        config.setDescription(this.description);
        config.setPsbLibs(ImsSubsystemConfigDialogModel.fromStringsToDataSets(this.originalconfig.getSystem(), this.psbLibs));
        config.setDbdLibs(ImsSubsystemConfigDialogModel.fromStringsToDataSets(this.originalconfig.getSystem(), this.dbdLibs));
        config.setDir(this.originalconfig.isDir());
        config.setTemplateLibs(ImsSubsystemConfigDialogModel.fromStringsToDataSets(this.originalconfig.getSystem(), this.templateLibs));
        config.setLogAllocationParameters(this.logAllocationParameters);
        config.setXKeysAllocationParameters(this.xKeysAllocationParameters);
        config.setLogicalKeysAllocationParameters(this.logicalKeysAllocationParameters);
        config.setRootKeysAllocationParameters(this.rootKeysAllocationParameters);
        ImsBmpRegionConfig bmpConfig = config.getBmpConfig();
        bmpConfig.setDliProcessingInImsRegion(this.pardli1);
        bmpConfig.setNumFastPathDbBuffers(this.nba);
        bmpConfig.setNumFastPathAdditionalBuffers(this.oba);
        bmpConfig.setLockMax(this.bmpLockMax);
        bmpConfig.setAutoSave(this.bmpAutoSave);
        bmpConfig.setEditCheckpointFrequency(this.bmpEditF);
        bmpConfig.setChangeRepeatAllCheckpointFrequency(this.bmpCrall);
        bmpConfig.setLoadCheckpointFrequency(this.bmpLoad);
        bmpConfig.setBatchEditCheckpointFrequency(this.bmpBEditF);
        bmpConfig.setBrowseIntegrityMaintained(this.bmpPsbBr);
        bmpConfig.setExtractIntegrityMaintained(this.bmpPsbEx);
        bmpConfig.setPrintIntegrityMaintained(this.bmpPsbPr);
        bmpConfig.setBatchBrowseIntegrityMaintained(this.bmpPsbBb);
        ImsDliRegionConfig dliConfig = config.getDliConfig();
        dliConfig.setDfsvsamp(this.dfsvsamp.isEmpty() ? null : Member.parse(this.originalconfig.getSystem(), this.dfsvsamp).asMember());
        dliConfig.setResLibs(ImsSubsystemConfigDialogModel.fromStringsToDataSets(this.originalconfig.getSystem(), this.reslibs));
        dliConfig.setImsMacroLib(ImsSubsystemConfigDialogModel.fromStringToDataSet(this.originalconfig.getSystem(), this.imsMacroLib));
        dliConfig.setReconPrimary(ImsSubsystemConfigDialogModel.fromStringToDataSet(this.originalconfig.getSystem(), this.reconPrimary));
        dliConfig.setReconSecondary(ImsSubsystemConfigDialogModel.fromStringToDataSet(this.originalconfig.getSystem(), this.reconSecondary));
        dliConfig.setReconSpare(ImsSubsystemConfigDialogModel.fromStringToDataSet(this.originalconfig.getSystem(), this.reconSpare));
        dliConfig.setAcbLib(ImsSubsystemConfigDialogModel.fromStringToDataSet(this.originalconfig.getSystem(), this.acbLib));
        dliConfig.setImsLogLib(this.imsLogLib);
        dliConfig.setDynamicBackoutEnabled(this.dynB);
        dliConfig.setUsingDatabaseRecoveryControl(this.dbrc);
        dliConfig.setUsingInternalResourceLockManager(this.irlm);
        dliConfig.setImsLogUsage(this.imsLogUsage);
        dliConfig.setInternalResourceLockManagerName(this.irlmName);
        dliConfig.setGlobalServiceGroupName(this.gsgName);
        dliConfig.setTransportManagerInstanceName(this.tmiName);
        dliConfig.setBufferCount(this.buf);
        dliConfig.setLockMax(this.dliLockMax);
        dliConfig.setAutoSave(this.dliAutoSave);
        dliConfig.setEditCheckpointFrequency(this.dliEditF);
        dliConfig.setChangeRepeatAllCheckpointFrequency(this.dliCrall);
        dliConfig.setLoadCheckpointFrequency(this.dliLoad);
        dliConfig.setBatchEditCheckpointFrequency(this.dliBEditF);
        dliConfig.setBrowseIntegrityMaintained(this.dliPsbBr);
        dliConfig.setExtractIntegrityMaintained(this.dliPsbEx);
        dliConfig.setPrintIntegrityMaintained(this.dliPsbPr);
        dliConfig.setBatchBrowseIntegrityMaintained(this.dliPsbBb);
    }

    public static List<DataSet> fromStringsToDataSets(IPDHost host, List<String> strings) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        int i = 0;
        while (i < strings.size()) {
            DataSet ds = ImsSubsystemConfigDialogModel.fromStringToDataSet(host, strings.get(i));
            if (ds != null) {
                dataSets.add(ds);
            }
            ++i;
        }
        return dataSets;
    }

    private static DataSet fromStringToDataSet(IPDHost host, String dsn) {
        if (dsn == null) {
            return null;
        }
        if (dsn.isEmpty()) {
            return null;
        }
        if (DataSet.isValidName(dsn, host.getCodePage())) {
            return DataSet.create(host, dsn);
        }
        throw new IllegalStateException(dsn);
    }

    public ImsSubsystemConfig getOriginalConfig() {
        return this.originalconfig;
    }

    public boolean isResetToDefault() {
        return this.resetToDefault;
    }

    public String resetToDefault(IHowIsGoing monitor) throws InterruptedException {
        monitor.beginTask(Messages.ImsSubsystemConfigDialogModel_0, 5);
        monitor.worked(1);
        XSSDF xssdf = new XSSDF();
        xssdf.setSSID(this.originalconfig.getSubsystem().getSubsystemID());
        IPDHost host = this.originalconfig.getSubsystem().getSystem();
        Result result = UtilityFunctionRunner.executeAndParse(host, this.originalconfig.getSubsystem(), xssdf, new XSSDFParser(host), monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_FAILED_TO_LOAD_SUBSYSTEM_X, this.originalconfig.getSubsystem().getSubsystemID(), result.getMessagesCombined().toString());
        }
        monitor.worked(1);
        List output = (List)result.getOutput();
        if (output.size() != 1) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_FAILED_TO_LOAD_SUBSYSTEM_X_AS_Y_SUBSYSTEMS_RETURNED, this.originalconfig.getSubsystem().getSubsystemID(), output.size());
        }
        monitor.worked(1);
        ImsSubsystemConfig defaultConfig = (ImsSubsystemConfig)output.get(0);
        if (!defaultConfig.getSubsystem().equals(this.originalconfig.getSubsystem())) {
            return MessageFormat.format(Messages.ImsSubsystemConfigDialogModel_ERROR_FAILED_TO_LOAD_SUBSYSTEM_X_AS__ONLY_SUBSYSTEMS_Y_RETURNED, this.originalconfig.getSubsystem().getSubsystemID(), defaultConfig);
        }
        this.updateStateFrom(defaultConfig);
        monitor.worked(1);
        this.resetToDefault = true;
        monitor.done();
        return null;
    }

    public String validate(IHowIsGoing monitor) throws InterruptedException {
        monitor.beginTask(Messages.ImsSubsystemConfigDialogModel_1, 2);
        monitor.worked(1);
        VSSID vssid = new VSSID();
        vssid.setSSID(this.originalconfig.getSubsystem().getSubsystemID());
        vssid.setConfig(this);
        IPDHost host = this.originalconfig.getSubsystem().getSystem();
        Result result = UtilityFunctionRunner.executeAndParse(host, this.originalconfig.getSubsystem(), vssid, new I1SLParser(host), monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            String msgs = result.getMessagesCombined().toString();
            int softEndInd = msgs.indexOf("FMNBA230");
            if (softEndInd > 0) {
                logger.error((Object)msgs);
                msgs = msgs.substring(0, softEndInd);
            }
            return msgs;
        }
        monitor.worked(1);
        monitor.done();
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getPsbLibs() {
        return this.psbLibs;
    }

    public List<String> getDbdLibs() {
        return this.dbdLibs;
    }

    public List<String> getTemplateLibs() {
        return this.templateLibs;
    }

    public ImsSubsystemConfig.TempDataSetAllocParamsDevType getLogAllocationParameters() {
        return this.logAllocationParameters;
    }

    public ImsSubsystemConfig.TempDataSetAllocParamsDevType getXKeysAllocationParameters() {
        return this.xKeysAllocationParameters;
    }

    public ImsSubsystemConfig.TempDataSetAllocParamsVolumes getLogicalKeysAllocationParameters() {
        return this.logicalKeysAllocationParameters;
    }

    public ImsSubsystemConfig.TempDataSetAllocParamsVolumes getRootKeysAllocationParameters() {
        return this.rootKeysAllocationParameters;
    }

    public boolean isPardli1() {
        return this.pardli1;
    }

    public void setPardli1(boolean bmpPardli1) {
        this.pardli1 = bmpPardli1;
    }

    public String getNba() {
        return this.nba;
    }

    public void setNba(String bmpNba) {
        this.nba = bmpNba;
    }

    public String getOba() {
        return this.oba;
    }

    public void setOba(String bmpOba) {
        this.oba = bmpOba;
    }

    public String getBmpLockMax() {
        return this.bmpLockMax;
    }

    public void setBmpLockMax(String bmpLockMax) {
        this.bmpLockMax = bmpLockMax;
    }

    public boolean getBmpAutoSave() {
        return this.bmpAutoSave;
    }

    public void setBmpAutoSave(boolean bmpAutoSave) {
        this.bmpAutoSave = bmpAutoSave;
    }

    public String getBmpEditF() {
        return this.bmpEditF;
    }

    public void setBmpEditF(String bmpEditF) {
        this.bmpEditF = bmpEditF;
    }

    public String getBmpCrall() {
        return this.bmpCrall;
    }

    public void setBmpCrall(String bmpCrall) {
        this.bmpCrall = bmpCrall;
    }

    public String getBmpLoad() {
        return this.bmpLoad;
    }

    public void setBmpLoad(String bmpLoad) {
        this.bmpLoad = bmpLoad;
    }

    public String getBmpBEditF() {
        return this.bmpBEditF;
    }

    public void setBmpBEditF(String bmpBEditF) {
        this.bmpBEditF = bmpBEditF;
    }

    public boolean getBmpPsbBr() {
        return this.bmpPsbBr;
    }

    public void setBmpPsbBr(boolean bmpPsbBr) {
        this.bmpPsbBr = bmpPsbBr;
    }

    public boolean getBmpPsbEx() {
        return this.bmpPsbEx;
    }

    public void setBmpPsbEx(boolean bmpPsbEx) {
        this.bmpPsbEx = bmpPsbEx;
    }

    public boolean getBmpPsbPr() {
        return this.bmpPsbPr;
    }

    public void setBmpPsbPr(boolean bmpPsbPr) {
        this.bmpPsbPr = bmpPsbPr;
    }

    public boolean getBmpPsbBb() {
        return this.bmpPsbBb;
    }

    public void setBmpPsbBb(boolean bmpPsbBb) {
        this.bmpPsbBb = bmpPsbBb;
    }

    public String getDfsvsamp() {
        return this.dfsvsamp;
    }

    public void setDfsvsamp(String dfsvsamp) {
        this.dfsvsamp = dfsvsamp;
    }

    public String getImsMacroLib() {
        return this.imsMacroLib;
    }

    public void setImsMacroLib(String imsMacroLib) {
        this.imsMacroLib = imsMacroLib;
    }

    public String getReconPrimary() {
        return this.reconPrimary;
    }

    public void setReconPrimary(String reconPrimary) {
        this.reconPrimary = reconPrimary;
    }

    public String getReconSecondary() {
        return this.reconSecondary;
    }

    public void setReconSecondary(String reconSecondary) {
        this.reconSecondary = reconSecondary;
    }

    public String getReconSpare() {
        return this.reconSpare;
    }

    public void setReconSpare(String reconSpare) {
        this.reconSpare = reconSpare;
    }

    public String getAcbLib() {
        return this.acbLib;
    }

    public void setAcbLib(String acbLib) {
        this.acbLib = acbLib;
    }

    public String getImsLogLib() {
        return this.imsLogLib;
    }

    public void setImsLogLib(String imsLogLib) {
        this.imsLogLib = imsLogLib;
    }

    public boolean isDynB() {
        return this.dynB;
    }

    public void setDynB(boolean dynB) {
        this.dynB = dynB;
    }

    public ImsDliRegionConfig.DefaultableBoolean getDbrc() {
        return this.dbrc;
    }

    public void setDbrc(ImsDliRegionConfig.DefaultableBoolean dbrc) {
        this.dbrc = dbrc;
    }

    public ImsDliRegionConfig.DefaultableBoolean getIrlm() {
        return this.irlm;
    }

    public void setIrlm(ImsDliRegionConfig.DefaultableBoolean irlm) {
        this.irlm = irlm;
    }

    public ImsSubsystemConfig.ImsLogUsage getImsLogUsage() {
        return this.imsLogUsage;
    }

    public void setImsLogUsage(ImsSubsystemConfig.ImsLogUsage imsLogUsage) {
        this.imsLogUsage = imsLogUsage;
    }

    public String getIrlmName() {
        return this.irlmName;
    }

    public void setIrlmName(String irlmName) {
        this.irlmName = irlmName;
    }

    public String getGsgName() {
        return this.gsgName;
    }

    public void setGsgName(String gsgName) {
        this.gsgName = gsgName;
    }

    public String getTmiName() {
        return this.tmiName;
    }

    public void setTmiName(String tmiName) {
        this.tmiName = tmiName;
    }

    public String getBuf() {
        return this.buf;
    }

    public void setBuf(String buf) {
        this.buf = buf;
    }

    public String getDliLockMax() {
        return this.dliLockMax;
    }

    public void setDliLockMax(String dliLockMax) {
        this.dliLockMax = dliLockMax;
    }

    public boolean isDliAutoSave() {
        return this.dliAutoSave;
    }

    public void setDliAutoSave(boolean dliAutoSave) {
        this.dliAutoSave = dliAutoSave;
    }

    public String getDliEditF() {
        return this.dliEditF;
    }

    public void setDliEditF(String dliEditF) {
        this.dliEditF = dliEditF;
    }

    public String getDliCrall() {
        return this.dliCrall;
    }

    public void setDliCrall(String dliCrall) {
        this.dliCrall = dliCrall;
    }

    public String getDliLoad() {
        return this.dliLoad;
    }

    public void setDliLoad(String dliLoad) {
        this.dliLoad = dliLoad;
    }

    public String getDliBEditF() {
        return this.dliBEditF;
    }

    public void setDliBEditF(String dliBEditF) {
        this.dliBEditF = dliBEditF;
    }

    public boolean isDliPsbBr() {
        return this.dliPsbBr;
    }

    public void setDliPsbBr(boolean dliPsbBr) {
        this.dliPsbBr = dliPsbBr;
    }

    public boolean isDliPsbEx() {
        return this.dliPsbEx;
    }

    public void setDliPsbEx(boolean dliPsbEx) {
        this.dliPsbEx = dliPsbEx;
    }

    public boolean isDliPsbPr() {
        return this.dliPsbPr;
    }

    public void setDliPsbPr(boolean dliPsbPr) {
        this.dliPsbPr = dliPsbPr;
    }

    public boolean isDliPsbBb() {
        return this.dliPsbBb;
    }

    public void setDliPsbBb(boolean dliPsbBb) {
        this.dliPsbBb = dliPsbBb;
    }

    public List<String> getReslibs() {
        return this.reslibs;
    }

    public void setPsbLibs(List<String> psbLibs) {
        this.psbLibs = psbLibs;
    }

    public void setDbdLibs(List<String> dbdLibs) {
        this.dbdLibs = dbdLibs;
    }

    public void setTemplateLibs(List<String> templateLibs) {
        this.templateLibs = templateLibs;
    }
}

