/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.ims.ImsBmpRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsDliRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ImsSubsystemConfig
extends PDPlatformObject
implements IEntityEventDispatcher<ImsSubsystemConfig>,
ImsSubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final Object PROPERTY_SUBSYSTEM_CONFIG = new Object();
    public static final int MAX_PSB_LIBS = 6;
    public static final int MAX_DBD_LIBS = 6;
    public static final int MAX_TEMPLATE_LIBS = 6;
    private ImsSubsystem subsystem;
    private boolean agnsUsed = true;
    private String description = "";
    private boolean online = false;
    private boolean dliSupported = false;
    private ImsDliRegionConfig dliConfig = null;
    private boolean bmpSupported = false;
    private ImsBmpRegionConfig bmpConfig = null;
    private boolean dynalloc = false;
    private boolean iefrder = false;
    private String timeout = new String();
    private String chkpmmss = new String();
    private boolean dir = false;
    private List<DataSet> psbLibs = new ArrayList<DataSet>();
    private boolean psbLibsUpdateable = false;
    private List<DataSet> dbdLibs = new ArrayList<DataSet>();
    private boolean dbdLibsUpdateable = false;
    private List<DataSet> templateLibs = new ArrayList<DataSet>();
    private boolean templateLibsUpdateable = false;
    private TempDataSetAllocParamsDevType logAllocationParameters = new TempDataSetAllocParamsDevType();
    private TempDataSetAllocParamsDevType xKeysAllocationParameters = new TempDataSetAllocParamsDevType();
    private TempDataSetAllocParamsVolumes logicalKeysAllocationParameters = new TempDataSetAllocParamsVolumes();
    private TempDataSetAllocParamsVolumes rootKeysAllocationParameters = new TempDataSetAllocParamsVolumes();
    private boolean custom;
    private final EntityEventDispatcher<ImsSubsystemConfig> eventDispatcher = new EntityEventDispatcher((Object)this);
    private final EListener<EntityEvent<ImsDliRegionConfig>> dliConfigListener = new EListener<EntityEvent<ImsDliRegionConfig>>(){

        public void onEvent(EntityEvent<ImsDliRegionConfig> event) {
            if (event.getType() == EntityEventType.CHANGED) {
                ImsSubsystemConfig.this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
            }
        }
    };
    private final EListener<EntityEvent<ImsBmpRegionConfig>> bmpConfigListener = new EListener<EntityEvent<ImsBmpRegionConfig>>(){

        public void onEvent(EntityEvent<ImsBmpRegionConfig> event) {
            if (event.getType() == EntityEventType.CHANGED) {
                ImsSubsystemConfig.this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
            }
        }
    };

    public ImsSubsystemConfig(ImsSubsystem subsystem) {
        this.subsystem = Objects.requireNonNull(subsystem, "Must provide a non-null subsystem");
        this.setBmpConfig(new ImsBmpRegionConfig(this));
        this.setDliConfig(new ImsDliRegionConfig(this));
    }

    public ImsSubsystemConfig(ImsSubsystemConfig config) {
        this(config.getSubsystem());
        this.setAgnsUsed(config.agnsUsed);
        this.setDescription(config.description);
        this.setOnline(config.online);
        this.setDliSupported(config.dliSupported);
        this.setDliConfig(new ImsDliRegionConfig(config.dliConfig));
        this.setBmpSupported(config.bmpSupported);
        this.setBmpConfig(new ImsBmpRegionConfig(config.bmpConfig));
        this.setPsbLibs(config.psbLibs);
        this.setPsbLibsUpdateable(config.psbLibsUpdateable);
        this.setDbdLibs(config.dbdLibs);
        this.setDbdLibsUpdateable(config.psbLibsUpdateable);
        this.setTemplateLibs(config.templateLibs);
        this.setTemplateLibsUpdateable(config.templateLibsUpdateable);
        this.setCustom(config.custom);
        this.setDynalloc(config.dynalloc);
        this.setIefrder(config.iefrder);
        this.setTimeout(config.timeout);
        this.setChkpmmss(config.chkpmmss);
        this.setDir(config.dir);
    }

    public IPDHost getSystem() {
        return this.subsystem.getSystem();
    }

    public void setSystem(IPDHost system) {
        this.subsystem.setSystem(system);
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(ImsSubsystem subsystem, boolean fromRSE) {
        if (fromRSE) {
            this.subsystem = subsystem;
            subsystem.addCanonicalConfig(this);
        }
    }

    public String getLabel() {
        Object label = this.subsystem.getSubsystemID();
        if (this.isCustom()) {
            label = (String)label + " [Custom]";
        }
        return (String)label + ": " + this.getDescription();
    }

    public String toString() {
        return "imsConfig:" + String.valueOf(this.subsystem);
    }

    public ImsRegionConfig getRegionConfig(ImsRegionType regionType) {
        switch (regionType) {
            case BMP: {
                return this.getBmpConfig();
            }
            case DLI: {
                return this.getDliConfig();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isStaticAccessSupported(ImsRegionType regionType) {
        switch (regionType) {
            case BMP: {
                return this.getBmpConfig().isStaticAccessSupported();
            }
            case DLI: {
                return this.getDliConfig().isStaticAccessSupported();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isStaticOnly(ImsRegionType regionType) {
        switch (regionType) {
            case BMP: {
                ImsBmpRegionConfig bmpRegionConfig = this.getBmpConfig();
                return bmpRegionConfig == null || bmpRegionConfig.isStaticAccessSupported() && !bmpRegionConfig.isDynamicAccessSupported();
            }
            case DLI: {
                ImsDliRegionConfig dliRegionConfig = this.getDliConfig();
                return dliRegionConfig == null || dliRegionConfig.isStaticAccessSupported() && !dliRegionConfig.isDynamicAccessSupported();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isDynamicAccessSupported(ImsRegionType regionType) {
        switch (regionType) {
            case BMP: {
                return this.getBmpConfig().isDynamicAccessSupported();
            }
            case DLI: {
                return this.getDliConfig().isDynamicAccessSupported();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isDynamicOnly(ImsRegionType regionType) {
        switch (regionType) {
            case BMP: {
                ImsBmpRegionConfig bmpRegionConfig = this.getBmpConfig();
                return bmpRegionConfig == null || !bmpRegionConfig.isStaticAccessSupported() && bmpRegionConfig.isDynamicAccessSupported();
            }
            case DLI: {
                ImsDliRegionConfig dliRegionConfig = this.getDliConfig();
                return dliRegionConfig == null || !dliRegionConfig.isStaticAccessSupported() && dliRegionConfig.isDynamicAccessSupported();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isConnectable() {
        return this.getDliConfig().isConnectable() || this.getBmpConfig().isConnectable();
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.agnsUsed ? 1231 : 1237);
        result = 31 * result + (this.bmpSupported ? 1231 : 1237);
        result = 31 * result + (this.dbdLibs == null ? 0 : this.dbdLibs.hashCode());
        result = 31 * result + (this.dbdLibsUpdateable ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.dliSupported ? 1231 : 1237);
        result = 31 * result + (this.subsystem == null ? 0 : this.subsystem.hashCode());
        result = 31 * result + (this.online ? 1231 : 1237);
        result = 31 * result + (this.psbLibs == null ? 0 : this.psbLibs.hashCode());
        result = 31 * result + (this.psbLibsUpdateable ? 1231 : 1237);
        result = 31 * result + (this.templateLibs == null ? 0 : this.templateLibs.hashCode());
        result = 31 * result + (this.templateLibsUpdateable ? 1231 : 1237);
        result = 31 * result + (this.custom ? 1231 : 1237);
        result = 31 * result + (this.dynalloc ? 1231 : 1237);
        result = 31 * result + (this.iefrder ? 1231 : 1237);
        result = 31 * result + (this.timeout == null ? 0 : this.timeout.hashCode());
        result = 31 * result + (this.chkpmmss == null ? 0 : this.chkpmmss.hashCode());
        result = 31 * result + (this.dir ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImsSubsystemConfig)) {
            return false;
        }
        ImsSubsystemConfig other = (ImsSubsystemConfig)obj;
        if (this.agnsUsed != other.agnsUsed) {
            return false;
        }
        if (this.bmpSupported != other.bmpSupported) {
            return false;
        }
        if (this.dbdLibs == null ? other.dbdLibs != null : !this.dbdLibs.equals(other.dbdLibs)) {
            return false;
        }
        if (this.dbdLibsUpdateable != other.dbdLibsUpdateable) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.dliSupported != other.dliSupported) {
            return false;
        }
        if (this.subsystem == null ? other.subsystem != null : !this.subsystem.equals(other.subsystem)) {
            return false;
        }
        if (this.online != other.online) {
            return false;
        }
        if (this.psbLibs == null ? other.psbLibs != null : !this.psbLibs.equals(other.psbLibs)) {
            return false;
        }
        if (this.psbLibsUpdateable != other.psbLibsUpdateable) {
            return false;
        }
        if (this.templateLibs == null ? other.templateLibs != null : !this.templateLibs.equals(other.templateLibs)) {
            return false;
        }
        if (this.templateLibsUpdateable != other.templateLibsUpdateable) {
            return false;
        }
        if (this.custom != other.custom) {
            return false;
        }
        if (this.dynalloc != other.dynalloc) {
            return false;
        }
        if (this.iefrder != other.iefrder) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        if (this.chkpmmss != other.chkpmmss) {
            return false;
        }
        return this.dir == other.dir;
    }

    public void setAgnsUsed(boolean agnsUsed) {
        this.agnsUsed = agnsUsed;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isAgnsUsed() {
        return this.agnsUsed;
    }

    public void setDescription(String description) {
        this.description = description;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public String getDescription() {
        return this.description;
    }

    public void setOnline(boolean online) {
        this.online = online;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setDliSupported(boolean dliSupported) {
        this.dliSupported = dliSupported;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isDliSupported() {
        return this.dliSupported;
    }

    public void setDliConfig(ImsDliRegionConfig dliConfig) {
        Objects.requireNonNull(dliConfig, "Must provide a non-null dliConfig");
        if (this.dliConfig != null) {
            this.dliConfig.removeListener(this.dliConfigListener);
        }
        this.dliConfig = new ImsDliRegionConfig(dliConfig);
        this.dliConfig.addListener(this.dliConfigListener);
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public ImsDliRegionConfig getDliConfig() {
        return this.dliConfig;
    }

    public void setBmpSupported(boolean bmpSupported) {
        this.bmpSupported = bmpSupported;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isBmpSupported() {
        return this.bmpSupported;
    }

    public void setBmpConfig(ImsBmpRegionConfig bmpConfig) {
        Objects.requireNonNull(bmpConfig, "Must provide a non-null bmpConfig");
        if (this.bmpConfig != null) {
            this.bmpConfig.removeListener(this.bmpConfigListener);
        }
        this.bmpConfig = new ImsBmpRegionConfig(bmpConfig);
        this.bmpConfig.addListener(this.bmpConfigListener);
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public ImsBmpRegionConfig getBmpConfig() {
        return this.bmpConfig;
    }

    public void setDynalloc(boolean dynalloc) {
        this.dynalloc = dynalloc;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isDynalloc() {
        return this.dynalloc;
    }

    public void setIefrder(boolean iefrder) {
        this.iefrder = iefrder;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isIefrder() {
        return this.iefrder;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setChkpmmss(String chkpmmss) {
        this.chkpmmss = chkpmmss;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public String getChkpmmss() {
        return this.chkpmmss;
    }

    public void setDir(boolean dir) {
        this.dir = dir;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isDir() {
        return this.dir;
    }

    public List<DataSet> getPsbLibs() {
        return Collections.unmodifiableList(this.psbLibs);
    }

    public void setPsbLibs(List<DataSet> psbLibs) {
        if (psbLibs.size() > 6) {
            throw new IllegalArgumentException(psbLibs.toString());
        }
        this.psbLibs = new ArrayList<DataSet>(psbLibs);
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isPsbLibsUpdateable() {
        return this.psbLibsUpdateable;
    }

    public void setPsbLibsUpdateable(boolean psbLibsUpdateable) {
        this.psbLibsUpdateable = psbLibsUpdateable;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public List<DataSet> getDbdLibs() {
        return Collections.unmodifiableList(this.dbdLibs);
    }

    public void setDbdLibs(List<DataSet> dbdLibs) {
        if (dbdLibs.size() > 6) {
            throw new IllegalArgumentException(dbdLibs.toString());
        }
        this.dbdLibs = new ArrayList<DataSet>(dbdLibs);
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isDbdLibsUpdateable() {
        return this.dbdLibsUpdateable;
    }

    public void setDbdLibsUpdateable(boolean dbdLibsUpdateable) {
        this.dbdLibsUpdateable = dbdLibsUpdateable;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public List<DataSet> getTemplateLibs() {
        return Collections.unmodifiableList(this.templateLibs);
    }

    public void setTemplateLibs(List<DataSet> templateLibs) {
        if (templateLibs.size() > 6) {
            throw new IllegalArgumentException(templateLibs.toString());
        }
        this.templateLibs = new ArrayList<DataSet>(templateLibs);
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public boolean isTemplateLibsUpdateable() {
        return this.templateLibsUpdateable;
    }

    public void setTemplateLibsUpdateable(boolean templateLibsUpdateable) {
        this.templateLibsUpdateable = templateLibsUpdateable;
        this.eventDispatcher.fireChangedEvent(PROPERTY_SUBSYSTEM_CONFIG);
    }

    public TempDataSetAllocParamsDevType getLogAllocationParameters() {
        return this.logAllocationParameters;
    }

    public void setLogAllocationParameters(TempDataSetAllocParamsDevType logAllocationParamters) {
        this.logAllocationParameters = logAllocationParamters;
    }

    public TempDataSetAllocParamsDevType getXKeysAllocationParameters() {
        return this.xKeysAllocationParameters;
    }

    public void setXKeysAllocationParameters(TempDataSetAllocParamsDevType xKeysAllocationParameters) {
        this.xKeysAllocationParameters = xKeysAllocationParameters;
    }

    public TempDataSetAllocParamsVolumes getLogicalKeysAllocationParameters() {
        return this.logicalKeysAllocationParameters;
    }

    public void setLogicalKeysAllocationParameters(TempDataSetAllocParamsVolumes logicalKeysAllocationParameters) {
        this.logicalKeysAllocationParameters = logicalKeysAllocationParameters;
    }

    public TempDataSetAllocParamsVolumes getRootKeysAllocationParameters() {
        return this.rootKeysAllocationParameters;
    }

    public void setRootKeysAllocationParameters(TempDataSetAllocParamsVolumes rootKeysAllocationParameters) {
        this.rootKeysAllocationParameters = rootKeysAllocationParameters;
    }

    public void addListener(EListener<EntityEvent<ImsSubsystemConfig>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<ImsSubsystemConfig>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        return this.isCustom() ? "ims_subsystem_custom_config" : "ims_subsystem";
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public static enum ImsLogUsage {
        KEEP,
        KEEPWHENUPDATES,
        DELETE,
        NONE;

    }

    private static abstract class TempDataSetAllocParams {
        private String unit;
        private String primarySpace;
        private String secondarySpace;
        private String masterClass;
        private String storageClass;
        private String deviceClass;

        private TempDataSetAllocParams() {
        }

        protected void copyFrom(TempDataSetAllocParams params) {
            this.unit = params.unit;
            this.primarySpace = params.primarySpace;
            this.secondarySpace = params.secondarySpace;
            this.masterClass = params.masterClass;
            this.storageClass = params.storageClass;
            this.deviceClass = params.deviceClass;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public String getPrimarySpace() {
            return this.primarySpace;
        }

        public void setPrimarySpace(String primarySpace) {
            this.primarySpace = primarySpace;
        }

        public String getSecondarySpace() {
            return this.secondarySpace;
        }

        public void setSecondarySpace(String secondarySpace) {
            this.secondarySpace = secondarySpace;
        }

        public String getMasterClass() {
            return this.masterClass;
        }

        public void setMasterClass(String masterClass) {
            this.masterClass = masterClass;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public String getDeviceClass() {
            return this.deviceClass;
        }

        public void setDeviceClass(String deviceClass) {
            this.deviceClass = deviceClass;
        }
    }

    public static class TempDataSetAllocParamsDevType
    extends TempDataSetAllocParams {
        private String deviceType;

        public TempDataSetAllocParamsDevType() {
        }

        public TempDataSetAllocParamsDevType(TempDataSetAllocParamsDevType allocParams) {
            this.copyFrom(allocParams);
            this.deviceType = allocParams.getDeviceType();
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }
    }

    public static class TempDataSetAllocParamsVolumes
    extends TempDataSetAllocParams {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private String volume1;
        private String volume2;
        private String volume3;

        public TempDataSetAllocParamsVolumes() {
        }

        public TempDataSetAllocParamsVolumes(TempDataSetAllocParamsVolumes config) {
            this.copyFrom(config);
            this.volume1 = config.volume1;
            this.volume2 = config.volume2;
            this.volume3 = config.volume3;
        }

        public String getVolume1() {
            return this.volume1;
        }

        public void setVolume1(String volume1) {
            this.volume1 = volume1;
        }

        public String getVolume2() {
            return this.volume2;
        }

        public void setVolume2(String volume2) {
            this.volume2 = volume2;
        }

        public String getVolume3() {
            return this.volume3;
        }

        public void setVolume3(String volume3) {
            this.volume3 = volume3;
        }
    }
}

