/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.etools.fm.jhost.core.model.FMSubsystemType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class ImsSubsystem
extends PDPlatformObject
implements IEntityEventDispatcher<ImsSubsystem>,
IPDConnectEndpoint,
IZRL,
ImsSubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ImsSubsystem.class);
    public static final String FORMATTED_PREFIX = "IMS:";
    private final String ssid;
    private final Properties resourceProperties = new Properties();
    public static final String PATTERN_VALID_NAME = "[A-Z0-9#$@]{1,4}";
    private static final Pattern validRegexp = Pattern.compile("[A-Z0-9#$@]{1,4}");
    private static final Pattern parseableRegexp = Pattern.compile("^IMS:[A-Z0-9#$@]{1,4}$");
    private final EntityEventDispatcher<ImsSubsystem> eventDispatcher = new EntityEventDispatcher((Object)this);

    public static boolean isParseableSubsystem(String path, String codepage) {
        if (path == null) {
            return false;
        }
        if (path.trim().isEmpty()) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(path.trim().getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static ImsSubsystem parseSubsystem(IPDHost aHost, String path) {
        Objects.requireNonNull(aHost, "Must provide a non-null host.");
        Objects.requireNonNull(path, "Can't parse a null path.");
        if (path.trim().isEmpty()) {
            throw new IllegalArgumentException("Can't parse an empty path.");
        }
        if (!ImsSubsystem.isParseableSubsystem(path, aHost.getCodePage())) {
            throw new IllegalArgumentException(path + " is not parseable");
        }
        try {
            String ssid = path.trim().substring(FORMATTED_PREFIX.length());
            return new ImsSubsystem(aHost, ssid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(path + " " + e.getMessage());
        }
    }

    public static boolean isValidName(String fullName, String codepage) {
        if (fullName == null) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(fullName.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public ImsSubsystem(IPDHost host) {
        this(host, "");
    }

    public ImsSubsystem(IPDHost host, String ssid) {
        if (host == null) {
            throw new IllegalArgumentException("host can not be null.");
        }
        if (ssid == null) {
            throw new IllegalArgumentException("ssid can not be null.");
        }
        this.setSystem(host);
        this.ssid = ssid;
    }

    public ImsSubsystem(ImsSubsystem imsSubsystem) {
        this(imsSubsystem.getSystem(), imsSubsystem.ssid);
    }

    public ImsSubsystemConfig getCanonicalConfig() {
        return ((FMHost)FMHost.getSystem((IPDHost)this.getSystem())).getImsCanonicalConfig(this);
    }

    public void addCanonicalConfig(ImsSubsystemConfig anImsConfigFromRs) {
        ((FMHost)FMHost.getSystem((IPDHost)this.getSystem())).saveImsCanonicalConfig(anImsConfigFromRs);
    }

    public String toString() {
        return "ssid=" + this.ssid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getSystem() == null ? 0 : this.getSystem().hashCode());
        result = 31 * result + (this.ssid == null ? 0 : this.ssid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImsSubsystem)) {
            return false;
        }
        ImsSubsystem other = (ImsSubsystem)obj;
        if (this.getSystem() == null ? other.getSystem() != null : !this.getSystem().equals(other.getSystem())) {
            return false;
        }
        return !(this.ssid == null ? other.ssid != null : !this.ssid.equals(other.ssid));
    }

    public String getSubsystemID() {
        return this.ssid;
    }

    public void addListener(EListener<EntityEvent<ImsSubsystem>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<ImsSubsystem>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        ImsSubsystemConfig canonicalConfig = this.getCanonicalConfig();
        if (canonicalConfig == null) {
            throw new IllegalStateException("canonicalConfig is null.");
        }
        return canonicalConfig.isCustom() ? "ims_subsystem_custom_config" : "ims_subsystem";
    }

    public String getPDLabel() {
        ImsSubsystemConfig canonicalConfig = this.getCanonicalConfig();
        if (canonicalConfig == null) {
            throw new IllegalStateException("canonicalConfig is null");
        }
        return canonicalConfig.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getComponentName() {
        return FMSubsystemType.IMS.getComponentName();
    }

    public String copyName() {
        return this.getPDLabel();
    }

    public String getName() {
        return this.ssid;
    }

    public String getFormattedName() {
        return FORMATTED_PREFIX + this.ssid;
    }

    public String getPersistentProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Can not get property value for a null key");
        }
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public ImsSubsystem clone() {
        ImsSubsystem copy = new ImsSubsystem(this);
        for (Map.Entry<Object, Object> entry : this.resourceProperties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this;
    }

    public String getConfigurationID() {
        return "FM";
    }

    public boolean endPointPDHost(IPDHost pdHost) {
        return this.getSystem().equals(pdHost);
    }

    @Deprecated
    public CommonConnectionJhost getNewConnection(IPDHost pdHost, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        return this.getNewConnection(pdHost, null, monitor);
    }

    public CommonConnectionJhost getNewConnection(IPDHost pdHost, PDContext pdContext, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Result<StringBuffer> compileOptsUpdateResult;
        CommonConnectionFM chosenConnection = null;
        if (HostType.ZOS == pdHost.getHostType()) {
            chosenConnection = new ZosConnectionFM(pdHost, this, monitor);
            logger.debug((Object)("Established z/OS connection for endpoint " + String.valueOf(this) + " on system " + pdHost.toString()));
        }
        if (chosenConnection != null && !(compileOptsUpdateResult = chosenConnection.updateCompilerOptions(monitor)).isSuccessfulWithoutWarnings()) {
            logger.debug((Object)("Failed to set compiler options for endpoint " + String.valueOf(this) + " on system " + pdHost.toString()));
            chosenConnection = null;
        }
        return chosenConnection;
    }
}

