/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.Objects;

public class ImsResource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static boolean isParseable(IPDHost host, String formattedName) {
        if (ImsSubsystem.isParseableSubsystem(formattedName, host.getCodePage())) {
            return true;
        }
        if (ImsDatabase.isParseableDatabase(formattedName, host.getCodePage())) {
            return true;
        }
        if (ImsPsb.isParseablePsb(formattedName, host.getCodePage())) {
            return true;
        }
        return ImsPcb.isParseablePcb(formattedName, host.getCodePage());
    }

    public static IZRL parseImsResource(IPDHost aHost, String formattedName) {
        Objects.requireNonNull(aHost, "host can not be null.");
        if (ImsSubsystem.isParseableSubsystem(formattedName, aHost.getCodePage())) {
            return ImsSubsystem.parseSubsystem(aHost, formattedName);
        }
        if (ImsDatabase.isParseableDatabase(formattedName, aHost.getCodePage())) {
            return ImsDatabase.parseDatabase(aHost, formattedName);
        }
        if (ImsPsb.isParseablePsb(formattedName, aHost.getCodePage())) {
            return ImsPsb.parsePsb(aHost, formattedName);
        }
        if (ImsPcb.isParseablePcb(formattedName, aHost.getCodePage())) {
            return ImsPcb.parsePcb(aHost, formattedName);
        }
        throw new IllegalArgumentException(formattedName);
    }
}

