/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsRegionTypeProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.jhost.core.util.ConversionUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventRemoteDispatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ImsRegionConfig
implements ImsSubsystemProvider,
IEntityEventRemoteDispatcher,
ImsRegionTypeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final Object PROPERTY_REGION_CONFIG = new Object();
    public static final String LOCK_MAX = "lockmax";
    public static final int LOCK_MAX_MIN = 0;
    public static final int LOCK_MAX_MAX = Short.MAX_VALUE;
    public static final String AUTO_SAVE = "autosave";
    public static final String EDITF = "editf";
    public static final int EDITF_MIN = 1;
    public static final int EDITF_MAX = 99;
    public static final String CRALL = "crall";
    public static final int CRALL_MIN = 1;
    public static final int CRALL_MAX = 9999;
    public static final String LOAD = "load";
    public static final int LOAD_MIN = 1;
    public static final int LOAD_MAX = 99999;
    public static final String BEDITF = "beditf";
    public static final int BEDITF_MIN = 1;
    public static final int BEDITF_MAX = 99999;
    public static final String PSB_BR = "PSBbr";
    public static final String PSB_EX = "PSBex";
    public static final String PSB_PR = "PSBpr";
    public static final String PSB_BB = "PSBbb";
    private final ImsSubsystemConfig subsystemConfig;
    private boolean staticAccessSupported = true;
    private boolean dynamicAccessSupported = true;
    private boolean readOnly = true;
    private Map<String, String> settingValues = new HashMap<String, String>();
    private Set<String> readOnlySettings = new HashSet<String>();
    private final ImsRegionType regionType;
    private Object remoteListener = null;

    public ImsRegionConfig(ImsSubsystemConfig subsystem, ImsRegionType regionType) {
        this.subsystemConfig = subsystem;
        this.regionType = regionType;
        this.readOnlySettings = this.getDefaultReadOnlySettings();
    }

    public ImsSubsystemConfig getSubsystemConfig() {
        return this.subsystemConfig;
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    public IPDHost getSystem() {
        return this.subsystemConfig.getSystem();
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.subsystemConfig.getSubsystem();
    }

    protected void copyFrom(ImsRegionConfig config) {
        this.setStaticAccessSupported(config.staticAccessSupported);
        this.setDynamicAccessSupported(config.dynamicAccessSupported);
        this.setReadOnly(config.readOnly);
        this.setSettingValues(config.settingValues);
        this.setReadOnlySettings(config.readOnlySettings);
    }

    public abstract String getRegionTypeLabel();

    protected abstract EntityEventDispatcher<? extends ImsRegionConfig> getEventDispatcher();

    public abstract boolean isConnectable();

    protected Set<String> getDefaultReadOnlySettings() {
        return Collections.emptySet();
    }

    public boolean isAccessModeSupported(ImsAccessMode accessMode) {
        switch (accessMode) {
            case STATIC: {
                return this.isStaticAccessSupported();
            }
            case DYNAMIC: {
                return this.isDynamicAccessSupported();
            }
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dynamicAccessSupported ? 1231 : 1237);
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        result = 31 * result + (this.readOnlySettings == null ? 0 : this.readOnlySettings.hashCode());
        result = 31 * result + (this.settingValues == null ? 0 : this.settingValues.hashCode());
        result = 31 * result + (this.staticAccessSupported ? 1231 : 1237);
        result = 31 * result + (this.subsystemConfig == null ? 0 : this.subsystemConfig.hashCode());
        result = 31 * result + (this.regionType == null ? 0 : this.regionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImsRegionConfig other = (ImsRegionConfig)obj;
        if (this.dynamicAccessSupported != other.dynamicAccessSupported) {
            return false;
        }
        if (this.readOnly != other.readOnly) {
            return false;
        }
        if (this.readOnlySettings == null ? other.readOnlySettings != null : !this.readOnlySettings.equals(other.readOnlySettings)) {
            return false;
        }
        if (this.settingValues == null ? other.settingValues != null : !this.settingValues.equals(other.settingValues)) {
            return false;
        }
        if (this.staticAccessSupported != other.staticAccessSupported) {
            return false;
        }
        if (this.subsystemConfig == null ? other.subsystemConfig != null : !this.subsystemConfig.equals(other.subsystemConfig)) {
            return false;
        }
        return !(this.regionType == null ? other.regionType != null : !this.regionType.equals((Object)other.regionType));
    }

    public boolean isStaticAccessSupported() {
        return this.staticAccessSupported;
    }

    public void setStaticAccessSupported(boolean staticPsbsSupported) {
        this.staticAccessSupported = staticPsbsSupported;
        this.getEventDispatcher().fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isDynamicAccessSupported() {
        return this.dynamicAccessSupported;
    }

    public void setDynamicAccessSupported(boolean dynamicPsbsSupported) {
        this.dynamicAccessSupported = dynamicPsbsSupported;
        this.getEventDispatcher().fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.getEventDispatcher().fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public String getSettingValue(String key) {
        String val = this.settingValues.get(key);
        return val == null ? "" : val;
    }

    protected void setSettingValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.settingValues.put(key, value);
        this.getEventDispatcher().fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public Map<String, String> getSettingValues() {
        return Collections.unmodifiableMap(this.settingValues);
    }

    public void setSettingValues(Map<String, String> settingValues) {
        this.settingValues = new HashMap<String, String>(settingValues);
        this.getEventDispatcher().fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public Set<String> getReadOnlySettings() {
        return Collections.unmodifiableSet(this.readOnlySettings);
    }

    public void setReadOnlySettings(Set<String> settingUpdatibility) {
        this.readOnlySettings = new HashSet<String>(settingUpdatibility);
        this.getEventDispatcher().fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public String getLockMax() {
        return this.getSettingValue(LOCK_MAX);
    }

    public void setLockMax(String lockMax) {
        this.ensureArgIsEmptyOrIntInRange(lockMax, 0, Short.MAX_VALUE);
        this.setSettingValue(LOCK_MAX, lockMax);
    }

    public boolean isAutoSave() {
        return "Y".equals(this.getSettingValue(AUTO_SAVE));
    }

    public void setAutoSave(boolean autoSave) {
        this.setSettingValue(AUTO_SAVE, autoSave ? "Y" : "N");
    }

    public String getEditCheckpointFrequency() {
        return this.getSettingValue(EDITF);
    }

    public void setEditCheckpointFrequency(String editF) {
        this.ensureArgIsEmptyOrIntInRange(editF, 1, 99);
        this.setSettingValue(EDITF, editF);
    }

    public String getChangeRepeatAllCheckpointFrequency() {
        return this.getSettingValue(CRALL);
    }

    public void setChangeRepeatAllCheckpointFrequency(String crall) {
        this.ensureArgIsEmptyOrIntInRange(crall, 1, 9999);
        this.setSettingValue(CRALL, crall);
    }

    public String getLoadCheckpointFrequency() {
        return this.getSettingValue(LOAD);
    }

    public void setLoadCheckpointFrequency(String load) {
        this.ensureArgIsEmptyOrIntInRange(load, 1, 99999);
        this.setSettingValue(LOAD, load);
    }

    public String getBatchEditCheckpointFrequency() {
        return this.getSettingValue(BEDITF);
    }

    public void setBatchEditCheckpointFrequency(String beditf) {
        this.ensureArgIsEmptyOrIntInRange(beditf, 1, 99999);
        this.setSettingValue(BEDITF, beditf);
    }

    public boolean isBrowseIntegrityMaintained() {
        return "G".equals(this.getSettingValue(PSB_BR));
    }

    public void setBrowseIntegrityMaintained(boolean psbBr) {
        this.setSettingValue(PSB_BR, psbBr ? "G" : "GO");
    }

    public boolean isExtractIntegrityMaintained() {
        return "G".equals(this.getSettingValue(PSB_EX));
    }

    public void setExtractIntegrityMaintained(boolean psbEx) {
        this.setSettingValue(PSB_EX, psbEx ? "G" : "GO");
    }

    public boolean isPrintIntegrityMaintained() {
        return "G".equals(this.getSettingValue(PSB_PR));
    }

    public void setPrintIntegrityMaintained(boolean psbPr) {
        this.setSettingValue(PSB_PR, psbPr ? "G" : "GO");
    }

    public boolean isBatchBrowseIntegrityMaintained() {
        return "G".equals(this.getSettingValue(PSB_BB));
    }

    public void setBatchBrowseIntegrityMaintained(boolean psbBb) {
        this.setSettingValue(PSB_BB, psbBb ? "G" : "GO");
    }

    protected void ensureArgIsEmptyOrIntInRange(String val, int min, int max) {
        if (val.isEmpty()) {
            return;
        }
        if (!ConversionUtil.isInt((String)val)) {
            throw new IllegalArgumentException(val);
        }
        int intVal = ConversionUtil.toInt((String)val);
        if (intVal < min || intVal > max) {
            throw new IllegalArgumentException(val);
        }
    }

    public Object getLoadFinishedListener() {
        return this.remoteListener;
    }

    public void setLoadFinishedListener(Object listener) {
        this.remoteListener = listener;
    }
}

