/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsRegionSpecificQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsRegionTypeProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.Objects;

public abstract class ImsQuery
extends PDPlatformObject
implements ImsRegionSpecificQuery,
ImsRegionTypeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String pattern;
    private final ImsSubsystem subsystem;
    private final ImsRegionType regionType;
    private final ImsAccessMode accessMode;

    public ImsQuery(ImsSubsystem subsystem, String pattern, ImsRegionType regionType, ImsAccessMode accessMode) {
        this.subsystem = Objects.requireNonNull(subsystem, "Please specify a non-null subsystem.");
        if (pattern == null || pattern.isEmpty()) {
            pattern = "*";
        }
        this.pattern = pattern;
        if (regionType == null) {
            regionType = ImsRegionType.BMP;
        }
        this.regionType = regionType;
        if (accessMode == null) {
            accessMode = ImsAccessMode.STATIC;
        }
        this.accessMode = accessMode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImsQuery)) {
            return false;
        }
        ImsQuery other = (ImsQuery)o;
        return this.regionType == other.regionType && this.accessMode == other.accessMode && this.pattern.equals(other.pattern) && this.subsystem.equals(other.subsystem);
    }

    public int hashCode() {
        int result = 37;
        result = 37 * result + this.subsystem.hashCode();
        result = 37 * result + this.pattern.hashCode();
        if (this.regionType != null) {
            result = 37 * result + this.regionType.hashCode();
        }
        if (this.accessMode != null) {
            result = 37 * result + this.accessMode.hashCode();
        }
        return result;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public IPDHost getSystem() {
        return this.subsystem.getSystem();
    }

    public void setSystem(IPDHost system) {
        this.subsystem.setSystem(system);
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.subsystem;
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    public ImsAccessMode getAccessMode() {
        return this.accessMode;
    }
}

