/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsRegionTypeProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.socket.func.DSFMParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.XDBDL;
import com.ibm.etools.fm.core.socket.func.ims.XPSBL;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ImsPsb
extends PDPlatformObject
implements ImsSubsystemProvider,
IZRL,
ImsRegionTypeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Properties resourceProperties = new Properties();
    public static final String IMS_PSB_PREFIX = ":PSB:";
    private static final Pattern parseableRegexp = Pattern.compile("^IMS:[A-Z0-9#$@]{1,4}:PSB:[-!#$\ufffd&_=+{}a-zA-Z0-9@]{1,8}$");
    private final ImsSubsystem subsystem;
    private final String name;
    private final ImsRegionType regionType;

    public static boolean isValidName(String name, String codepage) {
        Objects.requireNonNull(name, "Must provide a non-null name.");
        return Member.isValidName(name, codepage);
    }

    public static boolean isParseablePsb(String path, String codepage) {
        if (path == null) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static ImsPsb parsePsb(IPDHost aHost, String path) {
        Objects.requireNonNull(path, "Must provide a non-null path String.");
        if (!ImsPsb.isParseablePsb(path, aHost.getCodePage())) {
            throw new IllegalArgumentException(path);
        }
        try {
            StringTokenizer st = new StringTokenizer(path, ":");
            st.nextToken();
            String ssid = st.nextToken();
            st.nextToken();
            String psbName = st.nextToken();
            return new ImsPsb(new ImsSubsystem(aHost, ssid), psbName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(path);
        }
    }

    public ImsPsb(ImsSubsystem subsystem, String name) {
        this(subsystem, name, ImsRegionType.BMP);
    }

    public ImsPsb(ImsSubsystem subsystem, String name, ImsRegionType regionType) {
        Objects.requireNonNull(subsystem, "Please provide a non-null subsystem.");
        if (!ImsPsb.isValidName(name, subsystem.getSystem().getCodePage())) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        this.subsystem = subsystem;
        this.name = name;
        this.regionType = regionType != null ? regionType : ImsRegionType.BMP;
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ImsPsb:name=" + this.name;
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.subsystem;
    }

    public IPDHost getSystem() {
        return this.subsystem.getSystem();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImsPsb)) {
            return false;
        }
        ImsPsb other = (ImsPsb)o;
        return this.name.equals(other.name) && this.subsystem.equals(other.subsystem);
    }

    public int hashCode() {
        int result = 37;
        result = result * 37 + this.name.hashCode();
        result = result * 37 + this.subsystem.hashCode();
        return result;
    }

    public static List<ImsPsb> loadPSBs(ImsPsbQuery entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(entity, "Must provide a non-null entity.");
        Result<List<Member>> result = ImsPsb.loadPSBsResults(entity, monitor);
        ArrayList<ImsPsb> psbs = new ArrayList<ImsPsb>();
        for (Member member : (List)result.getOutput()) {
            psbs.add(new ImsPsb(entity.getSubsystem(), member.getName(), entity.getRegionType()));
        }
        return psbs;
    }

    public static Result<List<Member>> loadPSBsResults(ImsPsbQuery entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Result result;
        Objects.requireNonNull(entity, "Must provide a non-null entity.");
        ImsSubsystemConfig config = entity.getSubsystem().getCanonicalConfig();
        ArrayList<String> dsns = new ArrayList<String>();
        if (!config.isDir()) {
            List<DataSet> psbLibs = config.getPsbLibs();
            for (DataSet dataSet : psbLibs) {
                dsns.add(dataSet.getFormattedName());
            }
        }
        if (entity.getAccessMode() == ImsAccessMode.DYNAMIC) {
            XDBDL dbdl = new XDBDL();
            dbdl.setRegnType(entity.getRegionType());
            dbdl.setMember(entity.getPattern());
            dbdl.setIMSID(config.getSubsystem().getSubsystemID());
            dbdl.setConfig(config);
            result = UtilityFunctionRunner.executeAndParse(entity.getSystem(), entity.getSubsystem(), dbdl, new DSFMParser(entity.getSystem(), dsns), monitor);
        } else {
            XPSBL psbl = new XPSBL();
            psbl.setRegnType(entity.getRegionType());
            psbl.setMember(entity.getPattern());
            psbl.setIMSID(config.getSubsystem().getSubsystemID());
            psbl.setConfig(config);
            result = UtilityFunctionRunner.executeAndParse(entity.getSystem(), entity.getSubsystem(), psbl, new DSFMParser(entity.getSystem(), dsns), monitor);
        }
        return result;
    }

    public String getPDImageName() {
        return "ims_psb";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public ImsPsb clone() {
        ImsPsb copy = new ImsPsb(this.subsystem, this.name);
        for (Map.Entry<Object, Object> entry : this.resourceProperties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    public String copyName() {
        return this.getPDLabel();
    }

    public String getFormattedName() {
        return this.getSubsystem().getFormattedName() + IMS_PSB_PREFIX + this.name;
    }
}

