/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.PCBL;
import com.ibm.etools.fm.core.socket.func.ims.PCBLParser;
import com.ibm.etools.fm.core.socket.func.ims.PCBN;
import com.ibm.etools.fm.core.socket.func.ims.PCBNParser;
import com.ibm.etools.fm.core.socket.func.ims.RelatedDBToPCBMapping;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ImsPcb
implements ImsSubsystemProvider,
IPDPlatformObject,
IZRL {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Properties resourceProperties = new Properties();
    private static final String IMS_PCB_PREFIX = ":PCB:";
    private static final String IMS_PCB_INDEX_PATTERN = ":[0-9]+";
    private static final Pattern parseableRegexp = Pattern.compile("^IMS:[A-Z0-9#$@]{1,4}:PSB:[-!#$\ufffd&_=+{}a-zA-Z0-9@]{1,8}:PCB:[-!#$\ufffd&_=+{}a-zA-Z0-9@]{1,8}:[0-9]+$");
    private final ImsPsb psb;
    private final String name;
    private final String index;
    private ImsDatabase dbd;
    private String note;
    private String segp;
    private String segd;
    private String type;
    private String procopts;
    private String procseq;

    public static boolean isValidName(String name) {
        Objects.requireNonNull(name, "Please provide a non-null name.");
        return true;
    }

    public static boolean isParseablePcb(String path, String codepage) {
        if (path == null) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static ImsPcb parsePcb(IPDHost aHost, String path) {
        if (aHost == null) {
            throw new IllegalArgumentException("Please specify a non-null host.");
        }
        Objects.requireNonNull(path, "Must provide a non-null path.");
        if (!ImsPcb.isParseablePcb(path, aHost.getCodePage())) {
            throw new IllegalArgumentException(path);
        }
        try {
            StringTokenizer st = new StringTokenizer(path, ":");
            st.nextToken();
            String ssid = st.nextToken();
            st.nextToken();
            String psbName = st.nextToken();
            st.nextToken();
            String pcbName = st.nextToken();
            String pcbIndex = st.nextToken();
            return new ImsPcb(new ImsPsb(new ImsSubsystem(aHost, ssid), psbName), pcbName, pcbIndex);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(path);
        }
    }

    public ImsPcb(ImsPsb psb, String name, String index) {
        Objects.requireNonNull(psb, "Must provide a non-null psb");
        if (!ImsPcb.isValidName(name)) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        this.psb = psb;
        this.name = name;
        this.index = index;
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.psb.getSubsystem();
    }

    public IPDHost getSystem() {
        return this.psb.getSystem();
    }

    public String getLabel() {
        return MessageFormat.format(Messages.ImsPcb_PCB_NUM_X_Y_DB_Z, this.getIndex(), this.getName(), this.getDbd().getName());
    }

    public String toString() {
        return MessageFormat.format("ImsPcb:psb=[{0}],index={1},name={2},dbd=[{3}]", this.psb, this.index, this.name, this.dbd);
    }

    public String getIndex() {
        return this.index;
    }

    public ImsPsb getPsb() {
        return this.psb;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImsPcb)) {
            return false;
        }
        ImsPcb other = (ImsPcb)o;
        return this.name.equals(other.name) && this.index.equals(other.index) && this.psb.equals(other.psb);
    }

    public int hashCode() {
        int result = 37;
        result += 37 * result + this.psb.hashCode();
        result += 37 * result + this.name.hashCode();
        result += 37 * result + this.index.hashCode();
        return result;
    }

    public ImsDatabase getDbd() {
        return this.dbd;
    }

    public void setDbdName(String dbdName) {
        this.dbd = new ImsDatabase(this.getSubsystem(), dbdName);
    }

    public String getUseabilityNote() {
        return this.note;
    }

    public void setUseabilityNote(String note) {
        this.note = note;
    }

    public String getSegp() {
        return this.segp;
    }

    public void setSegp(String segp) {
        this.segp = segp;
    }

    public String getSegd() {
        return this.segd;
    }

    public void setSegd(String segd) {
        this.segd = segd;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProcopts() {
        return this.procopts;
    }

    public void setProcopts(String procopts) {
        this.procopts = procopts;
    }

    public String getProcseq() {
        return this.procseq;
    }

    public void setProcseq(String procseq) {
        this.procseq = procseq;
    }

    public static List<ImsPcb> loadPCBsFiltered(IHowIsGoing monitor, ImsSubsystem subSystem, ImsSubsystemConfig config, ImsRegionType regionType, String psbMember, String dbdMember, String functionCode) throws InterruptedException, CommunicationException {
        PCBL pcbl = new PCBL();
        ImsPsb psb = new ImsPsb(subSystem, psbMember);
        pcbl.setPsb(psb, regionType);
        pcbl.setFunctionCode(functionCode);
        pcbl.setDBDMEM(dbdMember);
        pcbl.setConfig(config);
        Result result = UtilityFunctionRunner.executeAndParse(subSystem.getSystem(), subSystem, pcbl, new PCBLParser(psb), monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            String err = ImsPcb.removeFMNBB291(result.getMessagesCombined().toString());
            PDLogger.get(ImsPcb.class).trace((Object)err);
            Throwable throwable = null;
            Object var12_13 = null;
            try {
                CommonConnectionFM connection = (CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(subSystem.getSystem(), subSystem, monitor);
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throw new CommunicationException(err);
        }
        List list = (List)result.getOutput();
        return list;
    }

    public static List<RelatedDBToPCBMapping> loadRelatedDatabasePCBs(IHowIsGoing monitor, ImsSubsystem subSystem, ImsSubsystemConfig config, ImsRegionType regionType, String psbMember, String dbdMember, String functionCode, String pcbNum) throws InterruptedException, CommunicationException {
        PCBN pcbn = new PCBN();
        ImsPsb psb = new ImsPsb(subSystem, psbMember);
        pcbn.setPsb(psb, regionType);
        pcbn.setFunctionCode(functionCode);
        pcbn.setDBDMEM(dbdMember);
        pcbn.setPCBNum(pcbNum);
        pcbn.setConfig(config);
        Result result = UtilityFunctionRunner.executeAndParse(subSystem.getSystem(), subSystem, pcbn, new PCBNParser(psb), monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            String err = ImsPcb.removeFMNBB291(result.getMessagesCombined().toString());
            PDLogger.get(ImsPcb.class).trace((Object)err);
            throw new CommunicationException(err);
        }
        List list = (List)result.getOutput();
        return list;
    }

    private static String removeFMNBB291(String msg) {
        return msg.replace("FMNBB291 Function terminated\nFMNBB291 The user canceled the function, or the function could not be performed", "");
    }

    public String getPDImageName() {
        return "ims_pcb";
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }

    public String getFormattedName() {
        return this.psb.getFormattedName() + IMS_PCB_PREFIX + this.name + ":" + this.index;
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public ImsPcb clone() {
        ImsPcb copy = new ImsPcb(this.psb.clone(), this.name, this.index);
        for (Object key : this.resourceProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.resourceProperties.get(key).toString());
        }
        copy.dbd = this.dbd;
        copy.note = this.note;
        copy.segp = this.segp;
        copy.segd = this.segd;
        copy.type = this.type;
        copy.procopts = this.procopts;
        copy.procseq = this.procseq;
        return copy;
    }
}

